/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.api.API;
import org.apache.synapse.api.version.ContextVersionStrategy;
import org.apache.synapse.api.version.DefaultStrategy;
import org.apache.synapse.api.version.URLBasedVersionStrategy;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;

public abstract class AbstractApiHandler {
    private static final Log log = LogFactory.getLog(AbstractApiHandler.class);

    public abstract boolean process(MessageContext var1);

    protected abstract boolean dispatchToAPI(MessageContext var1);

    protected boolean dispatchToAPI(Collection<API> apiSet, MessageContext synCtx) {
        ArrayList<API> defaultStrategyApiSet = new ArrayList<API>(apiSet);
        API defaultAPI = null;
        Object apiObject = synCtx.getProperty("PROCESSED_API");
        if (apiObject != null) {
            if (this.identifyAPI((API)apiObject, synCtx, defaultStrategyApiSet)) {
                return true;
            }
        } else {
            for (API api : apiSet) {
                if (!this.identifyAPI(api, synCtx, defaultStrategyApiSet)) continue;
                return true;
            }
        }
        for (API api : defaultStrategyApiSet) {
            api.setLogSetterValue();
            if (!api.canProcess(synCtx)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Located specific API: " + api.getName() + " for processing message"));
            }
            this.apiProcess(synCtx, api);
            return true;
        }
        if (defaultAPI != null && defaultAPI.canProcess(synCtx)) {
            defaultAPI.setLogSetterValue();
            this.apiProcess(synCtx, defaultAPI);
            return true;
        }
        return false;
    }

    protected void apiProcess(MessageContext synCtx, API api) {
        Integer statisticReportingIndex = 0;
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, api.getAPIName(), api.getAspectConfiguration(), ComponentType.API);
            api.process(synCtx);
            CloseEventCollector.tryEndFlow(synCtx, api.getAPIName(), ComponentType.API, statisticReportingIndex, true);
        } else {
            api.process(synCtx);
        }
    }

    protected void apiProcessNonDefaultStrategy(MessageContext synCtx, API api) {
        Integer statisticReportingIndex = 0;
        if (RuntimeStatisticCollector.isStatisticsEnabled()) {
            statisticReportingIndex = OpenEventCollector.reportEntryEvent(synCtx, api.getAPIName() + "_" + api.getVersion(), api.getAspectConfiguration(), ComponentType.API);
            api.process(synCtx);
            CloseEventCollector.tryEndFlow(synCtx, api.getAPIName(), ComponentType.API, statisticReportingIndex, true);
        } else {
            api.process(synCtx);
        }
    }

    protected boolean identifyAPI(API api, MessageContext synCtx, List defaultStrategyApiSet) {
        API defaultAPI = null;
        api.setLogSetterValue();
        if ("/".equals(api.getContext())) {
            defaultAPI = api;
        } else if (api.getVersionStrategy().getClass().getName().equals(DefaultStrategy.class.getName())) {
            defaultStrategyApiSet.add(api);
        } else if (api.getVersionStrategy().getClass().getName().equals(ContextVersionStrategy.class.getName()) || api.getVersionStrategy().getClass().getName().equals(URLBasedVersionStrategy.class.getName())) {
            api.setLogSetterValue();
            if (api.canProcess(synCtx)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Located specific API: " + api.getName() + " for processing message"));
                }
                this.apiProcessNonDefaultStrategy(synCtx, api);
                return true;
            }
        } else if (api.canProcess(synCtx)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Located specific API: " + api.getName() + " for processing message"));
            }
            api.process(synCtx);
            return true;
        }
        return false;
    }
}

