/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.api.AbstractRequestProcessor;
import org.apache.synapse.api.ApiConstants;
import org.apache.synapse.api.ApiUtils;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.RESTDispatcher;
import org.apache.synapse.api.version.DefaultStrategy;
import org.apache.synapse.api.version.URLBasedVersionStrategy;
import org.apache.synapse.api.version.VersionStrategy;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.Handler;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.http.conn.SynapseWireLogHolder;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.util.logging.LoggingUtils;

public class API
extends AbstractRequestProcessor
implements ManagedLifecycle,
AspectConfigurable,
SynapseArtifact {
    private String host;
    private int port = -1;
    private String context;
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private List<Handler> handlers = new ArrayList<Handler>();
    private String swaggerResourcePath;
    private String description;
    private int protocol = 0;
    private VersionStrategy versionStrategy = new DefaultStrategy(this);
    private String fileName;
    private Set<String> bindsTo = new HashSet<String>();
    private Log apiLog;
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private int traceState = 2;
    private String artifactContainerName;
    private boolean isEdited = false;
    private AspectConfiguration aspectConfiguration;
    private List<String> commentsList = new ArrayList<String>();

    public API(String name, String context) {
        super(name);
        this.setContext(context);
    }

    public void setContext(String context) {
        if (!context.startsWith("/")) {
            this.handleException("API context must begin with '/' character");
        }
        this.context = ApiUtils.trimTrailingSlashes(context);
        this.apiLog = LogFactory.getLog((String)("API_LOGGER." + this.name));
    }

    public void setArtifactContainerName(String name) {
        this.artifactContainerName = name;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public void setLogSetterValue() {
        CustomLogSetter.getInstance().setLogAppender(this.artifactContainerName);
    }

    public String getName() {
        if (this.versionStrategy.getVersion() != null && !"".equals(this.versionStrategy.getVersion())) {
            return this.name + ":v" + this.versionStrategy.getVersion();
        }
        return this.name;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public String getAPIName() {
        return this.name;
    }

    public String getVersion() {
        return this.versionStrategy.getVersion();
    }

    public String getContext() {
        return this.context;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<String> getCommentsList() {
        return this.commentsList;
    }

    public void setCommentsList(List<String> commentsList) {
        this.commentsList = commentsList;
    }

    public String getSwaggerResourcePath() {
        return this.swaggerResourcePath;
    }

    public void setSwaggerResourcePath(String swaggerResourcePath) {
        this.swaggerResourcePath = swaggerResourcePath;
    }

    public void addResource(Resource resource) {
        DispatcherHelper dispatcherHelper = resource.getDispatcherHelper();
        if (dispatcherHelper != null) {
            String mapping = dispatcherHelper.getString();
            for (Resource r : this.resources.values()) {
                DispatcherHelper helper = r.getDispatcherHelper();
                if (helper == null || !helper.getString().equals(mapping) || !this.resourceMatches(resource, r)) continue;
                this.handleException("Two resources cannot have the same path mapping and methods");
            }
        } else {
            for (Resource r : this.resources.values()) {
                DispatcherHelper helper = r.getDispatcherHelper();
                if (helper != null) continue;
                this.handleException("Only one resource can be designated as default");
            }
        }
        this.resources.put(resource.getName(), resource);
    }

    private boolean resourceMatches(Resource r1, Resource r2) {
        String[] methods1 = r1.getMethods();
        String[] methods2 = r2.getMethods();
        for (String m1 : methods1) {
            for (String m2 : methods2) {
                if (!m1.equals(m2)) continue;
                return true;
            }
        }
        return false;
    }

    public Resource[] getResources() {
        return this.resources.values().toArray(new Resource[this.resources.size()]);
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    public Set<String> getBindsTo() {
        return this.bindsTo;
    }

    public void addBindsTo(String inboundEndpointName) {
        this.bindsTo.add(inboundEndpointName);
    }

    public void addAllBindsTo(Set<String> inboundEndpointBindings) {
        this.bindsTo.addAll(inboundEndpointBindings);
    }

    @Override
    public boolean canProcess(MessageContext synCtx) {
        if (synCtx.isResponse()) {
            String version;
            String apiName = (String)synCtx.getProperty("SYNAPSE_REST_API");
            String string = version = synCtx.getProperty("SYNAPSE_REST_API_VERSION") == null ? "" : (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
            if (!this.getName().equals(apiName) || !this.versionStrategy.getVersion().equals(version)) {
                return false;
            }
        } else {
            String path = ApiUtils.getFullRequestPath(synCtx);
            if (null == synCtx.getProperty("IS_PROMETHEUS_ENGAGED") && !ApiUtils.matchApiPath(path, this.context)) {
                this.auditDebug("API context: " + this.context + " does not match request URI: " + path);
                return false;
            }
            if (!this.versionStrategy.isMatchingVersion(synCtx)) {
                return false;
            }
            org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            if (this.host != null || this.port != -1) {
                String hostHeader = this.getHostHeader(msgCtx);
                if (hostHeader != null) {
                    if (this.host != null && !this.host.equals(this.extractHostName(hostHeader))) {
                        this.auditDebug("API host: " + this.host + " does not match host information in the request: " + hostHeader);
                        return false;
                    }
                    if (this.port != -1 && this.port != this.extractPortNumber(hostHeader, msgCtx.getIncomingTransportName())) {
                        this.auditDebug("API port: " + this.port + " does not match port information in the request: " + hostHeader);
                        return false;
                    }
                } else {
                    this.auditDebug("Host information not available on the message");
                    return false;
                }
            }
            if (this.protocol == 1 && !"http".equals(msgCtx.getIncomingTransportName())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Protocol information does not match - Expected HTTP");
                }
                synCtx.setProperty("TRANSPORT_DENIED", new Boolean(true));
                synCtx.setProperty("IN_TRANSPORT", msgCtx.getTransportIn().getName());
                this.log.warn((Object)("Trying to access API : " + this.name + " on restricted transport chanel [" + msgCtx.getTransportIn().getName() + "]"));
                return false;
            }
            if (this.protocol == 2 && !"https".equals(msgCtx.getIncomingTransportName())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Protocol information does not match - Expected HTTPS");
                }
                synCtx.setProperty("TRANSPORT_DENIED", new Boolean(true));
                synCtx.setProperty("IN_TRANSPORT", msgCtx.getTransportIn().getName());
                this.log.warn((Object)("Trying to access API : " + this.name + " on restricted transport chanel [" + msgCtx.getTransportIn().getName() + "]"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void process(MessageContext synCtx) {
        Object context;
        Map headers;
        this.auditDebug("Processing message with ID: " + synCtx.getMessageID() + " through the API: " + this.name);
        synCtx.setProperty("PROCESSED_API", this);
        synCtx.setProperty("SYNAPSE_REST_API", this.getName());
        synCtx.setProperty("SYNAPSE_REST_API_VERSION", this.versionStrategy.getVersion());
        synCtx.setProperty("REST_API_CONTEXT", this.context);
        synCtx.setProperty("SYNAPSE_REST_API_VERSION_STRATEGY", this.versionStrategy.getVersionType());
        synCtx.setProperty("ARTIFACT_NAME", "api" + this.getName());
        ((Axis2MessageContext)synCtx).setServiceLog(this.apiLog);
        String restURLPostfix = (String)synCtx.getProperty("REST_FULL_REQUEST_PATH");
        if (!synCtx.isResponse() && restURLPostfix != null) {
            if (!restURLPostfix.startsWith("/")) {
                restURLPostfix = "/" + restURLPostfix;
            }
            if (restURLPostfix.startsWith(this.context)) {
                restURLPostfix = restURLPostfix.substring(this.context.length());
            }
            if (this.versionStrategy instanceof URLBasedVersionStrategy) {
                String version = this.versionStrategy.getVersion();
                if (restURLPostfix.startsWith(version)) {
                    restURLPostfix = restURLPostfix.substring(version.length());
                } else if (restURLPostfix.startsWith("/" + version)) {
                    restURLPostfix = restURLPostfix.substring(version.length() + 1);
                }
            }
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("REST_URL_POSTFIX", (Object)restURLPostfix);
        }
        if (synCtx.isResponse() && (headers = (Map)(context = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null) {
            headers.put(PassThroughConfiguration.getInstance().getCorrelationHeaderName(), context.getProperty("correlation_id"));
        }
        for (Handler handler : this.handlers) {
            this.auditDebug("Processing message with ID: " + synCtx.getMessageID() + " through handler: " + handler.getClass().getName());
            boolean proceed = synCtx.isResponse() ? handler.handleResponse(synCtx) : handler.handleRequest(synCtx);
            if (proceed) continue;
            return;
        }
        if (synCtx.isResponse()) {
            String resourceName = (String)synCtx.getProperty("SYNAPSE_RESOURCE");
            if (resourceName != null) {
                Resource resource = this.resources.get(resourceName);
                if (resource != null) {
                    resource.process(synCtx);
                }
            } else if (this.log.isDebugEnabled()) {
                this.auditDebug("No resource information on the response: " + synCtx.getMessageID());
            }
            return;
        }
        String path = ApiUtils.getFullRequestPath(synCtx);
        String subPath = this.versionStrategy.getVersionType().equals("url") ? path.substring(this.context.length() + this.versionStrategy.getVersion().length() + 1) : path.substring(this.context.length());
        if ("".equals(subPath)) {
            subPath = "/";
        }
        synCtx.setProperty("REST_SUB_REQUEST_PATH", subPath);
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String hostHeader = this.getHostHeader(msgCtx);
        if (hostHeader != null) {
            synCtx.setProperty("REST_URL_PREFIX", msgCtx.getIncomingTransportName() + "://" + hostHeader);
        }
        LinkedHashSet<Resource> acceptableResources = new LinkedHashSet<Resource>();
        for (Resource resource : this.resources.values()) {
            if (!this.isBound(resource, synCtx) || !resource.canProcess(synCtx)) continue;
            acceptableResources.add(resource);
        }
        boolean processed = false;
        if (!acceptableResources.isEmpty()) {
            for (RESTDispatcher dispatcher : ApiUtils.getDispatchers()) {
                Resource resource = dispatcher.findResource(synCtx, acceptableResources);
                if (resource == null) continue;
                if (synCtx.getEnvironment().isDebuggerEnabled() && !synCtx.isResponse()) {
                    SynapseWireLogHolder wireLogHolder = (SynapseWireLogHolder)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("synapse.wire.log.holder");
                    if (wireLogHolder == null) {
                        wireLogHolder = new SynapseWireLogHolder();
                    }
                    if (synCtx.getProperty("SYNAPSE_REST_API") != null && !synCtx.getProperty("SYNAPSE_REST_API").toString().isEmpty()) {
                        wireLogHolder.setApiName(synCtx.getProperty("SYNAPSE_REST_API").toString());
                        if (resource.getDispatcherHelper() != null && resource.getDispatcherHelper().getString() != null && !resource.getDispatcherHelper().getString().isEmpty()) {
                            wireLogHolder.setResourceUrlString(resource.getDispatcherHelper().getString());
                        }
                    }
                    ((Axis2MessageContext)synCtx).getAxis2MessageContext().setProperty("synapse.wire.log.holder", (Object)wireLogHolder);
                }
                resource.process(synCtx);
                return;
            }
            this.handleResourceNotFound(synCtx);
        } else {
            boolean bl;
            boolean bl2 = false;
            boolean matchingMethodFound = false;
            for (RESTDispatcher dispatcher : ApiUtils.getDispatchers()) {
                Resource resource = dispatcher.findResource(synCtx, this.resources.values());
                if (resource == null) continue;
                bl = true;
                String method = (String)msgCtx.getProperty("HTTP_METHOD");
                matchingMethodFound = resource.hasMatchingMethod(method);
                break;
            }
            if (!bl) {
                this.handleResourceNotFound(synCtx);
            } else if (bl && !matchingMethodFound) {
                msgCtx.setProperty("HTTP_SC", (Object)405);
                msgCtx.removeProperty("TRANSPORT_HEADERS");
                msgCtx.setProperty("NIO-ACK-Requested", (Object)true);
            } else {
                msgCtx.setProperty("HTTP_SC", (Object)400);
                msgCtx.setProperty("NIO-ACK-Requested", (Object)true);
            }
        }
    }

    private boolean isBound(Resource resource, MessageContext synCtx) {
        Set<String> bindings = resource.getBindsTo();
        Object apiCaller = synCtx.getProperty(ApiConstants.API_CALLER);
        if (apiCaller != null) {
            return bindings.contains(apiCaller.toString());
        }
        return bindings.contains(ApiConstants.DEFAULT_BINDING_ENDPOINT_NAME);
    }

    private void handleResourceNotFound(MessageContext synCtx) {
        this.auditDebug("No matching resource was found for the request: " + synCtx.getMessageID());
        Mediator sequence = synCtx.getSequence("_resource_mismatch_handler_");
        if (sequence != null) {
            sequence.mediate(synCtx);
        } else {
            org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            msgCtx.setProperty("HTTP_SC", (Object)404);
            msgCtx.removeProperty("TRANSPORT_HEADERS");
            msgCtx.setProperty("NIO-ACK-Requested", (Object)true);
        }
    }

    private String getHostHeader(org.apache.axis2.context.MessageContext msgCtx) {
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String hostHeader = null;
        if (transportHeaders != null) {
            hostHeader = (String)transportHeaders.get("Host");
        }
        if (hostHeader == null) {
            hostHeader = (String)msgCtx.getProperty("SERVICE_PREFIX");
        }
        return hostHeader;
    }

    private String extractHostName(String hostHeader) {
        int index = hostHeader.indexOf(58);
        if (index != -1) {
            return hostHeader.substring(0, index);
        }
        return hostHeader;
    }

    private int extractPortNumber(String hostHeader, String transport) {
        int index = hostHeader.indexOf(58);
        if (index != -1) {
            return Integer.parseInt(hostHeader.substring(index + 1));
        }
        if ("http".equals(transport)) {
            return 80;
        }
        return 443;
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.resources.isEmpty()) {
            this.handleException("The API: " + this.getName() + " has been configured without any resource definitions");
        }
        this.auditInfo("Initializing API: " + this.getName());
        for (Resource resource : this.resources.values()) {
            resource.init(se);
        }
        for (Handler handler : this.handlers) {
            if (!(handler instanceof ManagedLifecycle)) continue;
            ((ManagedLifecycle)((Object)handler)).init(se);
        }
    }

    private String getFormattedLog(String msg) {
        return LoggingUtils.getFormattedLog("api", this.getName(), msg);
    }

    @Override
    public void destroy() {
        this.auditInfo("Destroying API: " + this.getName());
        for (Resource resource : this.resources.values()) {
            resource.destroy();
        }
        for (Handler handler : this.handlers) {
            if (!(handler instanceof ManagedLifecycle)) continue;
            ((ManagedLifecycle)((Object)handler)).destroy();
        }
    }

    public VersionStrategy getVersionStrategy() {
        return this.versionStrategy;
    }

    public void setVersionStrategy(VersionStrategy versionStrategy) {
        this.versionStrategy = versionStrategy;
    }

    public Resource getResource(String resourceName) {
        return this.resources.get(resourceName);
    }

    private boolean trace() {
        return this.aspectConfiguration.isTracingEnabled();
    }

    private void auditInfo(String message) {
        String formattedMsg = this.getFormattedLog(message);
        this.log.info((Object)formattedMsg);
        this.apiLog.info((Object)message);
        if (this.trace()) {
            trace.info((Object)formattedMsg);
        }
    }

    private void auditDebug(String message) {
        if (this.log.isDebugEnabled()) {
            String formattedMsg = this.getFormattedLog(message);
            this.log.debug((Object)formattedMsg);
            this.apiLog.debug((Object)message);
            if (this.trace()) {
                trace.debug((Object)formattedMsg);
            }
        }
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.aspectConfiguration == null) {
            this.aspectConfiguration = new AspectConfiguration(this.name);
        }
        String apiId = StatisticIdentityGenerator.getIdForComponent(this.name, ComponentType.API, holder);
        this.aspectConfiguration.setUniqueId(apiId);
        for (Resource resource : this.resources.values()) {
            resource.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(apiId, ComponentType.API, holder);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

