/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerState;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.wso2.securevault.secret.SecretManager;

public class ServerStateDetectionStrategy {
    private static final String PRODUCTION_MODE = "production";

    public static ServerState currentState(ServerContextInformation contextInformation, ServerConfigurationInformation information) {
        ServerState previousState = contextInformation.getServerState();
        String deploymentMode = information.getDeploymentMode();
        if (previousState == ServerState.UNDETERMINED) {
            if (deploymentMode != null && PRODUCTION_MODE.equals(deploymentMode.trim())) {
                SecretManager secretManager = SecretManager.getInstance();
                if (secretManager.isInitialized()) {
                    return ServerState.INITIALIZABLE;
                }
                secretManager.init(SynapsePropertiesLoader.loadSynapseProperties());
                if (secretManager.isInitialized()) {
                    return ServerState.INITIALIZABLE;
                }
            } else {
                return ServerState.INITIALIZABLE;
            }
        }
        return previousState;
    }
}

