/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.AbstractExtendedSynapseHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;

public abstract class FaultHandler {
    private static final Log log = LogFactory.getLog(FaultHandler.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");

    public void handleFault(MessageContext synCtx) {
        block3: {
            boolean traceOn = synCtx.getTracingState() == 1;
            boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
            this.executeExtendedSynapseHandlerOnFault(synCtx);
            if (traceOrDebugOn) {
                this.traceOrDebugWarn(traceOn, "FaultHandler executing impl: " + this.getClass().getName());
            }
            try {
                String msg = "FaultHandler executing impl: " + this.getClass().getName();
                synCtx.getServiceLog().info((Object)msg);
                this.onFault(synCtx);
            }
            catch (SynapseException e) {
                Stack<FaultHandler> faultStack = synCtx.getFaultStack();
                if (faultStack == null || faultStack.isEmpty()) break block3;
                faultStack.pop().handleFault(synCtx);
            }
        }
    }

    public void handleFault(MessageContext synCtx, Exception e) {
        boolean traceOn = synCtx.getTracingState() == 1;
        boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
        this.executeExtendedSynapseHandlerOnFault(synCtx);
        if (e != null && synCtx.getProperty("ERROR_CODE") == null) {
            synCtx.setProperty("ERROR_CODE", 0);
            synCtx.setProperty("ERROR_MESSAGE", e.getMessage().split("\n")[0]);
            synCtx.setProperty("ERROR_DETAIL", FaultHandler.getStackTrace(e));
            synCtx.setProperty("ERROR_EXCEPTION", e);
        }
        if (traceOrDebugOn) {
            this.traceOrDebugWarn(traceOn, "ERROR_CODE : " + synCtx.getProperty("ERROR_CODE"));
            this.traceOrDebugWarn(traceOn, "ERROR_MESSAGE : " + synCtx.getProperty("ERROR_MESSAGE"));
            this.traceOrDebugWarn(traceOn, "ERROR_DETAIL : " + synCtx.getProperty("ERROR_DETAIL"));
            this.traceOrDebugWarn(traceOn, "ERROR_EXCEPTION : " + synCtx.getProperty("ERROR_EXCEPTION"));
        }
        String msg = "ERROR_CODE : " + synCtx.getProperty("ERROR_CODE") + " ERROR_MESSAGE : " + synCtx.getProperty("ERROR_MESSAGE");
        synCtx.getServiceLog().warn((Object)msg);
        try {
            if (traceOrDebugOn) {
                this.traceOrDebugWarn(traceOn, "FaultHandler : " + this);
            }
            this.onFault(synCtx);
        }
        catch (SynapseException se) {
            Stack<FaultHandler> faultStack = synCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty()) {
                faultStack.pop().handleFault(synCtx, se);
            }
            throw new RuntimeException(se);
        }
    }

    public abstract void onFault(MessageContext var1);

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private void traceOrDebugWarn(boolean traceOn, String msg) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        log.warn((Object)msg);
    }

    protected void executeExtendedSynapseHandlerOnFault(MessageContext synCtx) {
        List<SynapseHandler> handlers = synCtx.getEnvironment().getSynapseHandlers();
        for (SynapseHandler handler : handlers) {
            AbstractExtendedSynapseHandler abstractExtendedSynapseHandler;
            if (!(handler instanceof AbstractExtendedSynapseHandler) || synCtx.getProperty("IS_ERROR_COUNT_ALREADY_PROCESSED") != null || (abstractExtendedSynapseHandler = (AbstractExtendedSynapseHandler)handler).handleError(synCtx)) continue;
            log.warn((Object)"Synapse not executed in the Extended Synapse Handler error flow path");
        }
    }
}

