/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.util;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua_parser.Client;
import ua_parser.Parser;

public class UserAgentParser {
    private static final Logger log = LoggerFactory.getLogger(UserAgentParser.class);
    private static final UserAgentParser INSTANCE = new UserAgentParser();
    private boolean isInitialized = false;
    private Parser uaParser;
    private Map<String, Client> clientCache;

    private UserAgentParser() {
        try {
            this.uaParser = new Parser();
            this.isInitialized = true;
            this.clientCache = new LinkedHashMap<String, Client>(51){
                static final int MAX = 50;

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 50;
                }
            };
        }
        catch (IOException e) {
            log.error("Error occurred when initializing uaParser", (Throwable)e);
        }
    }

    public static UserAgentParser getInstance() {
        return INSTANCE;
    }

    public Client parseUserAgent(String userAgentHeader) {
        if (this.isInitialized) {
            Client client = this.clientCache.get(userAgentHeader);
            if (client == null) {
                client = this.uaParser.parse(userAgentHeader);
                this.clientCache.put(userAgentHeader, client);
                log.debug("user agent added to cache. Current cache size is " + this.clientCache.size());
                return client;
            }
            log.debug("User agent fetched from cache");
            return client;
        }
        return null;
    }
}

