/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;

public class ParallelQueueWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ParallelQueueWorker.class);
    private BlockingQueue<MetricEventBuilder> eventQueue;
    private EventHubClient client;

    public ParallelQueueWorker(BlockingQueue<MetricEventBuilder> queue, EventHubClient client) {
        this.client = client;
        this.eventQueue = queue;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " worker has polled queue");
        }
        while (true) {
            try {
                MetricEventBuilder eventBuilder = this.eventQueue.take();
                if (eventBuilder != null) {
                    Map<String, Object> eventMap = eventBuilder.build();
                    String event = new Gson().toJson(eventMap);
                    this.client.sendEvent(event);
                }
            }
            catch (MetricReportingException e) {
                log.error("Builder instance is not duly filled. Event building failed", (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("Analytics event sending failed. Event will be dropped", (Throwable)e);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " worker has finished work");
        }
    }
}

