/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultAnalyticsThreadFactory;
import org.wso2.am.analytics.publisher.reporter.cloud.ParallelQueueWorker;
import org.wso2.am.analytics.publisher.reporter.cloud.QueueFlusher;

public class EventQueue {
    private static final Logger log = LoggerFactory.getLogger(EventQueue.class);
    private final BlockingQueue<MetricEventBuilder> eventQueue;
    private final ExecutorService publisherExecutorService;
    private final EventHubClient client;
    private final AtomicInteger failureCount;
    private final ScheduledExecutorService flushingExecutorService;

    public EventQueue(int queueSize, int workerThreadCount, EventHubClient client, int flushingDelay) {
        this.client = client;
        this.publisherExecutorService = Executors.newFixedThreadPool(workerThreadCount, new DefaultAnalyticsThreadFactory("Queue-Worker"));
        this.flushingExecutorService = Executors.newScheduledThreadPool(workerThreadCount, new DefaultAnalyticsThreadFactory("Queue-Flusher"));
        this.eventQueue = new LinkedBlockingQueue<MetricEventBuilder>(queueSize);
        this.failureCount = new AtomicInteger(0);
        for (int i = 0; i < workerThreadCount; ++i) {
            if (i == 0) {
                this.publisherExecutorService.submit(new ParallelQueueWorker(this.eventQueue, client));
                this.flushingExecutorService.scheduleWithFixedDelay(new QueueFlusher(this.eventQueue, client), flushingDelay, flushingDelay, TimeUnit.SECONDS);
                continue;
            }
            EventHubClient clonedClient = client.clone();
            this.publisherExecutorService.submit(new ParallelQueueWorker(this.eventQueue, clonedClient));
            this.flushingExecutorService.scheduleWithFixedDelay(new QueueFlusher(this.eventQueue, clonedClient), flushingDelay, flushingDelay, TimeUnit.SECONDS);
        }
    }

    public void put(MetricEventBuilder builder) {
        try {
            if (!this.eventQueue.offer(builder)) {
                int count = this.failureCount.incrementAndGet();
                if (count == 1) {
                    log.error("Event queue is full. Starting to drop analytics events.");
                } else if (count % 1000 == 0) {
                    log.error("Event queue is full. " + count + " events dropped so far");
                }
            }
        }
        catch (RejectedExecutionException e) {
            log.warn("Task submission failed. Task queue might be full", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        this.publisherExecutorService.shutdown();
        super.finalize();
    }

    protected EventHubClient getClient() {
        return this.client;
    }
}

