/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.AbstractMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultInputValidator;
import org.wso2.am.analytics.publisher.util.UserAgentParser;
import ua_parser.Client;

public class DefaultResponseMetricEventBuilder
extends AbstractMetricEventBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseMetricEventBuilder.class);
    protected Map<String, Class> requiredAttributes;
    protected Map<String, Object> eventMap;
    private Boolean isBuilt = false;

    public DefaultResponseMetricEventBuilder() {
        this.requiredAttributes = DefaultInputValidator.getInstance().getEventProperties(MetricSchema.RESPONSE);
        this.eventMap = new HashMap<String, Object>();
    }

    protected DefaultResponseMetricEventBuilder(Map<String, Class> requiredAttributes) {
        this.requiredAttributes = requiredAttributes;
        this.eventMap = new HashMap<String, Object>();
    }

    @Override
    public boolean validate() throws MetricReportingException {
        if (!this.isBuilt.booleanValue()) {
            for (Map.Entry<String, Class> entry : this.requiredAttributes.entrySet()) {
                Object attribute = this.eventMap.get(entry.getKey());
                if (attribute == null) {
                    throw new MetricReportingException(entry.getKey() + " is missing in metric data. This metric event will not be processed further.");
                }
                if (attribute.getClass().equals(entry.getValue())) continue;
                throw new MetricReportingException(entry.getKey() + " is expecting a " + entry.getValue() + " type attribute while attribute of type " + attribute.getClass() + " is present.");
            }
        }
        return true;
    }

    @Override
    public MetricEventBuilder addAttribute(String key, Object value) throws MetricReportingException {
        this.eventMap.put(key, value);
        return this;
    }

    @Override
    protected Map<String, Object> buildEvent() {
        if (!this.isBuilt.booleanValue()) {
            this.eventMap.put("eventType", "response");
            String userAgentHeader = (String)this.eventMap.remove("userAgentHeader");
            if (userAgentHeader != null) {
                this.setUserAgentProperties(userAgentHeader);
            }
            this.isBuilt = true;
        }
        return this.eventMap;
    }

    private void setUserAgentProperties(String userAgentHeader) {
        String browser = null;
        String platform = null;
        Client client = UserAgentParser.getInstance().parseUserAgent(userAgentHeader);
        if (client != null) {
            browser = client.userAgent.family;
            platform = client.os.family;
        }
        if (browser == null || browser.isEmpty()) {
            browser = "UNKNOWN";
        }
        if (platform == null || platform.isEmpty()) {
            platform = "UNKNOWN";
        }
        this.eventMap.put("userAgent", browser);
        this.eventMap.put("platform", platform);
    }
}

