/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.client.ClientStatus;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultChoreoFaultMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultChoreoResponseMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultFaultMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultResponseMetricEventBuilder;
import org.wso2.am.analytics.publisher.reporter.cloud.EventQueue;

public class DefaultCounterMetric
implements CounterMetric {
    private static final Logger log = LoggerFactory.getLogger(DefaultCounterMetric.class);
    private String name;
    private EventQueue queue;
    private MetricSchema schema;
    private ClientStatus status;
    private final AtomicInteger failureCount;

    public DefaultCounterMetric(String name, EventQueue queue, MetricSchema schema) throws MetricCreationException {
        this.name = name;
        this.queue = queue;
        if (schema != MetricSchema.ERROR && schema != MetricSchema.RESPONSE && schema != MetricSchema.CHOREO_ERROR && schema != MetricSchema.CHOREO_RESPONSE) {
            throw new MetricCreationException("Default Counter Metric only supports " + (Object)((Object)MetricSchema.RESPONSE) + ", , " + (Object)((Object)MetricSchema.ERROR) + ", " + (Object)((Object)MetricSchema.CHOREO_RESPONSE) + " and " + (Object)((Object)MetricSchema.CHOREO_RESPONSE) + " types.");
        }
        this.schema = schema;
        this.status = queue.getClient().getStatus();
        this.failureCount = new AtomicInteger(0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetricSchema getSchema() {
        return this.schema;
    }

    @Override
    public int incrementCount(MetricEventBuilder builder) {
        if (this.status != ClientStatus.NOT_CONNECTED) {
            this.queue.put(builder);
        } else if (this.failureCount.incrementAndGet() % 1000 == 0) {
            log.error("Eventhub client is not connected. " + this.failureCount.incrementAndGet() + " events dropped so far. Please correct your configuration and restart the instance.");
        }
        return 0;
    }

    @Override
    public MetricEventBuilder getEventBuilder() {
        switch (this.schema) {
            case RESPONSE: {
                return new DefaultResponseMetricEventBuilder();
            }
            case ERROR: {
                return new DefaultFaultMetricEventBuilder();
            }
            case CHOREO_RESPONSE: {
                return new DefaultChoreoResponseMetricEventBuilder();
            }
            case CHOREO_ERROR: {
                return new DefaultChoreoFaultMetricEventBuilder();
            }
        }
        return null;
    }
}

