/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter.cloud;

import com.azure.core.amqp.AmqpRetryMode;
import com.azure.core.amqp.AmqpRetryOptions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.client.EventHubClient;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.AbstractMetricReporter;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.TimerMetric;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultCounterMetric;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultInputValidator;
import org.wso2.am.analytics.publisher.reporter.cloud.EventQueue;

public class DefaultAnalyticsMetricReporter
extends AbstractMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalyticsMetricReporter.class);
    protected EventQueue eventQueue;

    public DefaultAnalyticsMetricReporter(Map<String, String> properties) throws MetricCreationException {
        super(properties);
        int queueSize = 20000;
        int workerThreads = 1;
        int flushingDelay = 15;
        if (properties.get("queue.size") != null) {
            queueSize = Integer.parseInt(properties.get("queue.size"));
        }
        if (properties.get("worker.thread.count") != null) {
            workerThreads = Integer.parseInt(properties.get("worker.thread.count"));
        }
        if (properties.get("client.flushing.delay") != null) {
            flushingDelay = Integer.parseInt(properties.get("client.flushing.delay"));
        }
        String authToken = properties.get("auth.api.token");
        String authEndpoint = properties.get("auth.api.url");
        AmqpRetryOptions retryOptions = this.createRetryOptions(properties);
        EventHubClient client = new EventHubClient(authEndpoint, authToken, retryOptions);
        this.eventQueue = new EventQueue(queueSize, workerThreads, client, flushingDelay);
    }

    private AmqpRetryOptions createRetryOptions(Map<String, String> properties) {
        String tempRetryMode;
        int maxRetries = 2;
        int delay = 15;
        int maxDelay = 30;
        int tryTimeout = 30;
        AmqpRetryMode retryMode = AmqpRetryMode.FIXED;
        if (properties.get("eventhub.client.max.retries") != null) {
            int tempMaxRetries = Integer.parseInt(properties.get("eventhub.client.max.retries"));
            if (tempMaxRetries > 0) {
                maxRetries = tempMaxRetries;
            } else {
                log.warn("Provided eventhub.client.max.retriesvalue is less than 0 and not acceptable. Hence using the default value.");
            }
        }
        if (properties.get("eventhub.client.delay") != null) {
            int tempDelay = Integer.parseInt(properties.get("eventhub.client.delay"));
            if (tempDelay > 0) {
                delay = tempDelay;
            } else {
                log.warn("Provided eventhub.client.delayvalue is less than 0 and not acceptable. Hence using the default value.");
            }
        }
        if (properties.get("eventhub.client.max.delay") != null) {
            int tempMaxDelay = Integer.parseInt(properties.get("eventhub.client.max.delay"));
            if (tempMaxDelay > 0) {
                maxDelay = tempMaxDelay;
            } else {
                log.warn("Provided eventhub.client.max.delayvalue is less than 0 and not acceptable. Hence using the default value.");
            }
        }
        if (properties.get("eventhub.client.try.timeout") != null) {
            int tempTryTimeout = Integer.parseInt(properties.get("eventhub.client.try.timeout"));
            if (tempTryTimeout > 0) {
                tryTimeout = tempTryTimeout;
            } else {
                log.warn("Provided eventhub.client.try.timeoutvalue is less than 0 and not acceptable. Hence using the default value.");
            }
        }
        if (properties.get("eventhub.client.retry.mode") != null && !(tempRetryMode = properties.get("eventhub.client.retry.mode")).equals("fixed")) {
            if (tempRetryMode.equals("exponential")) {
                retryMode = AmqpRetryMode.EXPONENTIAL;
            } else {
                log.warn("Provided eventhub.client.retry.modevalue is not supported. Hence will using the default value.");
            }
        }
        return new AmqpRetryOptions().setDelay(Duration.ofSeconds(delay)).setMaxRetries(maxRetries).setMaxDelay(Duration.ofSeconds(maxDelay)).setTryTimeout(Duration.ofSeconds(tryTimeout)).setMode(retryMode);
    }

    @Override
    protected void validateConfigProperties(Map<String, String> properties) throws MetricCreationException {
        if (properties != null) {
            List<String> requiredProperties = DefaultInputValidator.getInstance().getConfigProperties();
            for (String property : requiredProperties) {
                if (properties.get(property) != null && !properties.get(property).isEmpty()) continue;
                throw new MetricCreationException(property + " is missing in config data");
            }
        } else {
            throw new MetricCreationException("Configuration properties cannot be null");
        }
    }

    @Override
    protected CounterMetric createCounter(String name, MetricSchema schema) throws MetricCreationException {
        DefaultCounterMetric counterMetric = new DefaultCounterMetric(name, this.eventQueue, schema);
        return counterMetric;
    }

    @Override
    protected TimerMetric createTimer(String name) {
        return null;
    }
}

