/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.reporter;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.Metric;
import org.wso2.am.analytics.publisher.reporter.MetricReporter;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.am.analytics.publisher.reporter.TimerMetric;

public abstract class AbstractMetricReporter
implements MetricReporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetricReporter.class);
    private final Map<String, String> properties;
    private Map<String, Metric> metricRegistry;

    protected AbstractMetricReporter(Map<String, String> properties) throws MetricCreationException {
        this.properties = properties;
        this.metricRegistry = new HashMap<String, Metric>();
        this.validateConfigProperties(properties);
    }

    protected abstract void validateConfigProperties(Map<String, String> var1) throws MetricCreationException;

    @Override
    public Map<String, String> getConfiguration() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CounterMetric createCounterMetric(String name, MetricSchema schema) throws MetricCreationException {
        Metric metric = this.metricRegistry.get(name);
        if (metric == null) {
            AbstractMetricReporter abstractMetricReporter = this;
            synchronized (abstractMetricReporter) {
                if (this.metricRegistry.get(name) == null) {
                    metric = this.createCounter(name, schema);
                    this.metricRegistry.put(name, metric);
                } else {
                    metric = this.metricRegistry.get(name);
                }
            }
        } else {
            if (!(metric instanceof CounterMetric)) {
                throw new MetricCreationException("Timer Metric with the same name already exists. Please use a different name");
            }
            if (metric.getSchema() != schema) {
                throw new MetricCreationException("Counter Metric with the same name but different schema already exists. Please use a different name");
            }
        }
        return (CounterMetric)metric;
    }

    protected abstract CounterMetric createCounter(String var1, MetricSchema var2) throws MetricCreationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerMetric createTimerMetric(String name) {
        Metric metric = this.metricRegistry.get(name);
        if (metric == null) {
            AbstractMetricReporter abstractMetricReporter = this;
            synchronized (abstractMetricReporter) {
                if (this.metricRegistry.get(name) == null) {
                    metric = this.createTimer(name);
                    this.metricRegistry.put(name, metric);
                } else {
                    metric = this.metricRegistry.get(name);
                }
            }
        }
        if (!(metric instanceof TimerMetric)) {
            log.error("Counter Metric with the same name already exists. Please use a different name");
            return null;
        }
        return (TimerMetric)metric;
    }

    protected abstract TimerMetric createTimer(String var1);
}

