/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.analytics.publisher.client;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.am.analytics.publisher.client.ClientStatus;
import org.wso2.am.analytics.publisher.client.EventHubProducerClientFactory;
import org.wso2.am.analytics.publisher.exception.ConnectionRecoverableException;
import org.wso2.am.analytics.publisher.exception.ConnectionUnrecoverableException;
import org.wso2.am.analytics.publisher.reporter.cloud.DefaultAnalyticsThreadFactory;
import org.wso2.am.analytics.publisher.util.BackoffRetryCounter;

public class EventHubClient
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(EventHubClient.class);
    private final String authEndpoint;
    private final String authToken;
    private final Lock publishingLock;
    private final BackoffRetryCounter producerRetryCounter;
    private final BackoffRetryCounter eventBatchRetryCounter;
    private final Lock threadBarrier = new ReentrantLock();
    private final AmqpRetryOptions retryOptions;
    private final Condition waitCondition = this.threadBarrier.newCondition();
    private final ScheduledExecutorService scheduledExecutorService;
    private EventHubProducerClient producer;
    private EventDataBatch batch;
    private ClientStatus clientStatus;

    public EventHubClient(String authEndpoint, String authToken, AmqpRetryOptions retryOptions) {
        this.publishingLock = new ReentrantLock();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(2, new DefaultAnalyticsThreadFactory("Reconnection-Service"));
        this.producerRetryCounter = new BackoffRetryCounter();
        this.eventBatchRetryCounter = new BackoffRetryCounter();
        this.authEndpoint = authEndpoint;
        this.authToken = authToken;
        this.retryOptions = retryOptions;
        this.clientStatus = ClientStatus.NOT_CONNECTED;
        this.createProducerWithRetry(authEndpoint, authToken, retryOptions, true);
    }

    private void retryWithBackoff(final String authEndpoint, final String authToken, final AmqpRetryOptions retryOptions, final boolean createBatch) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                EventHubClient.this.createProducerWithRetry(authEndpoint, authToken, retryOptions, createBatch);
            }
        }, this.producerRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
        this.producerRetryCounter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProducerWithRetry(String authEndpoint, String authToken, AmqpRetryOptions retryOptions, boolean createBatch) {
        block11: {
            log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Creating Eventhub client instance.");
            try {
                if (this.producer != null) {
                    this.producer.close();
                }
                this.producer = EventHubProducerClientFactory.create(authEndpoint, authToken, retryOptions);
                try {
                    if (createBatch) {
                        this.batch = this.producer.createBatch();
                    }
                }
                catch (IllegalStateException e) {
                    throw new ConnectionRecoverableException("Event batch creation failed. " + e.getMessage().replaceAll("[\r\n]", ""));
                }
                this.clientStatus = ClientStatus.CONNECTED;
                log.info("[" + Thread.currentThread().getName().replaceAll("[\r\n]", "") + "] - Eventhub client successfully connected.");
                this.producerRetryCounter.reset();
                try {
                    this.threadBarrier.lock();
                    this.waitCondition.signalAll();
                }
                finally {
                    this.threadBarrier.unlock();
                }
            }
            catch (ConnectionRecoverableException e) {
                this.clientStatus = ClientStatus.RETRYING;
                log.error("Recoverable error occurred when creating Eventhub Client. Retry attempts will be made in " + this.producerRetryCounter.getTimeInterval().replaceAll("[\r\n]", "") + ". Reason :" + e.getMessage().replaceAll("[\r\n]", ""));
                if (log.isDebugEnabled()) {
                    log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Recoverable error occurred when creating Eventhub Client using following attributes. Auth endpoint: " + authEndpoint.replaceAll("[\r\n]", "") + ". Retry attempts will be made. Reason : " + e.getMessage().replaceAll("[\r\n]", ""), (Throwable)e);
                }
                this.retryWithBackoff(authEndpoint, authToken, retryOptions, createBatch);
            }
            catch (ConnectionUnrecoverableException e) {
                this.clientStatus = ClientStatus.NOT_CONNECTED;
                log.error("Unrecoverable error occurred when creating Eventhub Client. Analytics event publishing will be disabled until issue is rectified. Reason: " + e.getMessage().replaceAll("[\r\n]", ""));
                if (!log.isDebugEnabled()) break block11;
                log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Unrecoverable error occurred when creating Eventhub Client using following attributes. Auth endpoint: " + authEndpoint.replaceAll("[\r\n]", "") + ". Analytics event publishing will be disabled until issue is rectified. Reason: " + e.getMessage().replaceAll("[\r\n]", ""), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendEvent(String event) {
        if (this.clientStatus == ClientStatus.CONNECTED) {
            EventData eventData = new EventData(event);
            try {
                this.publishingLock.lock();
                boolean isAdded = this.batch.tryAdd(eventData);
                if (!isAdded) {
                    try {
                        int size = 0;
                        if (log.isDebugEnabled()) {
                            size = this.batch.getCount();
                        }
                        this.producer.send(this.batch);
                        this.batch = this.createBatchWithRetry();
                        isAdded = this.batch.tryAdd(eventData);
                        log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Published " + size + " events to Analytics cluster.");
                    }
                    catch (AmqpException e) {
                        if (this.isAuthenticationFailure(e)) {
                            log.error("Authentication issue happened. Producer client will be re-initialized retaining the Event Data Batch");
                            this.clientStatus = ClientStatus.RETRYING;
                            this.createProducerWithRetry(this.authEndpoint, this.authToken, this.retryOptions, false);
                            this.sendEvent(event);
                        }
                        if (e.getErrorCondition() == AmqpErrorCondition.RESOURCE_LIMIT_EXCEEDED) {
                            log.error("Resource limit exceeded when publishing Event Data Batch. Operation will be retried after constant delay");
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            this.sendEvent(event);
                        }
                        log.error("AMQP error occurred while publishing Event Data Batch. Producer client will be re-initialized. Events may be lost in the process.");
                        log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - AMQP error occurred while publishing Event Data Batch. Producer client will be re-initialized. Events may be lost in the process.", (Throwable)e);
                        this.clientStatus = ClientStatus.RETRYING;
                        this.createProducerWithRetry(this.authEndpoint, this.authToken, this.retryOptions, true);
                        this.sendEvent(event);
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof TimeoutException) {
                            log.error("Timeout occurred after retrying " + this.retryOptions.getMaxRetries() + " times with an timeout of " + this.retryOptions.getTryTimeout().getSeconds() + " seconds while trying to publish Event Data Batch. Next retry cycle will begin shortly.");
                            this.sendEvent(event);
                        }
                        log.error("Unknown error occurred while publishing Event Data Batch. Producer client will be re-initialized. Events may be lost in the process.");
                        log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Unknown error occurred while publishing Event Data Batch. Producer client will be re-initialized. Events may be lost in the process.", (Throwable)e);
                        this.clientStatus = ClientStatus.RETRYING;
                        this.createProducerWithRetry(this.authEndpoint, this.authToken, this.retryOptions, true);
                        this.sendEvent(event);
                    }
                }
                if (isAdded) {
                    if (!log.isTraceEnabled()) return;
                    log.trace("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Adding event: " + event.replaceAll("[\r\n]", ""));
                    return;
                }
                if (!log.isTraceEnabled()) return;
                log.trace("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] - Failed to add event: " + event.replaceAll("[\r\n]", ""));
                return;
            }
            finally {
                this.publishingLock.unlock();
            }
        }
        try {
            this.threadBarrier.lock();
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName().replaceAll("[\r\n]", "") + " will be parked as EventHub Client is inactive.");
            }
            this.waitCondition.await();
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName().replaceAll("[\r\n]", "") + " will be resumes as EventHub Client is active.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.threadBarrier.unlock();
        }
        this.sendEvent(event);
    }

    private boolean isAuthenticationFailure(AmqpException exception) {
        AmqpErrorCondition condition = exception.getErrorCondition();
        return condition == AmqpErrorCondition.UNAUTHORIZED_ACCESS || condition == AmqpErrorCondition.PUBLISHER_REVOKED_ERROR;
    }

    private EventDataBatch createBatchWithRetry() {
        log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] Creating Event Data Batch");
        try {
            EventDataBatch batch = this.producer.createBatch();
            this.eventBatchRetryCounter.reset();
            return batch;
        }
        catch (IllegalStateException e) {
            log.error("Error in creating Event Data Batch. Operation will be retried in " + this.eventBatchRetryCounter.getTimeInterval().replaceAll("[\r\n]", ""));
            try {
                Thread.sleep(this.eventBatchRetryCounter.getTimeIntervalMillis());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.eventBatchRetryCounter.increment();
            return this.createBatchWithRetry();
        }
    }

    public void flushEvents() {
        if (this.clientStatus == ClientStatus.CONNECTED && this.batch.getCount() > 0) {
            if (this.publishingLock.tryLock()) {
                try {
                    int size = this.batch.getCount();
                    this.producer.send(this.batch);
                    this.batch = this.createBatchWithRetry();
                    log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] Flushed " + size + " events to Analytics cluster.");
                }
                catch (Exception e) {
                    log.error("Event flushing operation failed. Will be retried again according to the configured client.flushing.delay. Error will be handled by publishing threads once Event Data Batch is filled.");
                    log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] Event flushing operation failed. Will be retried again according to the configured client.flushing.delay. Error will be handled by publishing threads once Event Data Batch is filled.", (Throwable)e);
                }
                finally {
                    this.publishingLock.unlock();
                }
            } else {
                log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] Event flushing operation aborted as publisher threads are trying to send events");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{ " + Thread.currentThread().getName().replaceAll("[\r\n]", "") + " }] Event flushing is aborted as Event Data Batch is empty or connection to Event Hub is not made");
        }
    }

    public ClientStatus getStatus() {
        return this.clientStatus;
    }

    public EventHubClient clone() {
        return new EventHubClient(this.authEndpoint, this.authToken, this.retryOptions);
    }
}

