/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.ui.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceStub;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.ClaimDialectDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.ExternalClaimDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.LocalClaimDTO;

public class ClaimMetadataAdminClient {
    private static final Log log = LogFactory.getLog(ClaimMetadataAdminClient.class);
    private ClaimMetadataManagementServiceStub stub;

    public ClaimMetadataAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "ClaimMetadataManagementService";
        this.stub = new ClaimMetadataManagementServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ClaimDialectDTO[] getClaimDialects() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            return this.stub.getClaimDialects();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void addClaimDialect(ClaimDialectDTO externalClaimDialect) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.addClaimDialect(externalClaimDialect);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void removeClaimDialect(String externalClaimDialect) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            ClaimDialectDTO claimDialect = new ClaimDialectDTO();
            claimDialect.setClaimDialectURI(externalClaimDialect);
            this.stub.removeClaimDialect(claimDialect);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public LocalClaimDTO[] getLocalClaims() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            return this.stub.getLocalClaims();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void addLocalClaim(LocalClaimDTO localCLaim) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.addLocalClaim(localCLaim);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void updateLocalClaim(LocalClaimDTO localClaim) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.updateLocalClaim(localClaim);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void removeLocalClaim(String localCLaimURI) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.removeLocalClaim(localCLaimURI);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public ExternalClaimDTO[] getExternalClaims(String externalClaimDialectURI) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            return this.stub.getExternalClaims(externalClaimDialectURI);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void addExternalClaim(ExternalClaimDTO externalClaim) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.addExternalClaim(externalClaim);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void updateExternalClaim(ExternalClaimDTO externalClaim) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.updateExternalClaim(externalClaim);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void removeExternalClaim(String externalClaimDialectURI, String externalClaimURI) throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException {
        try {
            this.stub.removeExternalClaim(externalClaimDialectURI, externalClaimURI);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

