/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.model.UserIdentityClaim;
import org.wso2.carbon.identity.governance.store.InMemoryIdentityDataStore;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JDBCIdentityDataStore
extends InMemoryIdentityDataStore {
    private static final Log log = LogFactory.getLog(JDBCIdentityDataStore.class);
    private static final String QUERY_FILTER_STRING_ANY = "*";
    private static final String SQL_FILTER_STRING_ANY = "%";
    private static final char SQL_FILTER_CHAR_ESCAPE = '\\';

    @Override
    public void store(UserIdentityClaim userIdentityDTO, UserStoreManager userStoreManager) throws IdentityException {
        if (userIdentityDTO == null || userIdentityDTO.getUserIdentityDataMap().isEmpty()) {
            return;
        }
        String userName = userIdentityDTO.getUserName();
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        userIdentityDTO.setUserName(userName);
        super.store(userIdentityDTO, userStoreManager);
        int tenantId = -1234;
        try {
            tenantId = userStoreManager.getTenantId();
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while getting tenant Id.", (Throwable)e);
        }
        Map<String, String> data = userIdentityDTO.getUserIdentityDataMap();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            boolean isUserExists;
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                isUserExists = this.isExistingUserDataValue(userName, tenantId, key);
            }
            catch (SQLException e) {
                throw IdentityException.error((String)"Error occurred while checking if user existing", (Throwable)e);
            }
            if (isUserExists) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Key:" + key + ", Value:" + value + " updated for user:" + userName + " in JDBCIdentityDataStore"));
                }
                this.updateUserDataValue(userName, tenantId, key, value);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key:" + key + ", Value:" + value + " added for user:" + userName + " in JDBCIdentityDataStore"));
            }
            this.addUserDataValue(userName, tenantId, key, value);
        }
    }

    private boolean isExistingUserDataValue(String userName, int tenantId, String key) throws SQLException {
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
            String query = isUsernameCaseSensitive ? "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ? AND DATA_KEY = ?" : "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?) AND DATA_KEY = ?";
            try (PreparedStatement prepStmt = connection.prepareStatement(query);){
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, userName);
                prepStmt.setString(3, key);
                try (ResultSet results = prepStmt.executeQuery();){
                    if (results.next()) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserDataValue(String userName, int tenantId, String key, String value) {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_IDENTITY_USER_DATA (TENANT_ID, USER_NAME, DATA_KEY, DATA_VALUE) VALUES (?,?,?,?)");
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userName);
            prepStmt.setString(3, key);
            prepStmt.setString(4, value);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            log.error((Object)"Error occurred while persisting user data", (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDataValue(String userName, int tenantId, String key, String value) {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
        try {
            String query = isUsernameCaseSensitive ? "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND USER_NAME=? AND DATA_KEY=?" : "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND LOWER(USER_NAME)=LOWER(?) AND DATA_KEY=?";
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, value);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, userName);
            prepStmt.setString(4, key);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error occurred while persisting user data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityClaim load(String userName, UserStoreManager userStoreManager) {
        block11: {
            UserIdentityClaim userIdentityClaim;
            String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
            UserIdentityClaim dto = super.load(userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName), userStoreManager);
            if (dto != null) {
                return dto;
            }
            Connection connection = IdentityDatabaseUtil.getDBConnection();
            PreparedStatement prepStmt = null;
            ResultSet results = null;
            try {
                int tenantId = userStoreManager.getTenantId();
                boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
                String query = isUsernameCaseSensitive ? "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?" : "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
                prepStmt = connection.prepareStatement(query);
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, userName);
                results = prepStmt.executeQuery();
                HashMap<String, String> data = new HashMap<String, String>();
                while (results.next()) {
                    data.put(results.getString(1), results.getString(2));
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieved identity data for:" + tenantId + ":" + userName));
                    for (Map.Entry entry : data.entrySet()) {
                        log.debug((Object)((String)entry.getKey() + " : " + (String)entry.getValue()));
                    }
                }
                dto = new UserIdentityClaim(userName, data);
                dto.setTenantId(tenantId);
                try {
                    super.store(dto, userStoreManager);
                }
                catch (IdentityException e) {
                    log.error((Object)"Error while reading user identity data", (Throwable)e);
                }
                userIdentityClaim = dto;
                IdentityDatabaseUtil.closeResultSet((ResultSet)results);
            }
            catch (SQLException | UserStoreException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                log.error((Object)"Error while reading user identity data", e);
                break block11;
            }
            finally {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
            return userIdentityClaim;
        }
        return null;
    }

    @Override
    public void remove(String userName, UserStoreManager userStoreManager) throws IdentityException {
        super.remove(userName, userStoreManager);
        String domainName = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName");
        userName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            int tenantId = userStoreManager.getTenantId();
            boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreInUsernameCaseSensitive((String)userName, (int)tenantId);
            String query = isUsernameCaseSensitive ? "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?" : "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, userName);
            prepStmt.execute();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException | UserStoreException e) {
            try {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw IdentityException.error((String)"Error while reading user identity data", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    @Override
    public List<String> list(String claimUri, String claimValue, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws IdentityException {
        ArrayList<String> userNames = new ArrayList<String>();
        if (claimValue.contains(QUERY_FILTER_STRING_ANY) && !claimValue.matches("(\\*)\\1+")) {
            claimValue = claimValue.replaceAll("(?<!\\\\)\\*", SQL_FILTER_STRING_ANY);
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            int tenantId = userStoreManager.getTenantId();
            String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
            String query = "SELECT DISTINCT USER_NAME FROM IDN_IDENTITY_USER_DATA WHERE DATA_KEY = ? AND DATA_VALUE LIKE ? AND TENANT_ID = ? AND USER_NAME LIKE ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                preparedStatement.setString(1, claimUri);
                preparedStatement.setString(2, claimValue);
                preparedStatement.setInt(3, tenantId);
                String userNameWithDomain = StringUtils.equalsIgnoreCase((String)userStoreDomain, (String)"PRIMARY") ? SQL_FILTER_STRING_ANY : userStoreDomain + UserCoreConstants.DOMAIN_SEPARATOR + SQL_FILTER_STRING_ANY;
                preparedStatement.setString(4, userNameWithDomain);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Listing users with claim URI: " + claimUri + " with value: " + claimValue + " having username pattern: " + userNameWithDomain + " in tenant: " + tenantId));
                }
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        userNames.add(resultSet.getString("USER_NAME"));
                    }
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            }
        }
        catch (SQLException | UserStoreException e) {
            throw new IdentityException("Error occurred while retrieving users from claim URI: " + claimUri, e);
        }
        return userNames;
    }

    private static class SQLQuery {
        public static final String CHECK_EXIST_USER_DATA = "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ? AND DATA_KEY = ?";
        public static final String CHECK_EXIST_USER_DATA_CASE_INSENSITIVE = "SELECT DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?) AND DATA_KEY = ?";
        public static final String STORE_USER_DATA = "INSERT INTO IDN_IDENTITY_USER_DATA (TENANT_ID, USER_NAME, DATA_KEY, DATA_VALUE) VALUES (?,?,?,?)";
        public static final String UPDATE_USER_DATA = "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND USER_NAME=? AND DATA_KEY=?";
        public static final String UPDATE_USER_DATA_CASE_INSENSITIVE = "UPDATE IDN_IDENTITY_USER_DATA SET DATA_VALUE=? WHERE TENANT_ID=? AND LOWER(USER_NAME)=LOWER(?) AND DATA_KEY=?";
        public static final String LOAD_USER_DATA = "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?";
        public static final String LOAD_USER_DATA_CASE_INSENSITIVE = "SELECT DATA_KEY, DATA_VALUE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
        public static final String DELETE_USER_DATA = "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND USER_NAME = ?";
        public static final String DELETE_USER_DATA_CASE_INSENSITIVE = "DELETE FROM IDN_IDENTITY_USER_DATA WHERE TENANT_ID = ? AND LOWER(USER_NAME) = LOWER(?)";
        static final String LIST_USERS_FROM_CLAIM = "SELECT DISTINCT USER_NAME FROM IDN_IDENTITY_USER_DATA WHERE DATA_KEY = ? AND DATA_VALUE LIKE ? AND TENANT_ID = ? AND USER_NAME LIKE ?";

        private SQLQuery() {
        }
    }
}

