/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.store;

import java.util.Locale;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.model.UserIdentityClaim;
import org.wso2.carbon.identity.governance.store.UserIdentityDataStore;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class InMemoryIdentityDataStore
extends UserIdentityDataStore {
    private static final String IDENTITY_GOVERNANCE_DATA_CACHE_MANAGER = "IDENTITY_GOVERNANCE_DATA_CACHE_MANAGER";
    private static final String IDENTITY_GOVERNANCE_DATA_CACHE = "IDENTITY_GOVERNANCE_DATA_CACHE";
    private static final Log log = LogFactory.getLog(InMemoryIdentityDataStore.class);

    protected Cache<String, UserIdentityClaim> getCache() {
        CacheManager manager = Caching.getCacheManagerFactory().getCacheManager(IDENTITY_GOVERNANCE_DATA_CACHE_MANAGER);
        Cache cache = manager.getCache(IDENTITY_GOVERNANCE_DATA_CACHE);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(UserIdentityClaim userIdentityDTO, UserStoreManager userStoreManager) throws IdentityException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            if (userIdentityDTO != null && userIdentityDTO.getUserName() != null) {
                String userName = UserCoreUtil.removeDomainFromName((String)userIdentityDTO.getUserName());
                if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager) {
                    if (!IdentityUtil.isUserStoreCaseSensitive((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Case insensitive user store found. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                        }
                        userName = userName.toLowerCase(Locale.ENGLISH);
                    } else if (!IdentityUtil.isUseCaseSensitiveUsernameForCacheKeys((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Case insensitive username for cache key is used. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                        }
                        userName = userName.toLowerCase(Locale.ENGLISH);
                    }
                }
                if (log.isDebugEnabled()) {
                    StringBuilder data = new StringBuilder("{");
                    if (userIdentityDTO.getUserIdentityDataMap() != null) {
                        for (Map.Entry<String, String> entry : userIdentityDTO.getUserIdentityDataMap().entrySet()) {
                            data.append("[").append(entry.getKey()).append(" = ").append(entry.getValue()).append("], ");
                        }
                    }
                    if (data.indexOf(",") >= 0) {
                        data.deleteCharAt(data.lastIndexOf(","));
                    }
                    data.append("}");
                    log.debug((Object)("Storing UserIdentityClaimsDO to cache for user: " + userName + " with claims: " + data));
                }
                org.wso2.carbon.user.core.UserStoreManager store = (org.wso2.carbon.user.core.UserStoreManager)userStoreManager;
                String domainName = store.getRealmConfiguration().getUserStoreProperty("DomainName");
                String key = domainName + userStoreManager.getTenantId() + userName;
                Cache<String, UserIdentityClaim> cache = this.getCache();
                if (cache != null) {
                    UserIdentityClaim cachedUserIdentityDTO = (UserIdentityClaim)cache.get((Object)key);
                    if (cachedUserIdentityDTO != null) {
                        cachedUserIdentityDTO.getUserIdentityDataMap().putAll(userIdentityDTO.getUserIdentityDataMap());
                        cache.put((Object)key, (Object)cachedUserIdentityDTO);
                    } else {
                        cache.put((Object)key, (Object)userIdentityDTO);
                    }
                }
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while obtaining tenant ID from user store manager", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityClaim load(String userName, UserStoreManager userStoreManager) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            Cache<String, UserIdentityClaim> cache = this.getCache();
            if (userName != null && cache != null) {
                org.wso2.carbon.user.core.UserStoreManager store;
                String domainName;
                UserIdentityClaim userIdentityDTO;
                userName = UserCoreUtil.removeDomainFromName((String)userName);
                if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager) {
                    if (!IdentityUtil.isUserStoreCaseSensitive((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Case insensitive user store found. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                        }
                        userName = userName.toLowerCase(Locale.ENGLISH);
                    } else if (!IdentityUtil.isUseCaseSensitiveUsernameForCacheKeys((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Case insensitive username for cache key is used. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                        }
                        userName = userName.toLowerCase(Locale.ENGLISH);
                    }
                }
                if ((userIdentityDTO = (UserIdentityClaim)cache.get((Object)((domainName = (store = (org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")) + userStoreManager.getTenantId() + userName))) != null && log.isDebugEnabled()) {
                    StringBuilder data = new StringBuilder("{");
                    if (userIdentityDTO.getUserIdentityDataMap() != null) {
                        for (Map.Entry<String, String> entry : userIdentityDTO.getUserIdentityDataMap().entrySet()) {
                            data.append("[").append(entry.getKey()).append(" = ").append(entry.getValue()).append("], ");
                        }
                    }
                    if (data.indexOf(",") >= 0) {
                        data.deleteCharAt(data.lastIndexOf(","));
                    }
                    data.append("}");
                    log.debug((Object)("Loaded UserIdentityClaimsDO from cache for user :" + userName + " with claims: " + data));
                }
                UserIdentityClaim userIdentityClaim = userIdentityDTO;
                return userIdentityClaim;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while obtaining tenant ID from user store manager");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String userName, UserStoreManager userStoreManager) throws IdentityException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            Cache<String, UserIdentityClaim> cache = this.getCache();
            if (userName == null) {
                return;
            }
            userName = UserCoreUtil.removeDomainFromName((String)userName);
            if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager) {
                if (!IdentityUtil.isUserStoreCaseSensitive((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Case insensitive user store found. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                    }
                    userName = userName.toLowerCase(Locale.ENGLISH);
                } else if (!IdentityUtil.isUseCaseSensitiveUsernameForCacheKeys((org.wso2.carbon.user.core.UserStoreManager)((org.wso2.carbon.user.core.UserStoreManager)userStoreManager))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Case insensitive username for cache key is used. Changing username from : " + userName + " to : " + userName.toLowerCase(Locale.ENGLISH)));
                    }
                    userName = userName.toLowerCase(Locale.ENGLISH);
                }
            }
            org.wso2.carbon.user.core.UserStoreManager store = (org.wso2.carbon.user.core.UserStoreManager)userStoreManager;
            String domainName = store.getRealmConfiguration().getUserStoreProperty("DomainName");
            cache.remove((Object)(domainName + userStoreManager.getTenantId() + userName));
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while obtaining tenant ID from user store manager");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

