/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.service.notification;

import org.wso2.carbon.identity.governance.IdentityMgtConstants;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerClientException;

public enum NotificationChannels {
    EMAIL_CHANNEL("EMAIL", "http://wso2.org/claims/emailaddress", "http://wso2.org/claims/identity/emailVerified"),
    SMS_CHANNEL("SMS", "http://wso2.org/claims/mobile", "http://wso2.org/claims/identity/phoneVerified"),
    EXTERNAL_CHANNEL("EXTERNAL", "", "");

    private String channelType;
    private String verifiedClaimUrl;
    private String claimUrl;

    public String getClaimUri() {
        return this.claimUrl;
    }

    public String getVerifiedClaimUrl() {
        return this.verifiedClaimUrl;
    }

    public String getChannelType() {
        return this.channelType;
    }

    private NotificationChannels(String type, String claimUrl, String verifiedClaimUrl) {
        this.channelType = type;
        this.claimUrl = claimUrl;
        this.verifiedClaimUrl = verifiedClaimUrl;
    }

    public static NotificationChannels getNotificationChannel(String channelType) throws NotificationChannelManagerClientException {
        if (EMAIL_CHANNEL.getChannelType().equals(channelType)) {
            return EMAIL_CHANNEL;
        }
        if (SMS_CHANNEL.getChannelType().equals(channelType)) {
            return SMS_CHANNEL;
        }
        if (EXTERNAL_CHANNEL.getChannelType().equals(channelType)) {
            return EXTERNAL_CHANNEL;
        }
        throw new NotificationChannelManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS.getMessage());
    }
}

