/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.listener;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.governance.model.UserIdentityClaim;
import org.wso2.carbon.identity.governance.store.UserIdentityDataStore;
import org.wso2.carbon.identity.governance.store.UserStoreBasedIdentityDataStore;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.model.UserClaimSearchEntry;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityStoreEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityStoreEventListener.class);
    private static final String PRE_SET_USER_CLAIM_VALUES = "PreSetUserClaimValues";
    private static final String PRE_USER_ADD_CLAIM_VALUES = "PreAddUserClaimValues";
    private static final String USER_OPERATION_EVENT_LISTENER_TYPE = "org.wso2.carbon.user.core.listener.UserOperationEventListener";
    private static final String DATA_STORE_PROPERTY_NAME = "Data.Store";
    private UserIdentityDataStore identityDataStore;
    private static final String INVALID_OPERATION = "InvalidOperation";
    private static final String USER_IDENTITY_CLAIMS = "UserIdentityClaims";

    public IdentityStoreEventListener() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        String storeClassName = IdentityUtil.readEventListenerProperty((String)USER_OPERATION_EVENT_LISTENER_TYPE, (String)((Object)((Object)this)).getClass().getName()).getProperties().get(DATA_STORE_PROPERTY_NAME).toString();
        Class<?> clazz = Class.forName(storeClassName.trim());
        this.identityDataStore = (UserIdentityDataStore)clazz.newInstance();
    }

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 100;
    }

    public boolean doPreAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPreAddUser executed in the IdentityStoreEventListener for user: " + userName));
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(USER_IDENTITY_CLAIMS);
        HashMap<String, String> userDataMap = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = claims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> claim = it.next();
            if (!claim.getKey().contains("http://wso2.org/claims/identity") || this.identityDataStore instanceof UserStoreBasedIdentityDataStore) continue;
            userDataMap.put(claim.getKey(), claim.getValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)(claim.getKey() + " claim added to thread local for user: " + userName + " in preUserAdd"));
            }
            it.remove();
        }
        UserIdentityClaim userIdentityClaim = new UserIdentityClaim(userName, userDataMap);
        userIdentityClaim.setTenantId(userStoreManager.getTenantId());
        ((Map)IdentityUtil.threadLocalProperties.get()).put(USER_IDENTITY_CLAIMS, userIdentityClaim);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPostAddUser executed in the IdentityStoreEventListener for user: " + userName));
        }
        try {
            Map<String, String> userIdentityDataMap;
            UserIdentityClaim userIdentityClaims = (UserIdentityClaim)((Map)IdentityUtil.threadLocalProperties.get()).get(USER_IDENTITY_CLAIMS);
            if (userIdentityClaims == null) {
                userIdentityDataMap = new HashMap<String, String>();
            } else {
                userIdentityDataMap = userIdentityClaims.getUserIdentityDataMap();
                claims.putAll(userIdentityDataMap);
            }
            boolean bl = this.storeInIdentityDataStore(userName, userStoreManager, PRE_USER_ADD_CLAIM_VALUES, userIdentityDataMap);
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(USER_IDENTITY_CLAIMS);
        }
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        boolean accountLocked;
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPreSetUserClaimValues executed in the IdentityStoreEventListener for user: " + userName));
        }
        if (accountLocked = Boolean.parseBoolean(claims.get("http://wso2.org/claims/identity/accountLocked"))) {
            IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17003");
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
        }
        return this.storeInIdentityDataStore(userName, userStoreManager, PRE_SET_USER_CLAIM_VALUES, claims);
    }

    public boolean doPostGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, org.wso2.carbon.user.core.UserStoreManager storeManager) {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPostGetUserClaimValues getting executed in the IdentityStoreEventListener for user: " + userName));
        }
        if (this.identityDataStore instanceof UserStoreBasedIdentityDataStore) {
            return true;
        }
        if (claimMap == null) {
            claimMap = new HashMap<String, String>();
        }
        boolean containsIdentityClaims = false;
        for (String claim : claims) {
            if (!claim.contains("http://wso2.org/claims/identity")) continue;
            containsIdentityClaims = true;
            break;
        }
        if (!containsIdentityClaims) {
            return true;
        }
        UserIdentityClaim identityDTO = this.identityDataStore.load(userName, (UserStoreManager)storeManager);
        if (identityDTO == null) {
            return true;
        }
        for (String claim : claims) {
            String value;
            if (!identityDTO.getUserIdentityDataMap().containsKey(claim) || !StringUtils.isNotBlank((String)(value = identityDTO.getUserIdentityDataMap().get(claim)))) continue;
            claimMap.put(claim, value);
        }
        return true;
    }

    public boolean doPreGetUserClaimValue(String userName, String claim, String profileName, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)claim) && claim.contains("http://wso2.org/claims/identity")) {
            throw new UserStoreException("InvalidOperation This operation is not supported for Identity claims");
        }
        return true;
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)claimURI) && claimURI.contains("http://wso2.org/claims/identity")) {
            throw new UserStoreException("InvalidOperation This operation is not supported for Identity claims");
        }
        return true;
    }

    public boolean doPreGetUserList(String claimUri, String claimValue, List<String> returnUserNameList, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPreGetUserList executed in the IdentityStoreEventListener for claim URI: " + claimUri + " and claim value: " + claimValue));
        }
        try {
            List<String> userIds = this.identityDataStore.list(claimUri, claimValue, userStoreManager);
            String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
            if (StringUtils.equalsIgnoreCase((String)userStoreDomain, (String)"PRIMARY")) {
                for (String userId : userIds) {
                    if (StringUtils.contains((String)userId, (String)UserCoreConstants.DOMAIN_SEPARATOR) && !StringUtils.startsWith((String)userId, (String)("PRIMARY" + UserCoreConstants.DOMAIN_SEPARATOR))) continue;
                    returnUserNameList.add(userId);
                }
            } else {
                returnUserNameList.addAll(userIds);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieved " + userIds.size() + " users for claim: " + claimUri));
            }
            return true;
        }
        catch (IdentityException e) {
            throw new UserStoreException("Error while listing the users for given claim: " + claimUri, (Throwable)e);
        }
    }

    public boolean doPostDeleteUser(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doPostDeleteUser executed in the IdentityStoreEventListener for user: " + userName));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed Identity Claims of user: " + userName + " from IdentityDataStore."));
            }
            this.identityDataStore.remove(userName, (UserStoreManager)userStoreManager);
            return true;
        }
        catch (IdentityException e) {
            throw new UserStoreException("Error while removing user: " + userName + " from identity data store", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeInIdentityDataStore(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String operationType, Map<String, String> claims) throws UserStoreException {
        if (this.identityDataStore instanceof UserStoreBasedIdentityDataStore) {
            return true;
        }
        try {
            if (!((Map)IdentityUtil.threadLocalProperties.get()).containsKey(operationType)) {
                ((Map)IdentityUtil.threadLocalProperties.get()).put(operationType, true);
                UserIdentityClaim userIdentityClaim = null;
                if (!StringUtils.equalsIgnoreCase((String)operationType, (String)PRE_USER_ADD_CLAIM_VALUES)) {
                    userIdentityClaim = this.identityDataStore.load(userName, (UserStoreManager)userStoreManager);
                }
                if (userIdentityClaim == null) {
                    userIdentityClaim = new UserIdentityClaim(userName);
                }
                Iterator<Map.Entry<String, String>> it = claims.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> claim = it.next();
                    String key = claim.getKey();
                    String value = claim.getValue();
                    if (!key.contains("http://wso2.org/claims/identity")) continue;
                    userIdentityClaim.setUserIdentityDataClaim(key, value);
                    it.remove();
                }
                try {
                    this.identityDataStore.store(userIdentityClaim, (UserStoreManager)userStoreManager);
                }
                catch (IdentityException e) {
                    throw new UserStoreException("Error while saving user identityDataStore data for user : " + userName, (Throwable)e);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(operationType);
        }
    }

    public boolean doPostGetUsersClaimValues(String[] userNames, String[] claims, String profileName, UserClaimSearchEntry[] userClaimSearchEntries) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Method doPostGetUsersClaimValues getting executed in the IdentityStoreEventListener.");
        }
        if (this.identityDataStore instanceof UserStoreBasedIdentityDataStore) {
            return true;
        }
        boolean containsIdentityClaims = false;
        for (String claim : claims) {
            if (!claim.contains("http://wso2.org/claims/identity")) continue;
            containsIdentityClaims = true;
            break;
        }
        if (!containsIdentityClaims) {
            return true;
        }
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = this.getUserStoreManager();
        for (UserClaimSearchEntry userClaimSearchEntry : userClaimSearchEntries) {
            UserIdentityClaim identityDTO;
            String username = userClaimSearchEntry.getUserName();
            if (username == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Username found to be null while method doPostGetUsersClaimValues getting executed in the IdentityStoreEventListener.");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Method doPostGetUsersClaimValues getting executed in the IdentityStoreEventListener for user: " + username));
            }
            if (userClaimSearchEntry.getClaims() == null) {
                userClaimSearchEntry.setClaims(new HashMap());
            }
            if ((identityDTO = this.identityDataStore.load(userClaimSearchEntry.getUserName(), (UserStoreManager)userStoreManager.getSecondaryUserStoreManager(UserCoreUtil.extractDomainFromName((String)username)))) == null) continue;
            for (String claim : claims) {
                if (!identityDTO.getUserIdentityDataMap().containsKey(claim)) continue;
                userClaimSearchEntry.getClaims().put(claim, identityDTO.getUserIdentityDataMap().get(claim));
            }
        }
        return true;
    }

    private org.wso2.carbon.user.core.UserStoreManager getUserStoreManager() throws UserStoreException {
        UserRealm userRealm;
        RealmService realmService = IdentityMgtServiceDataHolder.getInstance().getRealmService();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            userRealm = (UserRealm)realmService.getTenantUserRealm(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while retrieving user realm.", (Throwable)e);
        }
        return userRealm.getUserStoreManager();
    }
}

