/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.governance.model.UserIdentityClaim;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.LoginIdentifier;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.model.Condition;
import org.wso2.carbon.user.core.model.UniqueIDUserClaimSearchEntry;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IdentityMgtEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(IdentityMgtEventListener.class);
    IdentityEventService eventMgtService = IdentityMgtServiceDataHolder.getInstance().getIdentityEventService();
    private static String RE_CAPTCHA_USER_DOMAIN = "user-domain-recaptcha";
    private static String USER_EXIST_THREAD_LOCAL_PROPERTY = "userExistThreadLocalProperty";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 95;
    }

    public boolean doPreAuthenticate(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre authenticator is called in IdentityMgtEventListener");
        }
        IdentityUtil.clearIdentityErrorMsg();
        if (userStoreManager.isExistingUser(userName)) {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(RE_CAPTCHA_USER_DOMAIN);
            ((Map)IdentityUtil.threadLocalProperties.get()).put(RE_CAPTCHA_USER_DOMAIN, IdentityGovernanceUtil.getUserStoreDomainName((UserStoreManager)userStoreManager));
        }
        String eventName = "PRE_AUTHENTICATION";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", credential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostAuthenticate(String userName, boolean authenticated, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post authenticator is called in IdentityMgtEventListener");
        }
        if (!this.isUserExistsInDomain(userStoreManager, userName, authenticated)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IdentityMgtEventListener returns since user: " + userName + " not available in current user store domain: " + userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName")));
            }
            return true;
        }
        this.setUserExistThreadLocal(userName, userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName"));
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("UserAccountState");
        String eventName = "POST_AUTHENTICATION";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("OPERATION_STATUS", authenticated);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        if (authenticated) {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(RE_CAPTCHA_USER_DOMAIN);
        }
        return true;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre set claims is called in IdentityMgtEventListener");
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("UserAccountState");
        String eventName = "PRE_SET_USER_CLAIMS";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Post set claims is called in IdentityMgtEventListener");
        }
        String eventName = "POST_SET_USER_CLAIMS";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPreAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pre add user is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_ADD_USER";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claims);
        properties.put("ROLE_LIST", roleList);
        properties.put("PROFILE_NAME", profile);
        properties.put("CREDENTIAL", credential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post add user is called in IdentityMgtEventListener");
        }
        String eventName = "POST_ADD_USER";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claims);
        properties.put("ROLE_LIST", roleList);
        properties.put("PROFILE_NAME", profile);
        properties.put("CREDENTIAL", credential);
        properties = this.addEventProperties(userName, properties);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    private HashMap<String, Object> addEventProperties(String username, HashMap<String, Object> properties) {
        String[] requiredClaims = new String[]{"http://wso2.org/claims/identity/preferredChannel", NotificationChannels.EMAIL_CHANNEL.getVerifiedClaimUrl(), NotificationChannels.SMS_CHANNEL.getVerifiedClaimUrl()};
        Map<String, String> userIdentityDataMap = this.getUserIdentityDataMap(username);
        if (userIdentityDataMap != null && !userIdentityDataMap.isEmpty()) {
            for (String claim : requiredClaims) {
                String value = userIdentityDataMap.get(claim);
                if (!StringUtils.isNotEmpty((String)value)) continue;
                properties.put(claim, value);
            }
        }
        return properties;
    }

    private Map<String, String> getUserIdentityDataMap(String username) {
        if (IdentityUtil.threadLocalProperties != null) {
            UserIdentityClaim userIdentityClaims = (UserIdentityClaim)((Map)IdentityUtil.threadLocalProperties.get()).get("UserIdentityClaims");
            if (userIdentityClaims == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No identity claims for user : " + username));
                }
                return null;
            }
            return userIdentityClaims.getUserIdentityDataMap();
        }
        return null;
    }

    public boolean doPreUpdateCredential(String userName, Object newCredential, Object oldCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update credential is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_CREDENTIAL";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", newCredential);
        properties.put("OLD_CREDENTIAL", oldCredential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update credential is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_CREDENTIAL";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", credential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPreUpdateCredentialByAdmin(String userName, Object newCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update credential by admin is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_CREDENTIAL_BY_ADMIN";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", newCredential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update credential by admin is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_CREDENTIAL_BY_ADMIN";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", credential);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPreDeleteUser(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER";
        this.handleEvent(userName, userStoreManager, eventName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPostDeleteUser(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete user is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER";
        this.handleEvent(userName, userStoreManager, eventName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre set user claim value is called in IdentityMgtEventListener");
        }
        ((Map)IdentityUtil.threadLocalProperties.get()).remove("UserAccountState");
        String eventName = "PRE_SET_USER_CLAIM";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimURI);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post set user claim value is called in IdentityMgtEventListener");
        }
        String eventName = "POST_SET_USER_CLAIM";
        this.handleEvent(userName, userStoreManager, eventName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPreDeleteUserClaimValues(String userName, String[] claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user claim values is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER_CLAIMS";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostDeleteUserClaimValues(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete user claim values is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER_CLAIMS";
        this.handleEvent(userName, userStoreManager, eventName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPreDeleteUserClaimValue(String userName, String claimURI, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user claim value is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER_CLAIM";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimURI);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostDeleteUserClaimValue(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete user claim value is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER_CLAIM";
        this.handleEvent(userName, userStoreManager, eventName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPreAddRole(String roleName, String[] userList, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre add role is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_ADD_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_LIST", userList);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPostAddRole(String roleName, String[] userList, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post add role is called in IdentityMgtEventListener");
        }
        String eventName = "POST_ADD_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_LIST", userList);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPreDeleteRole(String roleName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete role is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_ROLE";
        this.handleEvent(null, userStoreManager, eventName, roleName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPostDeleteRole(String roleName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete role is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_ROLE";
        this.handleEvent(null, userStoreManager, eventName, roleName, new HashMap<String, Object>());
        return true;
    }

    public boolean doPreUpdateRoleName(String roleName, String newRoleName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update role name is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("NEW_ROLE_NAME", newRoleName);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPostUpdateRoleName(String roleName, String newRoleName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update role name is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("NEW_ROLE_NAME", newRoleName);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPreUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update user list of role is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_USER_LIST_OF_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("DELETED_USERS", deletedUsers);
        properties.put("NEW_USERS", newUsers);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update user list of role is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_USER_LIST_OF_ROLE";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("DELETED_USERS", deletedUsers);
        properties.put("NEW_USERS", newUsers);
        this.handleEvent(null, userStoreManager, eventName, roleName, properties);
        return true;
    }

    public boolean doPreUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update role list of user is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_ROLE_LIST_OF_USER";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("DELETED_ROLES", deletedRoles);
        properties.put("NEW_ROLES", newRoles);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update role list of user is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_ROLE_LIST_OF_USER";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("DELETED_ROLES", deletedRoles);
        properties.put("NEW_ROLES", newRoles);
        this.handleEvent(userName, userStoreManager, eventName, properties);
        return true;
    }

    public boolean doPreAddInternalRoleWithID(String roleName, String[] userIDs, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre add  internal role with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_ADD_INTERNAL_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("USER_IDS", userIDs);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAddInternalRoleWithID(String roleName, String[] userIDs, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post add internal role with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_ADD_INTERNAL_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("USER_IDS", userIDs);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserClaimValueWithID(String userID, String claim, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claim);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserClaimValuesWithID(String userID, String[] claims, String profileName, Map<String, String> claimMap, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claims);
        properties.put("PROFILE_NAME", profileName);
        properties.put("USER_CLAIMS", claimMap);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserClaimValueWithID(String userID, String claim, List<String> claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claim);
        properties.put("PROFILE_NAME", profileName);
        properties.put("CLAIM_VALUE", claimValue);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserClaimValuesWithID(String userID, String[] claims, String profileName, Map<String, String> claimMap, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claims);
        properties.put("PROFILE_NAME", profileName);
        properties.put("USER_CLAIMS", claimMap);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserListWithID(String claimUri, String claimValue, List<User> returnUsersList, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user user list with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_LIST_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimUri);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("USER_LIST", returnUsersList);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user user list condition with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_LIST_CONDITION_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CONDITION", condition);
        properties.put("userstore-domain", domain);
        properties.put("PROFILE_NAME", profileName);
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        properties.put("SORT_BY", sortBy);
        properties.put("SORT_ORDER", sortOrder);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserListWithID(String claimUri, String claimValue, int limit, int offset, List<User> returnUsersList, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user user list pagination with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_LIST_PAGINATION_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimUri);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("USER_LIST", returnUsersList);
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserListWithID(String claimUri, String claimValue, List<User> returnValues, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user user list with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_LIST_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimUri);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("USER_LIST", returnValues);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserListWithID(String claimUri, String claimValue, List<User> returnValues, int limit, int offset, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user user list pagination with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_LIST_PAGINATION_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimUri);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("USER_LIST", returnValues);
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserListWithID(Condition condition, String domain, String profileName, int limit, int offset, String sortBy, String sortOrder, List<User> users, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user user list condition with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_LIST_CONDITION_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CONDITION", condition);
        properties.put("userstore-domain", domain);
        properties.put("PROFILE_NAME", profileName);
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        properties.put("SORT_BY", sortBy);
        properties.put("SORT_ORDER", sortOrder);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreGetUserWithID(String userID, String[] requestedClaims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre get user with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_GET_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_VALUE", requestedClaims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserWithID(String userID, String[] requestedClaims, String profileName, User user, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_VALUE", requestedClaims);
        properties.put("PROFILE_NAME", profileName);
        properties.put("USER", user);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetPaginatedUserListWithID(String claimUri, String claimValue, List<User> returnValues, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get paginated user list with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_PAGINATED_USER_LIST_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claimUri);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("USER_LIST", returnValues);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostListUsersWithID(String filter, int limit, int offset, List<User> returnValues, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get list users with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_LIST_USERS_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("FILTER", filter);
        properties.put("OFFSET", offset);
        properties.put("USER_LIST", returnValues);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetRoleListOfUserWithID(String userName, String filter, String[] roleList, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get role list of user with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_ROLE_LIST_OF_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user-name", userName);
        properties.put("FILTER", filter);
        properties.put("ROLE_LIST", roleList);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUserListOfRoleWithID(String roleName, List<User> userList, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user list of role with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_ROLE_LIST_OF_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("USER_LIST", userList);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetUsersClaimValuesWithID(List<String> userIDs, List<String> claims, String profileName, List<UniqueIDUserClaimSearchEntry> userClaimSearchEntries, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get users claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USERS_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_IDS", userIDs);
        properties.put("CLAIM_URI", claims);
        properties.put("PROFILE_NAME", profileName);
        properties.put("USER_CLAIM_SEARCH_ENTRIES", userClaimSearchEntries);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreAuthenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre authenticate with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_AUTHENTICATE_CLAIM_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", preferredUserNameValue);
        properties.put("CLAIM_VALUE", preferredUserNameValue);
        properties.put("CREDENTIAL", credential);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAuthenticateWithID(String preferredUserNameClaim, String preferredUserNameValue, AuthenticationResult authenticationResult, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post authenticate with id by claim is called in IdentityMgtEventListener");
        }
        String eventName = "POST_AUTHENTICATE_CLAIM_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", preferredUserNameValue);
        properties.put("CLAIM_VALUE", preferredUserNameValue);
        properties.put("AUTHENTICATION_RESULT", authenticationResult);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre authenticate with id by login identifier is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_AUTHENTICATE_LOGIN_IDENTIFIER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", credential);
        properties.put("LOGIN_IDENTIFIERS", loginIdentifiers);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAuthenticateWithID(List<LoginIdentifier> loginIdentifiers, AuthenticationResult authenticationResult, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post authenticate with id by login identifier is called in IdentityMgtEventListener");
        }
        String eventName = "POST_AUTHENTICATE_LOGIN_IDENTIFIER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("AUTHENTICATION_RESULT", authenticationResult);
        properties.put("LOGIN_IDENTIFIERS", loginIdentifiers);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreAuthenticateWithID(String userID, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre authenticate with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_AUTHENTICATE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CREDENTIAL", credential);
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAuthenticateWithID(String userID, AuthenticationResult authenticationResult, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post authenticate with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_AUTHENTICATE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("AUTHENTICATION_RESULT", authenticationResult);
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre add user with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_ADD_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user-name", userName);
        properties.put("CREDENTIAL", credential);
        properties.put("ROLE_LIST", roleList);
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profile);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAddUserWithID(User user, Object credential, String[] roleList, Map<String, String> claims, String profile, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post add user with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_ADD_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER", user);
        properties.put("CREDENTIAL", credential);
        properties.put("ROLE_LIST", roleList);
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profile);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update credential with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_CREDENTIAL_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CREDENTIAL", newCredential);
        properties.put("OLD_CREDENTIAL", oldCredential);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostUpdateCredentialWithID(String userID, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update credential with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_CREDENTIAL_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CREDENTIAL", credential);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreUpdateCredentialByAdminWithID(String userID, Object newCredential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update credential by admin with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_CREDENTIAL_BY_ADMIN_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CREDENTIAL", newCredential);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostUpdateCredentialByAdminWithID(String userID, Object credential, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update credential by admin with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_CREDENTIAL_BY_ADMIN_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CREDENTIAL", credential);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreDeleteUserWithID(String userID, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostDeleteUserWithID(String userID, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete user with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreSetUserClaimValueWithID(String userID, String claimURI, String claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre set user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_SET_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claimURI);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostSetUserClaimValueWithID(String userID, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post set user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_SET_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre set user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_SET_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostSetUserClaimValuesWithID(String userID, Map<String, String> claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post set user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_SET_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("USER_CLAIMS", claims);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostDeleteUserClaimValuesWithID(String userID, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user claim values with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER_CLAIM_VALUES_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreDeleteUserClaimValueWithID(String userID, String claimURI, String profileName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre delete user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_DELETE_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("CLAIM_URI", claimURI);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostDeleteUserClaimValueWithID(String userID, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post delete user claim value with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_DELETE_USER_CLAIM_VALUE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreAddRoleWithID(String roleName, String[] userList, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre add role with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_ADD_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("USER_IDS", userList);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostAddRoleWithID(String roleName, String[] userList, Permission[] permissions, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post add role with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_ADD_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("USER_IDS", userList);
        properties.put("PERMISSIONS", permissions);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreUpdateUserListOfRoleWithID(String roleName, String[] deletedUsers, String[] newUsers, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update user list of role with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_USER_LIST_OF_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("DELETED_USERS", deletedUsers);
        properties.put("NEW_USERS", newUsers);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostUpdateUserListOfRoleWithID(String roleName, String[] deletedUsers, String[] newUsers, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update user list of role with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_USER_LIST_OF_ROLE_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("role-name", roleName);
        properties.put("DELETED_USERS", deletedUsers);
        properties.put("NEW_USERS", newUsers);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPreUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"pre update role list of user with id is called in IdentityMgtEventListener");
        }
        String eventName = "PRE_UPDATE_ROLE_LIST_OF_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("DELETED_ROLES", deletedRoles);
        properties.put("NEW_ROLES", newRoles);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post update role list of user with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_UPDATE_ROLE_LIST_OF_USER_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_ID", userID);
        properties.put("DELETED_ROLES", deletedRoles);
        properties.put("NEW_ROLES", newRoles);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    public boolean doPostGetRoleListOfUsersWithID(List<String> userIDs, Map<String, List<String>> rolesOfUsersMap, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get role list of users with id is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_ROLE_LIST_OF_USERS_WITH_ID";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_IDS", userIDs);
        properties.put("ROLE_LIST", rolesOfUsersMap);
        this.handleEvent(eventName, properties, userStoreManager);
        return true;
    }

    private void handleEvent(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String eventName, HashMap<String, Object> properties) throws UserStoreException {
        this.handleEvent(userName, userStoreManager, eventName, null, properties);
    }

    private void handleEvent(String userName, org.wso2.carbon.user.core.UserStoreManager userStoreManager, String eventName, String roleName, HashMap<String, Object> properties) throws UserStoreException {
        if (StringUtils.isNotBlank((String)userName)) {
            properties.put("user-name", userName);
        }
        if (StringUtils.isNotBlank((String)roleName)) {
            properties.put("role-name", roleName);
        }
        this.handleEvent(eventName, properties, userStoreManager);
    }

    private void handleEvent(String eventName, HashMap<String, Object> properties, org.wso2.carbon.user.core.UserStoreManager userStoreManager) throws UserStoreException {
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            int tenantId = userStoreManager.getTenantId();
            String userTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            try {
                RealmService realmService = IdentityMgtServiceDataHolder.getInstance().getRealmService();
                TenantManager tenantManager = realmService.getTenantManager();
                userTenantDomain = tenantManager.getDomain(tenantId);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                log.error((Object)("Unable to get the get the domain from realmService for tenant: " + tenantId), (Throwable)e);
            }
            properties.put("userStoreManager", userStoreManager);
            properties.put("tenantId", PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            properties.put("tenant-domain", userTenantDomain);
            if (!TenantMgtUtil.isTenantAdminCreationOperation()) {
                this.eventMgtService.handleEvent(identityMgtEvent);
            }
        }
        catch (IdentityEventException e) {
            String errorCode = e.getErrorCode();
            if (StringUtils.isNotEmpty((String)errorCode) && (StringUtils.equals((String)errorCode, (String)"22001") || StringUtils.equals((String)errorCode, (String)"40001") || StringUtils.equals((String)errorCode, (String)"40002") || "17003".equals(errorCode) || "17004".equals(errorCode) || "17005".equals(errorCode))) {
                throw new UserStoreException(e.getMessage(), (Throwable)e);
            }
            throw new UserStoreException("Error when handling event : " + eventName, (Throwable)e);
        }
    }

    public boolean doPostGetUserClaimValue(String userName, String claim, List<String> claimValue, String profileName, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user claim value is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_CLAIM";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CLAIM_URI", claim);
        properties.put("CLAIM_VALUE", claimValue);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, storeManager, eventName, properties);
        return true;
    }

    public boolean doPostGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, org.wso2.carbon.user.core.UserStoreManager storeManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"post get user claim values is called in IdentityMgtEventListener");
        }
        String eventName = "POST_GET_USER_CLAIMS";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER_CLAIMS", claimMap);
        properties.put("PROFILE_NAME", profileName);
        this.handleEvent(userName, storeManager, eventName, properties);
        return true;
    }

    private boolean isUserExistsInDomain(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName) throws UserStoreException {
        boolean isExists = false;
        if (userStoreManager.isExistingUser(userName)) {
            isExists = true;
        }
        return isExists;
    }

    private boolean isUserExistsInDomain(org.wso2.carbon.user.core.UserStoreManager userStoreManager, String userName, boolean authenticated) throws UserStoreException {
        boolean isExists = false;
        if (authenticated) {
            String userDomain = UserCoreUtil.getDomainFromThreadLocal();
            String userStoreDomain = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
            if (userDomain != null) {
                if (userDomain.equalsIgnoreCase(userStoreDomain)) {
                    isExists = true;
                }
            } else if (IdentityUtil.getPrimaryDomainName().equalsIgnoreCase(userStoreDomain)) {
                isExists = true;
            }
        } else {
            isExists = this.isUserExistsInDomain(userStoreManager, userName);
        }
        return isExists;
    }

    private void setUserExistThreadLocal(String userName, String userStoreDomain) {
        ((Map)IdentityUtil.threadLocalProperties.get()).put(USER_EXIST_THREAD_LOCAL_PROPERTY, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("The %s is added as true to the thread local for the user: %s in the user store domain: %s.", USER_EXIST_THREAD_LOCAL_PROPERTY, userName, userStoreDomain));
        }
    }
}

