/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.internal.service.impl.notification;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.IdentityMgtConstants;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerClientException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerServerException;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannelManager;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class DefaultNotificationChannelManager
implements NotificationChannelManager {
    private static final Log log = LogFactory.getLog(DefaultNotificationChannelManager.class);
    private ArrayList<NotificationChannels> channels = new ArrayList();

    public DefaultNotificationChannelManager() {
        this.channels.add(NotificationChannels.EMAIL_CHANNEL);
        this.channels.add(NotificationChannels.SMS_CHANNEL);
    }

    @Override
    public boolean isSupportedChannel(String preferredChannel) {
        for (NotificationChannels channel : this.channels) {
            if (!channel.getChannelType().equalsIgnoreCase(preferredChannel)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Given preferred channel : " + preferredChannel + " is supported by the server"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Given preferred channel : " + preferredChannel + " is not supported by the server"));
        }
        return false;
    }

    @Override
    public String resolveCommunicationChannel(String username, String tenantDomain, String userstoreDomain, Map<String, String> claimsMap) throws NotificationChannelManagerException {
        boolean isChannelResolvingEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"Notification.ResolveNotificationChannels.Enable"));
        if (!isChannelResolvingEnabled) {
            return IdentityGovernanceUtil.getDefaultNotificationChannel();
        }
        String preferredChannel = claimsMap.get("http://wso2.org/claims/identity/preferredChannel");
        if (StringUtils.isNotEmpty((String)preferredChannel)) {
            if (this.isSupportedChannel(preferredChannel)) {
                if (this.validatePreferredChannelWithValuesInClaimMap(preferredChannel, claimsMap)) {
                    return preferredChannel;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No value in the matching claim for preferred channel : " + preferredChannel));
                }
                throw new NotificationChannelManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CLAIM_MATCHED_FOR_PREFERRED_CHANNEL.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CLAIM_MATCHED_FOR_PREFERRED_CHANNEL.getMessage());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Given preferred channel : " + preferredChannel + " is not supported by the server"));
            }
            throw new NotificationChannelManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNEL.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_PREFERRED_CHANNEL.getMessage());
        }
        preferredChannel = this.resolveCommunicationChannel(this.channels, claimsMap);
        return preferredChannel;
    }

    @Override
    public String resolveCommunicationChannel(String username, String tenantDomain, String userstoreDomain) throws NotificationChannelManagerException {
        boolean isChannelResolvingEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"Notification.ResolveNotificationChannels.Enable"));
        if (!isChannelResolvingEnabled) {
            return IdentityGovernanceUtil.getDefaultNotificationChannel();
        }
        Map<String, String> claimMap = this.buildChannelClaimsMap(username, tenantDomain);
        if (MapUtils.isEmpty(claimMap)) {
            if (log.isDebugEnabled()) {
                String error = String.format("No notification channel for user : %1$s with domain : %2$s.", userstoreDomain + CarbonConstants.DOMAIN_SEPARATOR + username, tenantDomain);
                log.debug((Object)error);
            }
            throw new NotificationChannelManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_NOTIFICATION_CHANNELS.getMessage());
        }
        String preferredChannel = claimMap.get("http://wso2.org/claims/identity/preferredChannel");
        if (StringUtils.isNotEmpty((String)preferredChannel)) {
            if (this.validatePreferredChannelWithValuesInClaimMap(preferredChannel, claimMap)) {
                return preferredChannel;
            }
            throw new NotificationChannelManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CLAIM_MATCHED_FOR_PREFERRED_CHANNEL.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CLAIM_MATCHED_FOR_PREFERRED_CHANNEL.getMessage());
        }
        return this.resolveCommunicationChannel(this.channels, claimMap);
    }

    private boolean validatePreferredChannelWithValuesInClaimMap(String preferredChannel, Map<String, String> claimsMap) throws NotificationChannelManagerClientException {
        NotificationChannels channel = NotificationChannels.getNotificationChannel(preferredChannel);
        return StringUtils.isNotEmpty((String)claimsMap.get(channel.getClaimUri()));
    }

    private String resolveCommunicationChannel(ArrayList<NotificationChannels> channels, Map<String, String> claimsMap) {
        ArrayList<String> availableChannels = new ArrayList<String>();
        for (NotificationChannels channel : channels) {
            String value = claimsMap.get(channel.getClaimUri());
            if (!StringUtils.isNotEmpty((String)value)) continue;
            availableChannels.add(channel.getChannelType());
        }
        if (!availableChannels.isEmpty()) {
            if (availableChannels.size() > 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Multiple notification channels available for the user");
                }
                return this.resolveMultipleAvailableChannels(availableChannels);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Single notification channel is available : " + availableChannels.get(0)));
            }
            return availableChannels.get(0);
        }
        return null;
    }

    private String resolveMultipleAvailableChannels(ArrayList<String> availableChannels) {
        String serverDefaultChannel = IdentityGovernanceUtil.getDefaultNotificationChannel();
        if (availableChannels.contains(serverDefaultChannel)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User has multiple communication channels. Using server default configuration : " + serverDefaultChannel + " channel as the communication channel"));
            }
            return serverDefaultChannel;
        }
        String availableChannel = availableChannels.get(0);
        if (log.isDebugEnabled()) {
            String message = String.format("User does not have server default channel : %1$s. Therefore,communication channel is set to : %2$s", serverDefaultChannel, availableChannel);
            log.debug((Object)message);
        }
        return availableChannel;
    }

    private ArrayList<String> getChannelsClaimList(ArrayList<NotificationChannels> channels) {
        ArrayList<String> claimList = new ArrayList<String>();
        for (NotificationChannels channel : channels) {
            claimList.add(channel.getClaimUri());
        }
        return claimList;
    }

    private Map<String, String> buildChannelClaimsMap(String username, String tenantDomain) throws NotificationChannelManagerServerException {
        Map claimValues;
        ArrayList<String> claimUrls = this.getChannelsClaimList(this.channels);
        claimUrls.add("http://wso2.org/claims/identity/preferredChannel");
        UserStoreManager userStoreManager = this.getUserstoreManager(username, tenantDomain);
        try {
            claimValues = userStoreManager.getUserClaimValues(username, claimUrls.toArray(new String[0]), null);
        }
        catch (UserStoreException exception) {
            String[] channelClaims = new String[]{NotificationChannels.SMS_CHANNEL.getClaimUri(), NotificationChannels.EMAIL_CHANNEL.getClaimUri()};
            try {
                claimValues = userStoreManager.getUserClaimValues(username, channelClaims, null);
            }
            catch (UserStoreException e) {
                throw new NotificationChannelManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getMessage(), e);
            }
        }
        return claimValues;
    }

    private UserStoreManager getUserstoreManager(String username, String tenantDomain) throws NotificationChannelManagerServerException {
        try {
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            RealmService realmService = IdentityMgtServiceDataHolder.getInstance().getRealmService();
            UserRealm userRealm = realmService.getTenantUserRealm(tenantId);
            if (userRealm != null) {
                return userRealm.getUserStoreManager();
            }
            if (log.isDebugEnabled()) {
                String error = String.format("User Realm returned NULL for user : %1$s with in domain : %2$s", username, tenantDomain);
                log.debug((Object)error);
            }
            throw new NotificationChannelManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getMessage());
        }
        catch (UserStoreException e) {
            throw new NotificationChannelManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getCode(), IdentityMgtConstants.ErrorMessages.ERROR_CODE_DEFAULT_SERVER_ERROR.getMessage(), e);
        }
    }
}

