/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.ConnectorConfig;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.IdentityGovernanceServiceImpl;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.governance.internal.service.impl.notification.DefaultNotificationChannelManager;
import org.wso2.carbon.identity.governance.listener.IdentityMgtEventListener;
import org.wso2.carbon.identity.governance.listener.IdentityStoreEventListener;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannelManager;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.governance.internal.IdentityMgtServiceComponent", immediate=true)
public class IdentityMgtServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityMgtServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            IdentityMgtEventListener listener = new IdentityMgtEventListener();
            context.getBundleContext().registerService(UserOperationEventListener.class, (Object)listener, null);
            context.getBundleContext().registerService(UserOperationEventListener.class, (Object)new IdentityStoreEventListener(), null);
            IdentityGovernanceServiceImpl identityGovernanceService = new IdentityGovernanceServiceImpl();
            context.getBundleContext().registerService(IdentityGovernanceService.class, (Object)identityGovernanceService, null);
            IdentityMgtServiceDataHolder.getInstance().setIdentityGovernanceService(identityGovernanceService);
            DefaultNotificationChannelManager defaultNotificationChannelManager = new DefaultNotificationChannelManager();
            context.getBundleContext().registerService(NotificationChannelManager.class.getName(), (Object)defaultNotificationChannelManager, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Management Listener is enabled");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating identity governance component.", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Management bundle is de-activated");
        }
    }

    protected void unsetIdentityEventService(IdentityEventService identityEventService) {
        IdentityMgtServiceDataHolder.getInstance().setIdentityEventService(null);
    }

    @Reference(name="EventMgtService", service=IdentityEventService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityEventService")
    protected void setIdentityEventService(IdentityEventService identityEventService) {
        IdentityMgtServiceDataHolder.getInstance().setIdentityEventService(identityEventService);
    }

    @Reference(name="idp.mgt.event.listener.service", service=IdentityConnectorConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceConnector")
    protected void setIdentityGovernanceConnector(IdentityConnectorConfig identityConnectorConfig) {
        IdentityMgtServiceDataHolder.getInstance().addIdentityGovernanceConnector(identityConnectorConfig);
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(IdentityMgtServiceComponent.class).getBundleContext();
            bundleContext.registerService(ConnectorConfig.class.getName(), (Object)identityConnectorConfig, null);
        }
        catch (Throwable e) {
            log.error((Object)("Error while re-registering the service " + identityConnectorConfig.getClass().getName() + " as " + ConnectorConfig.class.getName()));
        }
    }

    protected void unsetIdentityGovernanceConnector(IdentityConnectorConfig identityConnectorConfig) {
        IdentityMgtServiceDataHolder.getInstance().unsetIdentityGovernanceConnector(identityConnectorConfig);
    }

    protected void unsetIdpManager(IdpManager idpManager) {
        IdentityMgtServiceDataHolder.getInstance().setIdpManager(null);
    }

    @Reference(name="IdentityProviderManager", service=IdpManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdpManager")
    protected void setIdpManager(IdpManager idpManager) {
        IdentityMgtServiceDataHolder.getInstance().setIdpManager(idpManager);
    }

    @Reference(name="RealmService", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        IdentityMgtServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        log.debug((Object)"UnSetting the Realm Service");
        IdentityMgtServiceDataHolder.getInstance().setRealmService(null);
    }
}

