/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.core.ConnectorException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.user.api.UserStoreManager;

public class IdentityGovernanceUtil {
    private static final Log log = LogFactory.getLog(IdentityGovernanceUtil.class);

    @Deprecated
    public static void saveConnectorDefaultProperties(IdentityConnectorConfig identityConnectorConfig, String tenantDomain) throws ConnectorException {
        IdpManager identityProviderManager = IdentityMgtServiceDataHolder.getInstance().getIdpManager();
        try {
            IdentityProvider residentIdp = identityProviderManager.getResidentIdP(tenantDomain);
            IdentityProviderProperty[] idpProperties = residentIdp.getIdpProperties();
            String[] connectorPropertiesNames = identityConnectorConfig.getPropertyNames();
            ArrayList<IdentityProviderProperty> propertiesToAdd = new ArrayList<IdentityProviderProperty>();
            for (String connectorPropertyName : connectorPropertiesNames) {
                boolean propertyExists = false;
                IdentityProviderProperty[] identityProviderPropertyArray = idpProperties;
                int n = identityProviderPropertyArray.length;
                for (int i = 0; i < n; ++i) {
                    IdentityProviderProperty property = identityProviderPropertyArray[i];
                    if (!connectorPropertyName.equals(property.getName())) continue;
                    propertyExists = true;
                    break;
                }
                if (propertyExists) continue;
                IdentityProviderProperty newProperty = new IdentityProviderProperty();
                newProperty.setName(connectorPropertyName);
                newProperty.setDisplayName((String)identityConnectorConfig.getPropertyNameMapping().get(connectorPropertyName));
                Properties defaultPropertyValues = identityConnectorConfig.getDefaultPropertyValues(tenantDomain);
                newProperty.setValue(String.valueOf(defaultPropertyValues.get(connectorPropertyName)));
                propertiesToAdd.add(newProperty);
            }
            if (propertiesToAdd.size() > 0) {
                String alreadyWrittenPropertyName = identityConnectorConfig.getName() + "." + "AlreadyWritten";
                boolean alreadyWrittenPropertyExists = false;
                for (IdentityProviderProperty property : idpProperties) {
                    if (!alreadyWrittenPropertyName.equals(property.getName())) continue;
                    alreadyWrittenPropertyExists = true;
                    break;
                }
                if (!alreadyWrittenPropertyExists) {
                    IdentityProviderProperty property = new IdentityProviderProperty();
                    property.setName(alreadyWrittenPropertyName);
                    property.setValue("true");
                    propertiesToAdd.add(property);
                }
                propertiesToAdd.addAll(Arrays.asList(idpProperties));
                residentIdp.setIdpProperties(propertiesToAdd.toArray(new IdentityProviderProperty[0]));
                FederatedAuthenticatorConfig[] authenticatorConfigs = residentIdp.getFederatedAuthenticatorConfigs();
                ArrayList<FederatedAuthenticatorConfig> configsToSave = new ArrayList<FederatedAuthenticatorConfig>();
                for (FederatedAuthenticatorConfig authenticatorConfig : authenticatorConfigs) {
                    if (!"passivests".equals(authenticatorConfig.getName()) && !"samlsso".equals(authenticatorConfig.getName())) continue;
                    configsToSave.add(authenticatorConfig);
                }
                residentIdp.setFederatedAuthenticatorConfigs(configsToSave.toArray(new FederatedAuthenticatorConfig[0]));
                identityProviderManager.updateResidentIdP(residentIdp, tenantDomain);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New resident IDP properties for tenant : " + tenantDomain + " written to database"));
                }
            }
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Error while adding identity management properties to resident Idp.", (Throwable)e);
        }
    }

    public static String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = null;
        if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager && StringUtils.isBlank((String)(domainNameProperty = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")))) {
            domainNameProperty = IdentityUtil.getPrimaryDomainName();
        }
        return domainNameProperty;
    }

    public static String getDefaultNotificationChannel() {
        String defaultNotificationChannel = IdentityUtil.getProperty((String)"Notification.DefaultNotificationChannel");
        if (StringUtils.isEmpty((String)defaultNotificationChannel)) {
            return NotificationChannels.EMAIL_CHANNEL.getChannelType();
        }
        return defaultNotificationChannel;
    }
}

