/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.governance.bean.ConnectorConfig;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdpManager;

public class IdentityGovernanceServiceImpl
implements IdentityGovernanceService {
    private static final Log log = LogFactory.getLog(IdentityGovernanceServiceImpl.class);

    @Override
    public void updateConfiguration(String tenantDomain, Map<String, String> configurationDetails) throws IdentityGovernanceException {
        try {
            IdpManager identityProviderManager = IdentityMgtServiceDataHolder.getInstance().getIdpManager();
            IdentityProvider residentIdp = identityProviderManager.getResidentIdP(tenantDomain);
            IdentityProviderProperty[] identityMgtProperties = residentIdp.getIdpProperties();
            ArrayList<IdentityProviderProperty> newProperties = new ArrayList<IdentityProviderProperty>();
            for (IdentityProviderProperty identityMgtProperty : identityMgtProperties) {
                IdentityProviderProperty prop = new IdentityProviderProperty();
                String key = identityMgtProperty.getName();
                prop.setName(key);
                if (configurationDetails.containsKey(key)) {
                    prop.setValue(configurationDetails.get(key));
                } else {
                    prop.setValue(identityMgtProperty.getValue());
                }
                newProperties.add(prop);
                configurationDetails.remove(key);
            }
            for (Map.Entry entry : configurationDetails.entrySet()) {
                IdentityProviderProperty prop = new IdentityProviderProperty();
                prop.setName((String)entry.getKey());
                prop.setValue((String)entry.getValue());
                newProperties.add(prop);
            }
            residentIdp.setIdpProperties(newProperties.toArray(new IdentityProviderProperty[newProperties.size()]));
            FederatedAuthenticatorConfig[] authenticatorConfigs = residentIdp.getFederatedAuthenticatorConfigs();
            ArrayList<FederatedAuthenticatorConfig> arrayList = new ArrayList<FederatedAuthenticatorConfig>();
            for (FederatedAuthenticatorConfig authenticatorConfig : authenticatorConfigs) {
                if (!"passivests".equals(authenticatorConfig.getName()) && !"samlsso".equals(authenticatorConfig.getName())) continue;
                arrayList.add(authenticatorConfig);
            }
            residentIdp.setFederatedAuthenticatorConfigs(arrayList.toArray(new FederatedAuthenticatorConfig[arrayList.size()]));
            identityProviderManager.updateResidentIdP(residentIdp, tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Error while updating identityManagement Properties of Resident Idp.", (Throwable)e);
        }
    }

    @Override
    public Property[] getConfiguration(String tenantDomain) throws IdentityGovernanceException {
        IdpManager identityProviderManager = IdentityMgtServiceDataHolder.getInstance().getIdpManager();
        IdentityProvider residentIdp = null;
        try {
            residentIdp = identityProviderManager.getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format("Error while retrieving resident Idp for %s tenant.", tenantDomain);
            throw new IdentityGovernanceException(errorMsg, e);
        }
        IdentityProviderProperty[] identityMgtProperties = residentIdp.getIdpProperties();
        Property[] configMap = new Property[identityMgtProperties.length];
        int index = 0;
        for (IdentityProviderProperty identityMgtProperty : identityMgtProperties) {
            if ("AlreadyWritten".equals(identityMgtProperty.getName())) continue;
            Property property = new Property();
            property.setName(identityMgtProperty.getName());
            property.setValue(identityMgtProperty.getValue());
            configMap[index] = property;
            ++index;
        }
        return configMap;
    }

    @Override
    public Property[] getConfiguration(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        ArrayList<Property> requestedProperties = new ArrayList<Property>();
        Property[] allProperties = this.getConfiguration(tenantDomain);
        block0: for (String propertyName : propertyNames) {
            for (int i = 0; i < allProperties.length; ++i) {
                if (!propertyName.equals(allProperties[i].getName())) continue;
                requestedProperties.add(allProperties[i]);
                continue block0;
            }
        }
        return requestedProperties.toArray(new Property[requestedProperties.size()]);
    }

    @Override
    public List<IdentityConnectorConfig> getConnectorList() throws IdentityGovernanceException {
        return IdentityMgtServiceDataHolder.getInstance().getIdentityGovernanceConnectorList();
    }

    @Override
    public List<ConnectorConfig> getConnectorListWithConfigs(String tenantDomain) throws IdentityGovernanceException {
        List<IdentityConnectorConfig> list = IdentityMgtServiceDataHolder.getInstance().getIdentityGovernanceConnectorList();
        Property[] properties = this.getConfiguration(tenantDomain);
        ArrayList<ConnectorConfig> configs = new ArrayList<ConnectorConfig>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ConnectorConfig config = new ConnectorConfig();
            Map propertyFriendlyNames = list.get(i).getPropertyNameMapping();
            Map propertyDescriptions = list.get(i).getPropertyDescriptionMapping();
            config.setFriendlyName(list.get(i).getFriendlyName());
            config.setName(list.get(i).getName());
            config.setCategory(list.get(i).getCategory());
            config.setSubCategory(list.get(i).getSubCategory());
            config.setOrder(list.get(i).getOrder());
            String[] connectorProperties = list.get(i).getPropertyNames();
            Property[] configProperties = new Property[connectorProperties.length];
            block1: for (int j = 0; j < connectorProperties.length; ++j) {
                for (Property property : properties) {
                    if (!connectorProperties[j].equals(property.getName())) continue;
                    configProperties[j] = property;
                    configProperties[j].setDisplayName((String)propertyFriendlyNames.get(configProperties[j].getName()));
                    configProperties[j].setDescription((String)propertyDescriptions.get(configProperties[j].getName()));
                    continue block1;
                }
            }
            config.setProperties(configProperties);
            configs.add(i, config);
        }
        return configs;
    }

    @Override
    public Map<String, List<ConnectorConfig>> getCategorizedConnectorListWithConfigs(String tenantDomain) throws IdentityGovernanceException {
        List<ConnectorConfig> connectorListWithConfigs = this.getConnectorListWithConfigs(tenantDomain);
        HashMap<String, List<ConnectorConfig>> categorizedConnectorListWithConfigs = new HashMap<String, List<ConnectorConfig>>();
        for (ConnectorConfig connectorConfig : connectorListWithConfigs) {
            String category = connectorConfig.getCategory();
            if (categorizedConnectorListWithConfigs.get(category) == null) {
                ArrayList<ConnectorConfig> categorizedConnectors = new ArrayList<ConnectorConfig>();
                categorizedConnectors.add(connectorConfig);
                categorizedConnectorListWithConfigs.put(category, categorizedConnectors);
                continue;
            }
            ((List)categorizedConnectorListWithConfigs.get(category)).add(connectorConfig);
        }
        return categorizedConnectorListWithConfigs;
    }

    @Override
    public List<ConnectorConfig> getConnectorListWithConfigsByCategory(String tenantDomain, String category) throws IdentityGovernanceException {
        List<ConnectorConfig> connectorListWithConfigs = this.getConnectorListWithConfigs(tenantDomain);
        ArrayList<ConnectorConfig> categorizedConnectorListWithConfigs = new ArrayList<ConnectorConfig>();
        for (ConnectorConfig connectorConfig : connectorListWithConfigs) {
            if (!connectorConfig.getCategory().equals(category)) continue;
            categorizedConnectorListWithConfigs.add(connectorConfig);
        }
        return categorizedConnectorListWithConfigs;
    }

    @Override
    public ConnectorConfig getConnectorWithConfigs(String tenantDomain, String connectorName) throws IdentityGovernanceException {
        List<ConnectorConfig> connectorListWithConfigs = this.getConnectorListWithConfigs(tenantDomain);
        for (ConnectorConfig connectorConfig : connectorListWithConfigs) {
            if (!connectorConfig.getName().equals(connectorName)) continue;
            return connectorConfig;
        }
        return null;
    }
}

