/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.identity.core.ConnectorException;

public class IdentityGovernanceException
extends ConnectorException {
    public static final int FAILURE = 0;
    public static final int FAILED_AUTHENTICATION = 1;
    public static final int FAILED_ENCRYPTION = 2;
    private static final Map<Integer, String> FAULT_CODE_MAP = new HashMap<Integer, String>();
    private int errorCode;

    IdentityGovernanceException() {
    }

    public IdentityGovernanceException(String message) {
        super(message);
    }

    public IdentityGovernanceException(String message, Throwable cause) {
        super(message, cause);
    }

    public IdentityGovernanceException(Throwable cause) {
        super(cause);
    }

    public IdentityGovernanceException(int errorCode) {
        this(errorCode, null);
    }

    public IdentityGovernanceException(int errorCode, Object[] args) {
        IdentityGovernanceException.getMessage(errorCode, args);
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getMessage(int errorCode, Object[] args) {
        return FAULT_CODE_MAP.get(errorCode);
    }

    static {
        FAULT_CODE_MAP.put(0, "Failure");
        FAULT_CODE_MAP.put(1, "Authentication Failed.");
        FAULT_CODE_MAP.put(2, "Encryption Failed");
    }
}

