/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.governance;

import java.util.HashMap;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.IdentityGovernanceServiceImpl;
import org.wso2.carbon.identity.governance.bean.ConnectorConfig;
import org.wso2.carbon.identity.governance.internal.IdentityMgtServiceDataHolder;

public class IdentityGovernanceAdminService
extends AbstractAdmin {
    public ConnectorConfig[] getConnectorList() throws IdentityGovernanceException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        IdentityGovernanceServiceImpl identityGovernanceService = IdentityMgtServiceDataHolder.getInstance().getIdentityGovernanceService();
        return identityGovernanceService.getConnectorListWithConfigs(tenantDomain).toArray(new ConnectorConfig[0]);
    }

    public void updateConfigurations(Property[] configurations) throws IdentityGovernanceException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        IdentityGovernanceServiceImpl identityGovernanceService = IdentityMgtServiceDataHolder.getInstance().getIdentityGovernanceService();
        HashMap<String, String> confMap = new HashMap<String, String>();
        for (Property configuration : configurations) {
            confMap.put(configuration.getName(), configuration.getValue());
        }
        identityGovernanceService.updateConfiguration(tenantDomain, confMap);
    }
}

