/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer;

import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;

public class DeploymentSynchronizer {
    private static final Log log = LogFactory.getLog(DeploymentSynchronizer.class);
    private int tenantId;
    private String filePath;
    private long lastCommitTime = -1L;
    private long lastCheckoutTime = -1L;
    private boolean autoCommit;
    private boolean autoCheckout;
    private boolean useEventing;
    private AtomicLong lastNotificationTime = new AtomicLong(-1L);
    private AtomicBoolean checkoutRequested = new AtomicBoolean(false);
    private ArtifactRepository artifactRepository;
    private long period = 60L;

    DeploymentSynchronizer(int tenantId, ArtifactRepository artifactRepository, String filePath) {
        this.tenantId = tenantId;
        this.artifactRepository = artifactRepository;
        this.filePath = filePath;
    }

    public void start() {
        if (!this.autoCommit && !this.autoCheckout) {
            return;
        }
        log.info((Object)("Starting a synchronizer on file system at: " + this.filePath));
        try {
            this.doInitialSyncUp();
            if (this.autoCheckout) {
                this.artifactRepository.initAutoCheckout(this.useEventing);
            }
            AutoSyncTask task = new AutoSyncTask();
            DeploymentSynchronizationManager.getInstance().scheduleSynchronizationTask(this.filePath, task, this.period, this.period);
        }
        catch (DeploymentSynchronizerException e) {
            log.error((Object)("Error while performing the initial sync-up on the repository at: " + this.filePath + ". Auto sync tasks will not be engaged."), (Throwable)e);
        }
    }

    public void stop() {
        if (this.autoCommit || this.autoCheckout) {
            log.info((Object)("Terminating the synchronizer on file system at: " + this.filePath));
            DeploymentSynchronizationManager.getInstance().cancelSynchronizationTask(this.filePath);
            if (this.autoCheckout) {
                this.artifactRepository.cleanupAutoCheckout();
            }
        }
    }

    public synchronized boolean commit() throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started commit from " + this.filePath));
        }
        boolean result = this.artifactRepository.commit(this.tenantId, this.filePath);
        this.lastCommitTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Commit completed at " + new Date(this.lastCommitTime) + ". Status: " + result));
        }
        return result;
    }

    public synchronized boolean commit(String filePath) throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started commit from " + filePath));
        }
        boolean result = this.artifactRepository.commit(this.tenantId, filePath);
        this.lastCommitTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Commit completed at " + new Date(this.lastCommitTime) + ". Status: " + result));
        }
        return result;
    }

    public synchronized boolean checkout() throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started checkout to " + this.filePath));
        }
        boolean result = this.artifactRepository.checkout(this.tenantId, this.filePath);
        this.lastCheckoutTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checkout completed at " + new Date(this.lastCheckoutTime) + ". Status: " + result));
        }
        return result;
    }

    @Deprecated
    public synchronized boolean checkout(String filePath, int depth) throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started checkout to " + filePath + " with depth: " + depth));
        }
        boolean result = this.artifactRepository.checkout(this.tenantId, filePath, depth);
        this.lastCheckoutTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checkout completed at " + new Date(this.lastCheckoutTime) + ". Status: " + result));
        }
        return result;
    }

    @Deprecated
    public synchronized boolean update(String rootPath, String filePath, int depth) throws DeploymentSynchronizerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started to update " + filePath));
        }
        boolean result = this.artifactRepository.update(this.tenantId, rootPath, filePath, depth);
        this.lastCheckoutTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update completed at " + new Date(this.lastCheckoutTime) + ". Status: " + result));
        }
        return result;
    }

    public void requestCheckout(long timestamp) {
        long lastTimestamp = this.lastNotificationTime.get();
        if (this.checkoutRequested.get() || timestamp <= lastTimestamp) {
            return;
        }
        if (this.lastNotificationTime.compareAndSet(lastTimestamp, timestamp)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Checkout operation requested");
            }
            this.checkoutRequested.compareAndSet(false, true);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setAutoCheckout(boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setUseEventing(boolean useEventing) {
        this.useEventing = useEventing;
    }

    public boolean isUseEventing() {
        return this.useEventing;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isAutoCheckout() {
        return this.autoCheckout;
    }

    public long getLastCheckoutTime() {
        return this.lastCheckoutTime;
    }

    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public void doInitialSyncUp() throws DeploymentSynchronizerException {
        log.info((Object)("Started initial artifact synchronization for tenant: " + this.tenantId));
        if (this.autoCommit) {
            if (this.lastCheckoutTime == -1L) {
                log.info((Object)"Checking out artifacts...");
                this.checkout();
            }
            log.info((Object)"Committing artifacts...");
            this.commit();
        }
        if (this.autoCheckout && this.lastCheckoutTime == -1L) {
            log.info((Object)"Checking out artifacts...");
            this.checkout();
        }
        log.info((Object)("Completed initial artifact synchronization for tenant: " + this.tenantId));
    }

    @Deprecated
    public boolean syncGhostMetaArtifacts() throws DeploymentSynchronizerException {
        log.info((Object)"Doing ghost meta artifacts sync up...");
        boolean hasFailed = false;
        if (this.autoCheckout && this.lastCheckoutTime == -1L) {
            log.info((Object)"Checking out...");
            this.checkout(this.filePath, 2);
            this.update(this.filePath, this.filePath + File.separator + "axis2modules", 3);
            this.update(this.filePath, this.filePath + File.separator + "modulemetafiles", 3);
            hasFailed = this.update(this.filePath, this.filePath + File.separator + "ghostmetafiles", 3);
        }
        return hasFailed;
    }

    private boolean checkoutRequested() {
        return !this.useEventing || this.checkoutRequested.getAndSet(false);
    }

    public void sync() {
        try {
            if (this.autoCheckout && this.checkoutRequested()) {
                this.checkout();
            }
            if (this.autoCommit) {
                this.commit();
            }
        }
        catch (DeploymentSynchronizerException e) {
            log.error((Object)("Synchronization error encountered in the repository at: " + this.filePath), (Throwable)e);
        }
        catch (Exception t) {
            log.error((Object)("Unexpected runtime error encountered while synchronizing the repository: " + this.filePath), (Throwable)t);
        }
    }

    private final class AutoSyncTask
    implements Runnable {
        private AutoSyncTask() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing auto sync task for the repository at: " + DeploymentSynchronizer.this.filePath));
            }
        }

        @Override
        public void run() {
            DeploymentSynchronizer.this.sync();
        }
    }
}

