/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.deployment.synchronizer.ArtifactRepository;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class DeploymentSynchronizationManager {
    private static final Log log = LogFactory.getLog(DeploymentSynchronizationManager.class);
    private static final DeploymentSynchronizationManager instance = new DeploymentSynchronizationManager();
    private Map<String, DeploymentSynchronizer> synchronizers = new ConcurrentHashMap<String, DeploymentSynchronizer>();
    private Map<String, ScheduledFuture> scheduledFutures = new ConcurrentHashMap<String, ScheduledFuture>();
    private ScheduledExecutorService repositoryTaskExecutor;

    private DeploymentSynchronizationManager() {
    }

    public static DeploymentSynchronizationManager getInstance() {
        return instance;
    }

    public void init(ServerConfiguration serverConfig) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing deployment synchronization manager");
        }
        int poolSize = 20;
        String value = serverConfig.getFirstProperty("DeploymentSynchronizer.PoolSize");
        if (value != null) {
            poolSize = Integer.parseInt(value);
        }
        this.repositoryTaskExecutor = Executors.newScheduledThreadPool(poolSize, new SimpleThreadFactory());
    }

    public void shutdown() {
        for (DeploymentSynchronizer repository : this.synchronizers.values()) {
            repository.stop();
        }
        this.synchronizers.clear();
        for (ScheduledFuture future : this.scheduledFutures.values()) {
            future.cancel(false);
        }
        ((ScheduledThreadPoolExecutor)this.repositoryTaskExecutor).purge();
        this.scheduledFutures.clear();
        this.repositoryTaskExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentSynchronizer createSynchronizer(int tenantId, ArtifactRepository artifactRepository, String filePath) {
        String string = filePath.intern();
        synchronized (string) {
            DeploymentSynchronizer synchronizer;
            if (this.synchronizers.containsKey(filePath)) {
                log.warn((Object)("A deployment synchronizer is already engaged for the file system at: " + filePath));
                synchronizer = this.synchronizers.remove(filePath);
                if (synchronizer != null) {
                    synchronizer.stop();
                }
            }
            synchronizer = new DeploymentSynchronizer(tenantId, artifactRepository, filePath);
            this.synchronizers.put(filePath, synchronizer);
            return synchronizer;
        }
    }

    public DeploymentSynchronizer getSynchronizer(String filePath) {
        return this.synchronizers.get(filePath);
    }

    public DeploymentSynchronizer getSynchronizer(int tenantId) {
        return this.getSynchronizer(MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
    }

    public Map<String, DeploymentSynchronizer> getSynchronizers() {
        return this.synchronizers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentSynchronizer deleteSynchronizer(String filePath) {
        String string = filePath.intern();
        synchronized (string) {
            return this.synchronizers.remove(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentSynchronizer deleteSynchronizer(int tenantId) {
        String filePath = MultitenantUtils.getAxis2RepositoryPath((int)tenantId);
        String string = filePath.intern();
        synchronized (string) {
            return this.synchronizers.remove(filePath);
        }
    }

    void scheduleSynchronizationTask(String key, Runnable task, long delaySec, long periodSec) {
        ScheduledFuture<?> future = this.repositoryTaskExecutor.scheduleWithFixedDelay(task, delaySec, periodSec, TimeUnit.SECONDS);
        this.scheduledFutures.put(key, future);
    }

    void cancelSynchronizationTask(String key) {
        ScheduledFuture future = this.scheduledFutures.get(key);
        if (future != null) {
            future.cancel(false);
            ((ScheduledThreadPoolExecutor)this.repositoryTaskExecutor).purge();
            this.scheduledFutures.remove(key);
        }
    }

    void initDelayedAutoCheckout() {
        for (DeploymentSynchronizer synchronizer : this.synchronizers.values()) {
            try {
                synchronizer.getArtifactRepository().initAutoCheckout(synchronizer.isUseEventing());
            }
            catch (DeploymentSynchronizerException e) {
                log.error((Object)"Error while calling delayed auto checkout", (Throwable)e);
            }
        }
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(0);

        private SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "deployment-sync-" + this.counter.incrementAndGet());
        }
    }
}

