/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigComponent;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;

public class SecondaryUserStoreConfigurator {
    private static final Log LOG = LogFactory.getLog(SecondaryUserStoreConfigurator.class);
    private static final String SERVER_KEYSTORE_FILE = "Security.KeyStore.Location";
    private static final String SERVER_KEYSTORE_TYPE = "Security.KeyStore.Type";
    private static final String SERVER_KEYSTORE_PASSWORD = "Security.KeyStore.Password";
    private static final String SERVER_KEYSTORE_KEY_ALIAS = "Security.KeyStore.KeyAlias";
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private static final String SERVER_INTERNAL_KEYSTORE_FILE = "Security.InternalKeyStore.Location";
    private static final String SERVER_INTERNAL_KEYSTORE_TYPE = "Security.InternalKeyStore.Type";
    private static final String SERVER_INTERNAL_KEYSTORE_PASSWORD = "Security.InternalKeyStore.Password";
    private static final String SERVER_INTERNAL_KEYSTORE_KEY_ALIAS = "Security.InternalKeyStore.KeyAlias";
    private static final String ENCRYPTION_KEYSTORE = "Security.UserStorePasswordEncryption";
    private static final String INTERNAL_KEYSTORE = "InternalKeystore";
    private static final String CRYPTO_PROVIDER = "CryptoService.InternalCryptoProviderClassName";
    private static final String SYMMETRIC_KEY_CRYPTO_PROVIDER = "org.wso2.carbon.crypto.provider.SymmetricKeyInternalCryptoProvider";
    private Cipher cipher = null;
    private String cipherTransformation = null;
    private Certificate certificate = null;

    private void initializeKeyStore(ServerConfigurationService config) throws IdentityUserStoreMgtException {
        if (this.cipher == null) {
            if (config != null) {
                String filePath = config.getFirstProperty(SERVER_KEYSTORE_FILE);
                String keyStoreType = config.getFirstProperty(SERVER_KEYSTORE_TYPE);
                String password = config.getFirstProperty(SERVER_KEYSTORE_PASSWORD);
                String keyAlias = config.getFirstProperty(SERVER_KEYSTORE_KEY_ALIAS);
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(new File(filePath).getAbsolutePath());
                    KeyStore store = KeyStore.getInstance(keyStoreType);
                    store.load(inputStream, password.toCharArray());
                    Certificate cert = store.getCertificate(keyAlias);
                    if (cert == null) {
                        throw new IdentityUserStoreMgtException("No certificate found for the given alias.");
                    }
                    if (System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY) != null) {
                        this.cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
                        this.certificate = cert;
                        this.cipher = Cipher.getInstance(this.cipherTransformation, "BC");
                    } else {
                        this.cipher = Cipher.getInstance("RSA", "BC");
                    }
                    this.cipher.init(1, cert.getPublicKey());
                }
                catch (FileNotFoundException e) {
                    String errorMsg = "Keystore File Not Found in configured location";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (IOException e) {
                    String errorMsg = "Keystore File IO operation failed";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (InvalidKeyException e) {
                    String errorMsg = "Invalid key is used to access keystore";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (KeyStoreException e) {
                    String errorMsg = "Faulty keystore";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (GeneralSecurityException e) {
                    String errorMsg = "Some parameters assigned to access the keystore is invalid";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Exception occurred while trying to close the keystore file", (Throwable)e);
                        }
                    }
                }
            }
            String errMsg = "ServerConfigurationService is null - this situation can't occur";
            LOG.error((Object)errMsg);
        }
    }

    public String encryptPlainText(String plainText) throws IdentityUserStoreMgtException {
        boolean isInternalKeyStoreEncryptionEnabled = false;
        boolean isSymmetricKeyEncryptionEnabled = false;
        ServerConfigurationService config = UserStoreConfigComponent.getServerConfigurationService();
        if (config != null) {
            String cryptoProvider;
            String encryptionKeyStore = config.getFirstProperty(ENCRYPTION_KEYSTORE);
            if (INTERNAL_KEYSTORE.equalsIgnoreCase(encryptionKeyStore)) {
                isInternalKeyStoreEncryptionEnabled = true;
            }
            if (SYMMETRIC_KEY_CRYPTO_PROVIDER.equalsIgnoreCase(cryptoProvider = config.getFirstProperty(CRYPTO_PROVIDER))) {
                isSymmetricKeyEncryptionEnabled = true;
            }
        }
        if (isInternalKeyStoreEncryptionEnabled && isSymmetricKeyEncryptionEnabled) {
            throw new IdentityUserStoreMgtException(String.format("Userstore encryption can not be supported due to conflicting configurations: '%s' and '%s'. When using internal keystore, assymetric crypto provider should be used.", INTERNAL_KEYSTORE, SYMMETRIC_KEY_CRYPTO_PROVIDER));
        }
        if (isInternalKeyStoreEncryptionEnabled || isSymmetricKeyEncryptionEnabled) {
            try {
                return CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(plainText.getBytes());
            }
            catch (CryptoException e) {
                String errorMessage = "Error while encrypting the plain text using internal keystore.";
                throw new IdentityUserStoreMgtException(errorMessage, e);
            }
        }
        return this.encryptWithPrimaryKeyStore(config, plainText);
    }

    private String encryptWithPrimaryKeyStore(ServerConfigurationService config, String plainText) throws IdentityUserStoreMgtException {
        try {
            if (config != null) {
                this.initializeKeyStore(config);
            }
            byte[] encryptedKey = this.cipher.doFinal(plainText.getBytes());
            if (this.cipherTransformation != null) {
                encryptedKey = CryptoUtil.getDefaultCryptoUtil().createSelfContainedCiphertext(encryptedKey, this.cipherTransformation, this.certificate);
            }
            return Base64.encode((byte[])encryptedKey);
        }
        catch (GeneralSecurityException e) {
            String errMsg = "Failed to generate the cipher text";
            throw new IdentityUserStoreMgtException(errMsg, e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error((Object)"Error while adding the password - too much data for RSA block");
            throw e;
        }
    }
}

