/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.util.IdentityCoreConstants;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.store.configuration.beans.MaskedProperty;
import org.wso2.carbon.identity.user.store.configuration.dao.UserStoreDAO;
import org.wso2.carbon.identity.user.store.configuration.dao.impl.FileBasedUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dto.PropertyDTO;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigComponent;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigListenersHolder;
import org.wso2.carbon.identity.user.store.configuration.listener.UserStoreConfigListener;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurator;
import org.wso2.carbon.identity.user.store.configuration.utils.UserStoreConfigurationConstant;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class SecondaryUserStoreConfigurationUtil {
    private static final Log LOG = LogFactory.getLog(SecondaryUserStoreConfigurationUtil.class);
    private static final String SERVER_KEYSTORE_FILE = "Security.KeyStore.Location";
    private static final String SERVER_KEYSTORE_TYPE = "Security.KeyStore.Type";
    private static final String SERVER_KEYSTORE_PASSWORD = "Security.KeyStore.Password";
    private static final String SERVER_KEYSTORE_KEY_ALIAS = "Security.KeyStore.KeyAlias";
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private static final String SERVER_INTERNAL_KEYSTORE_FILE = "Security.InternalKeyStore.Location";
    private static final String SERVER_INTERNAL_KEYSTORE_TYPE = "Security.InternalKeyStore.Type";
    private static final String SERVER_INTERNAL_KEYSTORE_PASSWORD = "Security.InternalKeyStore.Password";
    private static final String SERVER_INTERNAL_KEYSTORE_KEY_ALIAS = "Security.InternalKeyStore.KeyAlias";
    private static final String ENCRYPTION_KEYSTORE = "Security.UserStorePasswordEncryption";
    private static final String INTERNAL_KEYSTORE = "InternalKeystore";
    private static Cipher cipher = null;
    private static String cipherTransformation = null;
    private static Certificate certificate = null;

    private SecondaryUserStoreConfigurationUtil() {
    }

    private static void initializeKeyStore() throws IdentityUserStoreMgtException {
        if (cipher == null) {
            ServerConfigurationService config = UserStoreConfigComponent.getServerConfigurationService();
            if (config != null) {
                String encryptionKeyStore = config.getFirstProperty(ENCRYPTION_KEYSTORE);
                String filePath = config.getFirstProperty(SERVER_KEYSTORE_FILE);
                String keyStoreType = config.getFirstProperty(SERVER_KEYSTORE_TYPE);
                String password = config.getFirstProperty(SERVER_KEYSTORE_PASSWORD);
                String keyAlias = config.getFirstProperty(SERVER_KEYSTORE_KEY_ALIAS);
                if (INTERNAL_KEYSTORE.equalsIgnoreCase(encryptionKeyStore)) {
                    filePath = config.getFirstProperty(SERVER_INTERNAL_KEYSTORE_FILE);
                    keyStoreType = config.getFirstProperty(SERVER_INTERNAL_KEYSTORE_TYPE);
                    password = config.getFirstProperty(SERVER_INTERNAL_KEYSTORE_PASSWORD);
                    keyAlias = config.getFirstProperty(SERVER_INTERNAL_KEYSTORE_KEY_ALIAS);
                }
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(new File(filePath).getAbsolutePath());
                    KeyStore store = KeyStore.getInstance(keyStoreType);
                    store.load(inputStream, password.toCharArray());
                    Certificate[] certs = store.getCertificateChain(keyAlias);
                    if (System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY) != null) {
                        cipherTransformation = System.getProperty(CIPHER_TRANSFORMATION_SYSTEM_PROPERTY);
                        certificate = certs[0];
                        cipher = Cipher.getInstance(cipherTransformation, "BC");
                    } else {
                        cipher = Cipher.getInstance("RSA", "BC");
                    }
                    cipher.init(1, certs[0].getPublicKey());
                }
                catch (FileNotFoundException e) {
                    String errorMsg = "Keystore File Not Found in configured location";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (IOException e) {
                    String errorMsg = "Keystore File IO operation failed";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (InvalidKeyException e) {
                    String errorMsg = "Invalid key is used to access keystore";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (KeyStoreException e) {
                    String errorMsg = "Faulty keystore";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                catch (GeneralSecurityException e) {
                    String errorMsg = "Some parameters assigned to access the keystore is invalid";
                    throw new IdentityUserStoreMgtException(errorMsg, e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Exception occurred while trying to close the keystore file", (Throwable)e);
                        }
                    }
                }
            }
            String errMsg = "ServerConfigurationService is null - this situation can't occur";
            LOG.error((Object)errMsg);
        }
    }

    public static String encryptPlainText(String plainText) throws IdentityUserStoreMgtException {
        SecondaryUserStoreConfigurator configurator = new SecondaryUserStoreConfigurator();
        return configurator.encryptPlainText(plainText);
    }

    public static Path getUserStoreConfigurationFile(String domainName) throws IdentityUserStoreMgtException {
        Path userStore;
        String fileName = domainName.replace(".", "_");
        if (!IdentityUtil.isValidFileName((String)fileName)) {
            String message = "Provided domain name : '" + domainName + "' is invalid.";
            throw new IdentityUserStoreMgtException(message);
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId == -1234) {
            userStore = Paths.get(UserStoreConfigurationConstant.DEPLOYMENT_DIRECTORY, new String[0]);
        } else {
            String tenantFilePath = CarbonUtils.getCarbonTenantsDirPath();
            userStore = Paths.get(tenantFilePath, String.valueOf(tenantId), "userstores");
        }
        return SecondaryUserStoreConfigurationUtil.getUserStoreConfigFile(userStore, fileName);
    }

    private static Path getUserStoreConfigFile(Path userStore, String fileName) {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (!Files.exists(userStore, new LinkOption[0])) {
            try {
                Files.createDirectory(userStore, new FileAttribute[0]);
                LOG.info((Object)("folder 'userstores' created to store configurations for tenant = " + tenantId));
            }
            catch (IOException e) {
                LOG.error((Object)("Error while creating 'userstores' directory to store configurations for tenant = " + tenantId));
            }
        }
        return Paths.get(userStore.toString(), fileName + ".xml");
    }

    @Deprecated
    public static void writeUserMgtXMLFile(Path userStoreConfigFile, UserStoreDTO userStoreDTO, boolean editSecondaryUserStore, boolean isStateChange) throws IdentityUserStoreMgtException {
        SecondaryUserStoreConfigurationUtil.writeUserMgtXMLFile(userStoreConfigFile, userStoreDTO, editSecondaryUserStore, isStateChange, userStoreDTO.getDomainId());
    }

    public static void writeUserMgtXMLFile(Path userStoreConfigFile, UserStoreDTO userStoreDTO, boolean editSecondaryUserStore, boolean isStateChange, String existingDomainName) throws IdentityUserStoreMgtException {
        boolean isDisable = false;
        if (userStoreDTO.getDisabled() != null) {
            isDisable = userStoreDTO.getDisabled();
        }
        String domain = userStoreDTO.getDomainId();
        DocumentBuilderFactory documentFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            if (isStateChange) {
                SecondaryUserStoreConfigurationUtil.updateStateOfUserStore(userStoreConfigFile, isDisable, domain, documentBuilder);
            } else {
                SecondaryUserStoreConfigurationUtil.updateUserStoreProperties(userStoreConfigFile, userStoreDTO, editSecondaryUserStore, documentBuilder, existingDomainName);
            }
        }
        catch (ParserConfigurationException e) {
            String errMsg = " Error occurred due to serious parser configuration exception of " + userStoreConfigFile;
            throw new IdentityUserStoreMgtException(errMsg, e);
        }
        catch (TransformerException e) {
            String errMsg = " Error occurred during the transformation process of " + userStoreConfigFile;
            throw new IdentityUserStoreMgtException(errMsg, e);
        }
        catch (IOException e) {
            String errMsg = " Error occurred while creating or closing the output stream from " + userStoreConfigFile;
            throw new IdentityUserStoreMgtException(errMsg, e);
        }
        catch (SAXException e) {
            throw new IdentityUserStoreMgtException("Error while updating user store state", e);
        }
    }

    @Deprecated
    public static String getUserStoreProperties(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        return SecondaryUserStoreConfigurationUtil.getUserStoreProperties(userStoreDTO, userStoreDTO.getDomainId());
    }

    public static String getUserStoreProperties(UserStoreDTO userStoreDTO, String existingDomainName) throws IdentityUserStoreMgtException {
        String userStoreProperties;
        DocumentBuilderFactory documentFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document doc = SecondaryUserStoreConfigurationUtil.getDocument(userStoreDTO, false, documentBuilder, existingDomainName);
            StringWriter writer = new StringWriter();
            SecondaryUserStoreConfigurationUtil.transformProperties().transform(new DOMSource(doc), new StreamResult(writer));
            userStoreProperties = writer.getBuffer().toString().replaceAll("\n|\r", "");
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IdentityUserStoreMgtException("Error occured while parsing the user store file.", e);
        }
        catch (IdentityUserStoreMgtException e) {
            throw new IdentityUserStoreMgtException("Error occured while getting the user store properties.", e);
        }
        return userStoreProperties;
    }

    public static Map<String, String> getSecondaryUserStorePropertiesFromTenantUserRealm(String userStoreDomain) throws IdentityUserStoreMgtException {
        Map secondaryUserStoreProperties = null;
        try {
            for (RealmConfiguration realmConfiguration = UserStoreConfigComponent.getRealmService().getTenantUserRealm(SecondaryUserStoreConfigurationUtil.getTenantIdInTheCurrentContext()).getRealmConfiguration(); realmConfiguration != null; realmConfiguration = realmConfiguration.getSecondaryRealmConfig()) {
                String domainName = realmConfiguration.getUserStoreProperty("DomainName");
                if (!StringUtils.equalsIgnoreCase((String)domainName, (String)userStoreDomain)) continue;
                secondaryUserStoreProperties = realmConfiguration.getUserStoreProperties();
                break;
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Error while retrieving user store configurations for user store domain: " + userStoreDomain;
            throw new IdentityUserStoreMgtException(errorMessage, e);
        }
        return secondaryUserStoreProperties;
    }

    private static Transformer transformProperties() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "6");
        return transformer;
    }

    private static void updateUserStoreProperties(Path userStoreConfigFile, UserStoreDTO userStoreDTO, boolean editSecondaryUserStore, DocumentBuilder documentBuilder, String existingDomainName) throws IdentityUserStoreMgtException, IOException, TransformerException {
        Document doc = SecondaryUserStoreConfigurationUtil.getDocument(userStoreDTO, editSecondaryUserStore, documentBuilder, existingDomainName);
        StreamResult result = new StreamResult(Files.newOutputStream(userStoreConfigFile, new OpenOption[0]));
        DOMSource source = new DOMSource(doc);
        SecondaryUserStoreConfigurationUtil.transformProperties().transform(source, result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Closing the output stream from " + userStoreConfigFile));
        }
        result.getOutputStream().close();
    }

    private static Document getDocument(UserStoreDTO userStoreDTO, boolean editSecondaryUserStore, DocumentBuilder documentBuilder, String existingDomainName) throws IdentityUserStoreMgtException {
        Document doc = documentBuilder.newDocument();
        Element userStoreElement = doc.createElement("UserStoreManager");
        doc.appendChild(userStoreElement);
        Attr attrClass = doc.createAttribute("class");
        if (userStoreDTO != null) {
            attrClass.setValue(userStoreDTO.getClassName());
            userStoreElement.setAttributeNode(attrClass);
            if (userStoreDTO.getClassName() != null) {
                SecondaryUserStoreConfigurationUtil.addProperties(existingDomainName, userStoreDTO.getClassName(), userStoreDTO.getProperties(), doc, userStoreElement, editSecondaryUserStore);
            }
            SecondaryUserStoreConfigurationUtil.addProperty("DomainName", userStoreDTO.getDomainId(), doc, userStoreElement, false);
            SecondaryUserStoreConfigurationUtil.addProperty("Description", userStoreDTO.getDescription(), doc, userStoreElement, false);
        }
        return doc;
    }

    private static void updateStateOfUserStore(Path userStoreConfigFile, boolean isDisable, String domain, DocumentBuilder documentBuilder) throws SAXException, IOException, TransformerException {
        Document doc = documentBuilder.parse(Files.newInputStream(userStoreConfigFile, new OpenOption[0]));
        NodeList elements = doc.getElementsByTagName("Property");
        for (int i = 0; i < elements.getLength(); ++i) {
            if ("Disabled".compareToIgnoreCase(elements.item(i).getAttributes().item(0).getNodeValue()) != 0) continue;
            elements.item(i).setTextContent(String.valueOf(isDisable));
            break;
        }
        StreamResult result = new StreamResult(Files.newOutputStream(userStoreConfigFile, new OpenOption[0]));
        DOMSource source = new DOMSource(doc);
        SecondaryUserStoreConfigurationUtil.transformProperties().transform(source, result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Closing the output stream from " + userStoreConfigFile));
        }
        result.getOutputStream().close();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("New state :" + isDisable + " of the user store '" + domain + "' successfully written to the file system"));
        }
    }

    private static Property[] getMandatoryProperties(String userStoreClass) {
        return UserStoreManagerRegistry.getUserStoreProperties((String)userStoreClass).getMandatoryProperties();
    }

    private static boolean isPropertyToBeEncrypted(Property[] mandatoryProperties, String propertyName) {
        for (Property property : mandatoryProperties) {
            if (!propertyName.equalsIgnoreCase(property.getName())) continue;
            return property.getDescription().contains("#encrypt");
        }
        return false;
    }

    private static String getUniqueIDFromUserDTO(PropertyDTO[] propertyDTOs) {
        int length = propertyDTOs.length;
        for (int i = length - 1; i >= 0; --i) {
            PropertyDTO propertyDTO = propertyDTOs[i];
            if (propertyDTO == null || propertyDTO.getName() == null || !propertyDTO.getName().equalsIgnoreCase("UniqueID")) continue;
            return propertyDTO.getValue();
        }
        return null;
    }

    private static void addProperty(String name, String value, Document doc, Element parent, boolean encrypted) {
        Attr attr;
        Element property = doc.createElement("Property");
        if (encrypted) {
            attr = doc.createAttribute("encrypted");
            attr.setValue("true");
            property.setAttributeNode(attr);
        }
        attr = doc.createAttribute("name");
        attr.setValue(name);
        property.setAttributeNode(attr);
        property.setTextContent(value);
        parent.appendChild(property);
    }

    private static void addProperties(String userStoreDomain, String userStoreClass, PropertyDTO[] propertyDTOs, Document doc, Element parent, boolean editSecondaryUserStore) throws IdentityUserStoreMgtException {
        String uniqueID;
        if (editSecondaryUserStore && (uniqueID = SecondaryUserStoreConfigurationUtil.getUniqueIDFromUserDTO(propertyDTOs)) == null) {
            throw new IdentityUserStoreMgtException("UniqueID property is not provided.");
        }
        Property[] mandatoryProperties = SecondaryUserStoreConfigurationUtil.getMandatoryProperties(userStoreClass);
        Map<String, String> secondaryUserStoreProperties = SecondaryUserStoreConfigurationUtil.getSecondaryUserStorePropertiesFromTenantUserRealm(userStoreDomain);
        for (PropertyDTO propertyDTO : propertyDTOs) {
            String propertyDTOValue;
            String propertyDTOName = propertyDTO.getName();
            if ("UniqueID".equalsIgnoreCase(propertyDTOName) || (propertyDTOValue = propertyDTO.getValue()) == null) continue;
            boolean encrypted = false;
            if (SecondaryUserStoreConfigurationUtil.isPropertyToBeEncrypted(mandatoryProperties, propertyDTOName)) {
                propertyDTOValue = SecondaryUserStoreConfigurationUtil.getPropertyValueIfMasked(secondaryUserStoreProperties, propertyDTOName, propertyDTOValue);
                try {
                    propertyDTOValue = SecondaryUserStoreConfigurationUtil.encryptPlainText(propertyDTOValue);
                    encrypted = true;
                }
                catch (IdentityUserStoreMgtException e) {
                    LOG.error((Object)"addProperties failed to encrypt", (Throwable)e);
                }
            }
            SecondaryUserStoreConfigurationUtil.addProperty(propertyDTOName, propertyDTOValue, doc, parent, encrypted);
        }
    }

    private static String getPropertyValueIfMasked(Map<String, String> secondaryUserStoreProperties, String propertyDTOName, String propertyDTOValue) {
        if ("ENCRYPTED PROPERTY".equalsIgnoreCase(propertyDTOValue)) {
            propertyDTOValue = SecondaryUserStoreConfigurationUtil.getExistingPropertyValue(secondaryUserStoreProperties, propertyDTOName);
        }
        return propertyDTOValue;
    }

    private static String getExistingPropertyValue(Map<String, String> secondaryUserStoreProperties, String propertyDTOName) {
        String existingPropertyValue = null;
        if (secondaryUserStoreProperties != null) {
            existingPropertyValue = secondaryUserStoreProperties.get(propertyDTOName);
        }
        return existingPropertyValue;
    }

    private static UserStoreManager getSecondaryUserStoreManager(String userStoreDomain) throws UserStoreException {
        UserStoreManager secondaryUserStoreManager = null;
        UserRealm userRealm = (UserRealm)UserStoreConfigComponent.getRealmService().getTenantUserRealm(SecondaryUserStoreConfigurationUtil.getTenantIdInTheCurrentContext());
        UserStoreManager userStoreManager = userRealm.getUserStoreManager();
        if (userStoreManager != null) {
            secondaryUserStoreManager = userStoreManager.getSecondaryUserStoreManager(userStoreDomain);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Could not locate user store manager for user store domain: " + userStoreDomain));
        }
        return secondaryUserStoreManager;
    }

    private static int getTenantIdInTheCurrentContext() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public static void validateForFederatedDomain(String domain) throws UserStoreException {
        if (IdentityUtil.isNotBlank((String)domain) && domain.toUpperCase().startsWith("FEDERATED")) {
            throw new UserStoreException("'FEDERATED' is a reserved user domain prefix. Please start the domain name in a different manner.");
        }
    }

    public static UserStoreDAO getFileBasedUserStoreDAOFactory() throws UserStoreException {
        UserStoreDAO userStoreDAO = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().get(FileBasedUserStoreDAOFactory.class.getName()).getInstance();
        if (userStoreDAO == null) {
            throw new UserStoreException("Error occured while creating an instance of FileBasedUserStoreDAOFactory.");
        }
        return userStoreDAO;
    }

    public static MaskedProperty[] setMaskInUserStoreProperties(RealmConfiguration secondaryRealmConfiguration, Map<String, String> userStoreProperties, String encryptPropertyMaskValue, String className) {
        MaskedProperty[] maskedProperties;
        for (MaskedProperty maskedProperty : maskedProperties = SecondaryUserStoreConfigurationUtil.getMaskedProperties(className, encryptPropertyMaskValue, secondaryRealmConfiguration)) {
            userStoreProperties.put(maskedProperty.getName(), maskedProperty.getMask());
        }
        return maskedProperties;
    }

    private static MaskedProperty[] getMaskedProperties(String userStoreClass, String maskValue, RealmConfiguration secondaryRealmConfiguration) {
        Property[] mandatoryProperties = SecondaryUserStoreConfigurationUtil.getMandatoryProperties(userStoreClass);
        ArrayList<MaskedProperty> maskedProperties = new ArrayList<MaskedProperty>();
        for (Property property : mandatoryProperties) {
            String propertyName = property.getName();
            if (!property.getDescription().contains("#encrypt")) continue;
            MaskedProperty maskedProperty = new MaskedProperty();
            maskedProperty.setName(propertyName);
            maskedProperty.setValue(secondaryRealmConfiguration.getUserStoreProperty(propertyName));
            maskedProperty.setMask(maskValue);
            maskedProperties.add(maskedProperty);
        }
        return maskedProperties.toArray(new MaskedProperty[0]);
    }

    public static PropertyDTO[] convertMapToArray(Map<String, String> properties) {
        Set<Map.Entry<String, String>> propertyEntries = properties.entrySet();
        ArrayList<PropertyDTO> propertiesList = new ArrayList<PropertyDTO>();
        for (Map.Entry<String, String> entry : propertyEntries) {
            String key = entry.getKey();
            String value = entry.getValue();
            PropertyDTO propertyDTO = new PropertyDTO(key, value);
            propertiesList.add(propertyDTO);
        }
        return propertiesList.toArray(new PropertyDTO[propertiesList.size()]);
    }

    public static void triggerListnersOnUserStorePreUpdate(String previousDomainName, String domainName) throws UserStoreException {
        List<UserStoreConfigListener> userStoreConfigListeners = UserStoreConfigListenersHolder.getInstance().getUserStoreConfigListeners();
        for (UserStoreConfigListener userStoreConfigListener : userStoreConfigListeners) {
            userStoreConfigListener.onUserStoreNamePreUpdate(CarbonContext.getThreadLocalCarbonContext().getTenantId(), previousDomainName, domainName);
        }
    }

    public static void triggerListnersOnUserStorePreDelete(String domainName) throws UserStoreException {
        List<UserStoreConfigListener> userStoreConfigListeners = UserStoreConfigListenersHolder.getInstance().getUserStoreConfigListeners();
        for (UserStoreConfigListener userStoreConfigListener : userStoreConfigListeners) {
            userStoreConfigListener.onUserStorePreDelete(CarbonContext.getThreadLocalCarbonContext().getTenantId(), domainName);
        }
    }

    public static void triggerListenersOnUserStorePreStateChange(String domainName, boolean isDisable) throws UserStoreException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<UserStoreConfigListener> userStoreConfigListeners = UserStoreConfigListenersHolder.getInstance().getUserStoreConfigListeners();
        for (UserStoreConfigListener userStoreConfigListener : userStoreConfigListeners) {
            userStoreConfigListener.onUserStorePreStateChange(isDisable ? IdentityCoreConstants.UserStoreState.DISABLED : IdentityCoreConstants.UserStoreState.ENABLED, tenantId, domainName);
        }
    }

    public static void triggerListenersOnUserStorePreAdd(String domainName) throws UserStoreException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<UserStoreConfigListener> userStoreConfigListeners = UserStoreConfigListenersHolder.getInstance().getUserStoreConfigListeners();
        for (UserStoreConfigListener userStoreConfigListener : userStoreConfigListeners) {
            userStoreConfigListener.onUserStorePreAdd(tenantId, domainName);
        }
    }

    public static boolean isUserStoreRepositorySeparationEnabled() {
        return false;
    }
}

