/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.internal;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.user.store.configuration.UserStoreConfigService;
import org.wso2.carbon.identity.user.store.configuration.UserStoreConfigServiceImpl;
import org.wso2.carbon.identity.user.store.configuration.dao.AbstractUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dao.impl.DatabaseBasedUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dao.impl.FileBasedUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigListenersHolder;
import org.wso2.carbon.identity.user.store.configuration.listener.UserStoreConfigListener;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.identity.user.store.configuration.component", immediate=true)
public class UserStoreConfigComponent {
    private static final Log log = LogFactory.getLog(UserStoreConfigComponent.class);
    private static RealmService realmService = null;
    private static RealmConfiguration realmConfiguration = null;
    private static ServerConfigurationService serverConfigurationService = null;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        UserStoreConfigComponent.realmService = realmService;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Set the Realm Service");
        }
    }

    public static RealmConfiguration getRealmConfiguration() {
        realmConfiguration = UserStoreConfigComponent.getRealmService().getBootstrapRealmConfiguration();
        return realmConfiguration;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    @Reference(name="server.configuration.service", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Set the ServerConfiguration Service");
        }
        UserStoreConfigComponent.serverConfigurationService = serverConfigurationService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity User Store bundle is activated.");
        }
        try {
            BundleContext bundleContext = ctxt.getBundleContext();
            FileBasedUserStoreDAOFactory fileBasedUserStoreDAOFactory = new FileBasedUserStoreDAOFactory();
            DatabaseBasedUserStoreDAOFactory databaseBasedUserStoreDAOFactory = new DatabaseBasedUserStoreDAOFactory();
            ServiceRegistration serviceRegistration = bundleContext.registerService(AbstractUserStoreDAOFactory.class.getName(), (Object)fileBasedUserStoreDAOFactory, null);
            bundleContext.registerService(AbstractUserStoreDAOFactory.class.getName(), (Object)databaseBasedUserStoreDAOFactory, null);
            UserStoreConfigServiceImpl userStoreConfigService = new UserStoreConfigServiceImpl();
            ctxt.getBundleContext().registerService(UserStoreConfigService.class.getName(), (Object)userStoreConfigService, null);
            UserStoreConfigListenersHolder.getInstance().setUserStoreConfigService(userStoreConfigService);
            if (serviceRegistration != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"FileBasedUserStoreDAOFactory is successfully registered.");
                }
            } else {
                log.error((Object)"FileBasedUserStoreDAOFactory could not be registered.");
            }
            this.readAllowedUserstoreConfiguration();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to load user store org.wso2.carbon.identity.user.store.configuration details.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity User Store-Config bundle is activated.");
        }
    }

    @Reference(name="user.store.configuration", service=AbstractUserStoreDAOFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserStoreDAOFactory")
    protected void setUserStoreDAOFactory(AbstractUserStoreDAOFactory userStoreDAOFactory) {
        UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().put(userStoreDAOFactory.getRepository(), userStoreDAOFactory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added UserStoreDAOFactory : " + userStoreDAOFactory.getRepository()));
        }
    }

    protected void unsetUserStoreDAOFactory(AbstractUserStoreDAOFactory userStoreDAOFactory) {
        UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().remove(userStoreDAOFactory.getRepository());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed UserStoreDAOFactory : " + userStoreDAOFactory.getRepository()));
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity User Store-Config bundle is deactivated");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        UserStoreConfigComponent.realmService = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unset the Realm Service");
        }
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unset the ServerConfiguration Service");
        }
        UserStoreConfigComponent.serverConfigurationService = null;
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="user.store.config.event.listener.service", service=UserStoreConfigListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserStoreConfigListenerService")
    protected void setUserStoreConfigListenerService(UserStoreConfigListener userStoreConfigListener) {
        UserStoreConfigListenersHolder.getInstance().setUserStoreConfigListenerService(userStoreConfigListener);
    }

    protected void unsetUserStoreConfigListenerService(UserStoreConfigListener userStoreConfigListener) {
        UserStoreConfigListenersHolder.getInstance().unsetUserStoreConfigListenerService(userStoreConfigListener);
    }

    private void readAllowedUserstoreConfiguration() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement userstoresConfig = configParser.getConfigElement("AllowedUserstores");
        if (userstoresConfig == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"'AllowedUserstores' config not found.");
            }
            return;
        }
        HashSet<String> allowedUserstores = new HashSet<String>();
        Iterator userstoreItr = userstoresConfig.getChildrenWithLocalName("AllowedUserstore");
        int allowedUserstoreCount = 0;
        if (userstoreItr != null) {
            while (userstoreItr.hasNext()) {
                OMElement userstoreConfig = (OMElement)userstoreItr.next();
                String allowedUserstore = userstoreConfig.getText();
                if (!StringUtils.isNotBlank((String)allowedUserstore)) continue;
                allowedUserstores.add(allowedUserstore);
                ++allowedUserstoreCount;
            }
        }
        if (allowedUserstoreCount == 0 && log.isDebugEnabled()) {
            log.debug((Object)"No userstores have been configured under the 'AllowedUserstore' config.");
        }
        UserStoreConfigListenersHolder.getInstance().setAllowedUserstores(allowedUserstores);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        UserStoreConfigListenersHolder.getInstance().setConfigurationContextService(configurationContextService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService Instance was set.");
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        UserStoreConfigListenersHolder.getInstance().setConfigurationContextService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService Instance was unset.");
        }
    }
}

