/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.dao.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.store.configuration.beans.MaskedProperty;
import org.wso2.carbon.identity.user.store.configuration.dao.AbstractUserStoreDAO;
import org.wso2.carbon.identity.user.store.configuration.dao.impl.FileBasedUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStorePersistanceDTO;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreClientException;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurationUtil;
import org.wso2.carbon.identity.user.store.configuration.utils.UserStoreConfigurationConstant;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.config.XMLProcessorUtils;
import org.wso2.carbon.user.core.tenant.TenantCache;
import org.wso2.carbon.user.core.tenant.TenantIdKey;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class FileBasedUserStoreDAOImpl
extends AbstractUserStoreDAO {
    private static final Log log = LogFactory.getLog(FileBasedUserStoreDAOImpl.class);
    private static final String DISABLED = "Disabled";
    private static final String FILE_BASED = FileBasedUserStoreDAOFactory.class.getName();
    private XMLProcessorUtils xmlProcessorUtils = new XMLProcessorUtils();

    private void updatePersistedDomainName(String previousDomainName, String domainName, int tenantId) throws UserStoreException {
        AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
        userStoreManager.updatePersistedDomain(previousDomainName, domainName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Renamed persisted domain name from" + previousDomainName + " to " + domainName + " of tenant:" + tenantId + " from UM_DOMAIN."));
        }
    }

    private void createUserStoreDirectory(String tenantFilePath, String fileName, boolean isTenant) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Path userStore = Paths.get(UserStoreConfigurationConstant.DEPLOYMENT_DIRECTORY, new String[0]);
        if (isTenant) {
            userStore = Paths.get(tenantFilePath, String.valueOf(tenantId), "userstores");
        }
        if (!Files.exists(userStore, new LinkOption[0])) {
            try {
                Files.createDirectory(userStore, new FileAttribute[0]);
                if (isTenant) {
                    log.info((Object)("folder 'userstores' created for tenant: " + tenantId + "for the file: " + fileName));
                } else {
                    log.info((Object)("folder 'userstores' created for super tenant for the file: " + fileName));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error at creating 'userstores' directory to store configurations for super tenant");
                throw new IdentityUserStoreMgtException("Error while updating the userStore.");
            }
        }
    }

    private void validateFileName(String domainName, String fileName) throws IdentityUserStoreMgtException {
        if (!IdentityUtil.isValidFileName((String)fileName)) {
            String message = "Provided domain name: '" + domainName + "' is invalid.";
            log.error((Object)message);
            throw new IdentityUserStoreClientException(message);
        }
    }

    private Path getUserStoreConfigurationFile(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        String domainName = userStoreDTO.getDomainId();
        return SecondaryUserStoreConfigurationUtil.getUserStoreConfigurationFile(domainName);
    }

    private void writeToUserStoreConfigurationFile(Path userStoreConfigFile, UserStoreDTO userStoreDTO, boolean editSecondaryUserStore, boolean isStateChange, String existingDomainName) throws IdentityUserStoreMgtException {
        try {
            SecondaryUserStoreConfigurationUtil.writeUserMgtXMLFile(userStoreConfigFile, userStoreDTO, editSecondaryUserStore, isStateChange, existingDomainName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("New user store successfully written to the file" + userStoreConfigFile.toAbsolutePath()));
            }
        }
        catch (IdentityUserStoreMgtException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
    }

    private IdentityUserStoreMgtException buildException(String domainName, boolean editSecondaryUserStore) {
        String msg = "Cannot add user store " + domainName + ". User store already exists.";
        String errorCode = UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_XML_FILE_ALREADY_EXISTS.getCode();
        if (editSecondaryUserStore) {
            msg = "Cannot edit user store " + domainName + ". User store cannot be edited.";
            errorCode = UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_XML_FILE_NOT_FOUND.getCode();
        }
        return new IdentityUserStoreClientException(errorCode, msg);
    }

    @Override
    public void deleteUserStore(String domain) throws IdentityUserStoreMgtException {
        if (this.isDomainNameExists(domain)) {
            this.deleteUserStores(new String[]{domain});
        }
    }

    @Override
    public void deleteUserStores(String[] domains) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Path path = tenantId == -1234 ? Paths.get(UserStoreConfigurationConstant.DEPLOYMENT_DIRECTORY, new String[0]) : Paths.get(CarbonUtils.getCarbonTenantsDirPath(), String.valueOf(tenantId), "userstores");
        File file = path.toFile();
        for (String domainName : domains) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting, .... " + domainName + " domain."));
            }
            try {
                SecondaryUserStoreConfigurationUtil.triggerListnersOnUserStorePreDelete(domainName);
                this.deletePersitedDomain(tenantId, domainName);
            }
            catch (UserStoreException e) {
                String errorMessage = "Error while deleting user store : " + domainName;
                log.error((Object)errorMessage, (Throwable)e);
                throw new IdentityUserStoreMgtException(errorMessage);
            }
            this.deleteFile(file, domainName.replace(".", "_").concat(".xml"));
        }
    }

    private void deletePersitedDomain(int tenantId, String domainName) throws UserStoreException {
        AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
        userStoreManager.deletePersistedDomain(domainName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed persisted domain name: " + domainName + " of tenant:" + tenantId + " from UM_DOMAIN."));
        }
        UserCoreUtil.getRealmService().clearCachedUserRealm(tenantId);
        TenantCache.getInstance().clearCacheEntry(new TenantIdKey(tenantId));
    }

    private void deleteFile(File file, final String userStoreName) throws IdentityUserStoreMgtException {
        this.validateFileName(userStoreName, userStoreName);
        Object[] deleteCandidates = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(userStoreName);
            }
        });
        if (ArrayUtils.isNotEmpty((Object[])deleteCandidates)) {
            for (Object file1 : deleteCandidates) {
                if (((File)file1).delete()) {
                    log.info((Object)("File " + file.getName() + " deleted successfully"));
                    continue;
                }
                log.error((Object)("error at deleting file:" + file.getName()));
            }
        }
    }

    @Override
    public UserStoreDTO[] getUserStores() throws IdentityUserStoreMgtException {
        RealmConfiguration secondaryRealmConfiguration;
        ArrayList<UserStoreDTO> domains = new ArrayList<UserStoreDTO>();
        try {
            secondaryRealmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getSecondaryRealmConfig();
        }
        catch (UserStoreException e) {
            String errorMessage = "Error while retrieving user store configurations";
            throw new IdentityUserStoreMgtException(errorMessage);
        }
        if (secondaryRealmConfiguration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SecondaryRealmConfiguration is null. Can not find any userStore.");
            }
            return new UserStoreDTO[0];
        }
        do {
            Map userStoreProperties;
            String uuid;
            if ((uuid = (String)(userStoreProperties = secondaryRealmConfiguration.getUserStoreProperties()).get("UniqueID")) == null) {
                uuid = UUID.randomUUID().toString();
            }
            String className = secondaryRealmConfiguration.getUserStoreClass();
            UserStoreDTO userStoreDTO = this.getUserStoreDTO(secondaryRealmConfiguration, userStoreProperties);
            userStoreProperties.put("Class", className);
            userStoreProperties.put("UniqueID", uuid);
            MaskedProperty[] maskedProperties = SecondaryUserStoreConfigurationUtil.setMaskInUserStoreProperties(secondaryRealmConfiguration, userStoreProperties, "ENCRYPTED PROPERTY", className);
            userStoreDTO.setProperties(SecondaryUserStoreConfigurationUtil.convertMapToArray(userStoreProperties));
            for (MaskedProperty maskedProperty : maskedProperties) {
                userStoreProperties.put(maskedProperty.getName(), maskedProperty.getValue());
            }
            domains.add(userStoreDTO);
        } while ((secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) != null);
        return domains.toArray(new UserStoreDTO[domains.size()]);
    }

    @Override
    protected void doAddUserStore(UserStorePersistanceDTO userStorePersistanceDTO) throws IdentityUserStoreMgtException {
        String domainName = userStorePersistanceDTO.getUserStoreDTO().getDomainId();
        try {
            SecondaryUserStoreConfigurationUtil.triggerListenersOnUserStorePreAdd(domainName);
            boolean validDomain = this.isValidDomainToAdd(domainName);
            SecondaryUserStoreConfigurationUtil.validateForFederatedDomain(domainName);
            if (validDomain) {
                Path userStoreConfigFile = this.getUserStoreConfigurationFile(userStorePersistanceDTO.getUserStoreDTO());
                if (Files.exists(userStoreConfigFile, new LinkOption[0])) {
                    throw this.buildException(userStorePersistanceDTO.getUserStoreDTO().getDomainId(), false);
                }
                this.writeToUserStoreConfigurationFile(userStoreConfigFile, userStorePersistanceDTO.getUserStoreDTO(), false, false, domainName);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The user store domain: " + domainName + "is not a valid domain name."));
            }
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreClientException("Error occurred while adding the user store with the domain: " + domainName, e);
        }
    }

    @Override
    protected void doUpdateUserStore(UserStorePersistanceDTO userStorePersistanceDTO, boolean isStateChange) throws IdentityUserStoreMgtException {
        Path userStoreConfigFile;
        boolean isValidDomain;
        String domainName = userStorePersistanceDTO.getUserStoreDTO().getDomainId();
        try {
            SecondaryUserStoreConfigurationUtil.validateForFederatedDomain(domainName);
            isValidDomain = this.isDomainNameExists(domainName);
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreClientException("Error while updating the user store.", e);
        }
        if (isValidDomain) {
            userStoreConfigFile = this.getUserStoreConfigurationFile(userStorePersistanceDTO.getUserStoreDTO());
            if (!Files.exists(userStoreConfigFile, new LinkOption[0])) {
                throw this.buildException(userStorePersistanceDTO.getUserStoreDTO().getDomainId(), true);
            }
        } else {
            String errorMessage = "Trying to edit an invalid domain : " + domainName;
            throw new IdentityUserStoreClientException(errorMessage);
        }
        this.writeToUserStoreConfigurationFile(userStoreConfigFile, userStorePersistanceDTO.getUserStoreDTO(), true, isStateChange, domainName);
    }

    @Override
    protected void doUpdateUserStoreDomainName(String previousDomainName, UserStorePersistanceDTO userStorePersistanceDTO) throws IdentityUserStoreMgtException {
        String errorMessage;
        Path previousUserStoreConfigFile;
        Path userStoreConfigFile;
        String domainName = userStorePersistanceDTO.getUserStoreDTO().getDomainId();
        String fileName = domainName.replace(".", "_");
        String previousFileName = previousDomainName.replace(".", "_");
        this.validateFileName(domainName, fileName);
        this.validateFileName(previousDomainName, previousFileName);
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId == -1234) {
            this.createUserStoreDirectory(null, fileName, false);
            userStoreConfigFile = Paths.get(UserStoreConfigurationConstant.DEPLOYMENT_DIRECTORY, fileName + ".xml");
            previousUserStoreConfigFile = Paths.get(UserStoreConfigurationConstant.DEPLOYMENT_DIRECTORY, previousFileName + ".xml");
        } else {
            String tenantFilePath = CarbonUtils.getCarbonTenantsDirPath();
            this.createUserStoreDirectory(tenantFilePath, fileName, true);
            userStoreConfigFile = Paths.get(tenantFilePath, String.valueOf(tenantId), "userstores", fileName + ".xml");
            previousUserStoreConfigFile = Paths.get(tenantFilePath, String.valueOf(tenantId), "userstores", previousFileName + ".xml");
        }
        if (!Files.exists(previousUserStoreConfigFile, new LinkOption[0])) {
            errorMessage = "Cannot update user store domain name. Previous domain name " + previousDomainName + " does not exists.";
            throw new IdentityUserStoreClientException(UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_XML_FILE_NOT_FOUND.getCode(), errorMessage);
        }
        if (Files.exists(userStoreConfigFile, new LinkOption[0])) {
            errorMessage = "Cannot update user store domain name. An user store already exists with new domain " + domainName + ".";
            throw new IdentityUserStoreClientException(UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_XML_FILE_ALREADY_EXISTS.getCode(), errorMessage);
        }
        try {
            SecondaryUserStoreConfigurationUtil.triggerListnersOnUserStorePreUpdate(previousDomainName, domainName);
            this.updatePersistedDomainName(previousDomainName, domainName, tenantId);
        }
        catch (UserStoreException e) {
            String errorMessage2 = "Error while updating user store domain : " + domainName;
            log.error((Object)errorMessage2, (Throwable)e);
            throw new IdentityUserStoreMgtException(errorMessage2);
        }
        try {
            Files.delete(previousUserStoreConfigFile);
            this.writeToUserStoreConfigurationFile(userStoreConfigFile, userStorePersistanceDTO.getUserStoreDTO(), true, false, previousDomainName);
        }
        catch (IOException e) {
            log.info((Object)("Error when deleting previous configuration files " + previousUserStoreConfigFile));
        }
    }

    @Override
    protected UserStorePersistanceDTO doGetUserStore(String domain) throws IdentityUserStoreMgtException {
        return null;
    }

    @Override
    protected UserStorePersistanceDTO[] doGetAllUserStores() throws IdentityUserStoreMgtException {
        RealmConfiguration secondaryRealmConfiguration;
        ArrayList<UserStorePersistanceDTO> userStorePersistanceDAOList = new ArrayList<UserStorePersistanceDTO>();
        UserStorePersistanceDTO userStorePersistanceDTO = new UserStorePersistanceDTO();
        try {
            secondaryRealmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getSecondaryRealmConfig();
        }
        catch (UserStoreException e) {
            String errorMessage = "Error while retrieving user store configurations";
            throw new IdentityUserStoreMgtException(errorMessage);
        }
        if (secondaryRealmConfiguration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SecondaryRealmConfiguration is null. Can not find any userStore.");
            }
            return new UserStorePersistanceDTO[0];
        }
        do {
            Map userStoreProperties;
            String uuid;
            if ((uuid = (String)(userStoreProperties = secondaryRealmConfiguration.getUserStoreProperties()).get("UniqueID")) == null) {
                uuid = UUID.randomUUID().toString();
            }
            String className = secondaryRealmConfiguration.getUserStoreClass();
            UserStoreDTO userStoreDTO = this.getUserStoreDTO(secondaryRealmConfiguration, userStoreProperties);
            userStoreProperties.put("Class", className);
            userStoreProperties.put("UniqueID", uuid);
            MaskedProperty[] maskedProperties = SecondaryUserStoreConfigurationUtil.setMaskInUserStoreProperties(secondaryRealmConfiguration, userStoreProperties, "ENCRYPTED PROPERTY", className);
            userStoreDTO.setProperties(SecondaryUserStoreConfigurationUtil.convertMapToArray(userStoreProperties));
            for (MaskedProperty maskedProperty : maskedProperties) {
                userStoreProperties.put(maskedProperty.getName(), maskedProperty.getValue());
            }
            userStorePersistanceDTO.setUserStoreDTO(userStoreDTO);
            userStorePersistanceDAOList.add(userStorePersistanceDTO);
        } while ((secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) != null);
        return userStorePersistanceDAOList.toArray(new UserStorePersistanceDTO[userStorePersistanceDAOList.size()]);
    }

    private UserStoreDTO getUserStoreDTO(RealmConfiguration secondaryRealmConfiguration, Map<String, String> userStoreProperties) {
        UserStoreDTO userStoreDTO = new UserStoreDTO();
        userStoreDTO.setClassName(secondaryRealmConfiguration.getUserStoreClass());
        userStoreDTO.setDescription(secondaryRealmConfiguration.getUserStoreProperty("Description"));
        userStoreDTO.setDomainId(secondaryRealmConfiguration.getUserStoreProperty("DomainName"));
        userStoreDTO.setRepositoryClass(FILE_BASED);
        if (userStoreProperties.get(DISABLED) != null) {
            userStoreDTO.setDisabled(Boolean.valueOf(userStoreProperties.get(DISABLED)));
        }
        return userStoreDTO;
    }

    private boolean isValidDomainToAdd(String domainName) throws IdentityUserStoreMgtException {
        if (StringUtils.isEmpty((String)domainName)) {
            throw new IdentityUserStoreClientException(" User store domain name should not be empty.");
        }
        if (domainName.contains("_")) {
            throw new IdentityUserStoreClientException(" User store domain name should not contain \"_\".");
        }
        if (this.getDomainNames().contains(domainName)) {
            throw new IdentityUserStoreClientException(UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_USER_STORE_DOMAIN_ALREADY_EXISTS.getCode(), " Cannot add user store. Domain name: " + domainName + " already exists.");
        }
        return true;
    }

    private List<String> getDomainNames() throws IdentityUserStoreMgtException {
        ArrayList<String> domains = new ArrayList<String>();
        RealmConfiguration realmConfiguration = null;
        try {
            realmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration();
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreMgtException(" Error occurred while retrieving the realm configuration ", e);
        }
        String domain = realmConfiguration.getUserStoreProperty("DomainName");
        if (domain == null) {
            domain = "PRIMARY";
        }
        domains.add(domain);
        for (RealmConfiguration secondaryRealmConfiguration = realmConfiguration.getSecondaryRealmConfig(); secondaryRealmConfiguration != null; secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) {
            domains.add(secondaryRealmConfiguration.getUserStoreProperty("DomainName"));
        }
        return domains;
    }

    private boolean isDomainNameExists(String domainName) throws IdentityUserStoreMgtException {
        if (StringUtils.isEmpty((String)domainName)) {
            throw new IdentityUserStoreClientException(UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_EMPTY_USERSTORE_DOMAIN_NAME.getCode(), UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_EMPTY_USERSTORE_DOMAIN_NAME.getMessage());
        }
        if (!this.getDomainNames().contains(domainName)) {
            throw new IdentityUserStoreClientException(UserStoreConfigurationConstant.ErrorMessage.ERROR_CODE_USER_STORE_DOMAIN_NOT_FOUND.getCode(), " Cannot find the domain name " + domainName + " to perform this operation");
        }
        return true;
    }
}

