/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.user.store.configuration.beans.MaskedProperty;
import org.wso2.carbon.identity.user.store.configuration.dao.AbstractUserStoreDAO;
import org.wso2.carbon.identity.user.store.configuration.dao.impl.DatabaseBasedUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStorePersistanceDTO;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurationUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.config.UserStoreConfigXMLProcessor;
import org.wso2.carbon.user.core.config.XMLProcessorUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class DatabaseBasedUserStoreDAOImpl
extends AbstractUserStoreDAO {
    private static final Log log = LogFactory.getLog(DatabaseBasedUserStoreDAOImpl.class);
    private SecretResolver secretResolver;
    private static final String DATABASE_BASED = DatabaseBasedUserStoreDAOFactory.class.getName();
    private XMLProcessorUtils xmlProcessorUtils = new XMLProcessorUtils();

    @Override
    protected void doAddUserStore(UserStorePersistanceDTO userStorePersistanceDTO) throws IdentityUserStoreMgtException {
        String domainName = userStorePersistanceDTO.getUserStoreDTO().getDomainId();
        try {
            SecondaryUserStoreConfigurationUtil.triggerListenersOnUserStorePreAdd(domainName);
            boolean isValidDomain = this.xmlProcessorUtils.isValidDomain(domainName, Boolean.valueOf(true));
            SecondaryUserStoreConfigurationUtil.validateForFederatedDomain(domainName);
            if (isValidDomain) {
                this.addUserStoreProperties(userStorePersistanceDTO.getUserStoreProperties(), domainName);
                this.addRealmToSecondaryUserStoreManager(userStorePersistanceDTO);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("The user store domain: " + domainName + "is not a valid domain name."));
            }
        }
        catch (XMLStreamException | org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occured while adding the user store with the domain: " + domainName, e);
        }
    }

    @Override
    protected void doUpdateUserStore(UserStorePersistanceDTO userStorePersistanceDTO, boolean isStateChange) throws IdentityUserStoreMgtException {
        String domainName = userStorePersistanceDTO.getUserStoreDTO().getDomainId();
        this.updateUserStoreProperties(domainName, userStorePersistanceDTO);
        try {
            this.removeRealmFromSecondaryUserStoreManager(domainName);
            this.addRealmToSecondaryUserStoreManager(userStorePersistanceDTO);
        }
        catch (XMLStreamException | org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occured while updating the userstore.", e);
        }
    }

    @Override
    protected void doUpdateUserStoreDomainName(String domainName, UserStorePersistanceDTO userStorePersistanceDTO) throws IdentityUserStoreMgtException {
        try {
            SecondaryUserStoreConfigurationUtil.triggerListnersOnUserStorePreUpdate(domainName, userStorePersistanceDTO.getUserStoreDTO().getDomainId());
            this.updateUserStoreProperties(domainName, userStorePersistanceDTO);
            this.removeRealmFromSecondaryUserStoreManager(domainName);
            this.addRealmToSecondaryUserStoreManager(userStorePersistanceDTO);
        }
        catch (XMLStreamException | org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occured while updating the userstore.", e);
        }
    }

    @Override
    protected UserStorePersistanceDTO doGetUserStore(String domainName) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        InputStream scriptBinaryStream = null;
        InputStream clonedStream = null;
        String userStoreProperties = null;
        UserStorePersistanceDTO userStorePersistanceDTO = new UserStorePersistanceDTO();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT ARTIFACT FROM IDN_ARTIFACT_STORE WHERE IDENTIFIER=? AND TENANT_ID = ? AND ARTIFACT_TYPE= ?");){
            prepStmt.setString(1, domainName);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, "USERSTORE");
            try (ResultSet rSet = prepStmt.executeQuery();){
                if (rSet.next()) {
                    RealmConfiguration realmConfiguration = null;
                    scriptBinaryStream = rSet.getBinaryStream(1);
                    clonedStream = rSet.getBinaryStream(1);
                    if (scriptBinaryStream != null) {
                        realmConfiguration = this.getRealmConfiguration(domainName, scriptBinaryStream);
                    }
                    if (clonedStream != null) {
                        userStoreProperties = IOUtils.toString((InputStream)clonedStream);
                    }
                    userStorePersistanceDTO.setUserStoreProperties(userStoreProperties);
                    if (realmConfiguration != null) {
                        userStorePersistanceDTO.setUserStoreDTO(this.getUserStoreDTO(realmConfiguration));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No user store properties found for domain: " + domainName + " in tenant: " + tenantId));
                }
            }
            catch (IOException | XMLStreamException | org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityUserStoreMgtException("Error occured while getting user store properties for domain:" + domainName + " in tenant:" + tenantId, e);
            }
            finally {
                try {
                    if (scriptBinaryStream != null) {
                        scriptBinaryStream.close();
                    }
                    if (clonedStream != null) {
                        clonedStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new IdentityUserStoreMgtException("Error occured while loading user stores.", e);
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityUserStoreMgtException("Could not read the user store properties for the domain:" + domainName + " in tenant:" + tenantId, e);
        }
        return userStorePersistanceDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected UserStorePersistanceDTO[] doGetAllUserStores() throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        ArrayList<UserStorePersistanceDTO> userStorePersistanceDTOs = new ArrayList<UserStorePersistanceDTO>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = connection.prepareStatement("SELECT IDENTIFIER, ARTIFACT FROM IDN_ARTIFACT_STORE WHERE TENANT_ID = ? AND ARTIFACT_TYPE= ?");){
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, "USERSTORE");
            try (ResultSet rSet = prepStmt.executeQuery();){
                while (rSet.next()) {
                    String identifier = rSet.getString(1);
                    InputStream scriptBinaryStream = null;
                    InputStream clonedStream = null;
                    String userStorePropertyValues = null;
                    try {
                        scriptBinaryStream = rSet.getBinaryStream(2);
                        clonedStream = rSet.getBinaryStream(2);
                        RealmConfiguration realmConfiguration = null;
                        if (scriptBinaryStream != null) {
                            realmConfiguration = this.getRealmConfiguration(identifier, scriptBinaryStream);
                        }
                        if (clonedStream != null) {
                            userStorePropertyValues = IOUtils.toString((InputStream)clonedStream);
                        }
                        this.getUserStorePersistanceDTOs(userStorePersistanceDTOs, realmConfiguration, userStorePropertyValues);
                    }
                    finally {
                        if (scriptBinaryStream != null) {
                            scriptBinaryStream.close();
                        }
                        if (clonedStream == null) continue;
                        clonedStream.close();
                    }
                }
                return userStorePersistanceDTOs.toArray(new UserStorePersistanceDTO[userStorePersistanceDTOs.size()]);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityUserStoreMgtException("Error occured while listing user stores in tenant: " + tenantId, e);
            }
            catch (IOException | XMLStreamException e) {
                throw new IdentityUserStoreMgtException("Could not read the user store properties in tenant:" + tenantId, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityUserStoreMgtException("Could not read the user store properties in tenant:" + tenantId, e);
        }
    }

    private void getUserStorePersistanceDTOs(List<UserStorePersistanceDTO> userStorePersistanceDTOs, RealmConfiguration realmConfiguration, String userStorePorpertyValues) {
        UserStorePersistanceDTO userStorePersistanceDTO = new UserStorePersistanceDTO();
        userStorePersistanceDTO.setUserStoreDTO(this.getUserStoreDTO(realmConfiguration));
        userStorePersistanceDTO.setUserStoreProperties(userStorePorpertyValues);
        userStorePersistanceDTOs.add(userStorePersistanceDTO);
    }

    private RealmConfiguration getRealmConfiguration(String identifier, InputStream scriptBinaryStream) throws org.wso2.carbon.user.api.UserStoreException, XMLStreamException {
        UserStoreConfigXMLProcessor userStoreXMLProcessor = new UserStoreConfigXMLProcessor("/" + identifier + ".xml");
        return userStoreXMLProcessor.buildUserStoreConfiguration(this.getRealmElement(scriptBinaryStream));
    }

    private UserStoreDTO getUserStoreDTO(RealmConfiguration realmConfiguration) {
        Map userStoreProperties = realmConfiguration.getUserStoreProperties();
        String uuid = (String)userStoreProperties.get("UniqueID");
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }
        String className = realmConfiguration.getUserStoreClass();
        UserStoreDTO userStoreDTO = this.getUserStoreDTO(realmConfiguration, userStoreProperties);
        userStoreProperties.put("Class", className);
        userStoreProperties.put("UniqueID", uuid);
        MaskedProperty[] maskedProperties = SecondaryUserStoreConfigurationUtil.setMaskInUserStoreProperties(realmConfiguration, userStoreProperties, "ENCRYPTED PROPERTY", className);
        userStoreDTO.setProperties(SecondaryUserStoreConfigurationUtil.convertMapToArray(userStoreProperties));
        for (MaskedProperty maskedProperty : maskedProperties) {
            userStoreProperties.put(maskedProperty.getName(), maskedProperty.getValue());
        }
        return userStoreDTO;
    }

    private OMElement getRealmElement(InputStream inputStream) throws XMLStreamException, UserStoreException {
        try {
            inputStream = CarbonUtils.replaceSystemVariablesInXml((InputStream)inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(inputStream);
            OMElement documentElement = builder.getDocumentElement();
            this.setSecretResolver(documentElement);
            return documentElement;
        }
        catch (CarbonException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private void setSecretResolver(OMElement rootElement) {
        this.secretResolver = SecretResolverFactory.create((OMElement)rootElement, (boolean)true);
    }

    private UserStoreDTO getUserStoreDTO(RealmConfiguration secondaryRealmConfiguration, Map<String, String> userStoreProperties) {
        UserStoreDTO userStoreDTO = new UserStoreDTO();
        userStoreDTO.setClassName(secondaryRealmConfiguration.getUserStoreClass());
        userStoreDTO.setDescription(secondaryRealmConfiguration.getUserStoreProperty("Description"));
        userStoreDTO.setDomainId(secondaryRealmConfiguration.getUserStoreProperty("DomainName"));
        userStoreDTO.setRepositoryClass(DATABASE_BASED);
        if (userStoreProperties.get("Disabled") != null) {
            userStoreDTO.setDisabled(Boolean.valueOf(userStoreProperties.get("Disabled")));
        }
        return userStoreDTO;
    }

    private void addUserStoreProperties(String userStoreProperties, String domainName) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String errorMessage = "Error occurred while updating the user store properties for the userstore domain:" + domainName + "in the tenant:" + tenantId;
        try {
            try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
                try (PreparedStatement userStorePrepStmt = connection.prepareStatement("INSERT INTO IDN_ARTIFACT_STORE (ID,TENANT_ID,ARTIFACT,IDENTIFIER,CONTENT_TYPE,ARTIFACT_TYPE) VALUES (?,?,?,?,?,?)");){
                    String uuid = String.valueOf(UUID.randomUUID());
                    userStorePrepStmt.setString(1, uuid);
                    userStorePrepStmt.setInt(2, tenantId);
                    this.setBlobValue(userStoreProperties, userStorePrepStmt, 3);
                    userStorePrepStmt.setString(4, domainName);
                    userStorePrepStmt.setString(5, "XML");
                    userStorePrepStmt.setString(6, "USERSTORE");
                    userStorePrepStmt.execute();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The userstore domain:" + domainName + "added for the tenant:" + tenantId));
                    }
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                }
                catch (SQLException e) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    throw new IdentityUserStoreMgtException(errorMessage, e);
                }
            }
            catch (IOException | SQLException ex) {
                throw new IdentityUserStoreMgtException(errorMessage, ex);
            }
        }
        catch (IdentityRuntimeException e) {
            throw new IdentityUserStoreMgtException("Couldn't get a database connection.", e);
        }
    }

    @Override
    public void deleteUserStore(String domain) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            SecondaryUserStoreConfigurationUtil.triggerListnersOnUserStorePreDelete(domain);
            AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            if (userStoreManager == null) {
                throw new IdentityUserStoreMgtException("Unable to find a user store from the ThreadLocalCarbonContext.");
            }
            userStoreManager.deletePersistedDomain(domain);
            this.deleteUserStore(domain, tenantId);
            this.removeRealmFromSecondaryUserStoreManager(domain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error while triggering the userstore pre delete listeners.");
        }
    }

    private void deleteUserStore(String domain, int tenantId) throws IdentityUserStoreMgtException {
        String msg = "Error while removing the user store with the domain name: " + domain + " in the tenant: " + tenantId;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement ps = connection.prepareStatement("DELETE FROM IDN_ARTIFACT_STORE WHERE IDENTIFIER = ? AND TENANT_ID = ? AND ARTIFACT_TYPE= ?");){
                ps.setString(1, domain);
                ps.setInt(2, tenantId);
                ps.setString(3, "USERSTORE");
                ps.executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The userstore domain :" + domain + "removed for the tenant" + tenantId));
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityUserStoreMgtException(msg, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityUserStoreMgtException(msg, e);
        }
    }

    private void removeRealmFromSecondaryUserStoreManager(String domain) throws UserStoreException {
        UserRealm userRealm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        AbstractUserStoreManager primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
        primaryUSM.removeSecondaryUserStoreManager(domain);
    }

    @Override
    public void deleteUserStores(String[] domains) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String msg = "Error while removing the user store in the tenant: " + tenantId;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement ps = connection.prepareStatement("DELETE FROM IDN_ARTIFACT_STORE WHERE IDENTIFIER = ? AND TENANT_ID = ? AND ARTIFACT_TYPE= ?");){
                for (String domain : domains) {
                    this.addToBatchForDeleteUserStores(domain, tenantId, ps);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The userstore domain :" + domain + "in tenant :" + tenantId + " added to the batch to remove."));
                    }
                    this.removeRealmFromSecondaryUserStoreManager(domain);
                }
                ps.executeBatch();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityUserStoreMgtException(msg, e);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new IdentityUserStoreMgtException(msg, e);
            }
        }
        catch (SQLException e) {
            throw new IdentityUserStoreMgtException(msg, e);
        }
    }

    private void updateUserStoreProperties(String domainName, UserStorePersistanceDTO userStorePersistanceDTO) throws IdentityUserStoreMgtException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String msg = "Error occured while updating user store properties for the domain:" + domainName + "in the tenant:" + tenantId;
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement pst = connection.prepareStatement("UPDATE IDN_ARTIFACT_STORE SET ARTIFACT= ?,IDENTIFIER= ? WHERE IDENTIFIER = ? AND TENANT_ID = ? AND ARTIFACT_TYPE = ?");){
                this.setBlobValue(userStorePersistanceDTO.getUserStoreProperties(), pst, 1);
                pst.setString(2, userStorePersistanceDTO.getUserStoreDTO().getDomainId());
                pst.setString(3, domainName);
                pst.setInt(4, tenantId);
                pst.setString(5, "USERSTORE");
                pst.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The userstore domain:" + domainName + "updated for the tenant:" + tenantId));
                }
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityUserStoreMgtException(msg, e);
            }
            catch (IOException ex) {
                throw new IdentityUserStoreMgtException(msg, ex);
            }
        }
        catch (SQLException e) {
            throw new IdentityUserStoreMgtException(msg);
        }
    }

    private void setBlobValue(String value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }

    private void addToBatchForDeleteUserStores(String domain, int tenantId, PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, domain);
        preparedStatement.setInt(2, tenantId);
        preparedStatement.setString(3, "USERSTORE");
        preparedStatement.addBatch();
    }

    private void addRealmToSecondaryUserStoreManager(UserStorePersistanceDTO userStorePersistanceDTO) throws org.wso2.carbon.user.api.UserStoreException, XMLStreamException {
        UserRealm userRealm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        AbstractUserStoreManager primaryUSM = (AbstractUserStoreManager)userRealm.getUserStoreManager();
        ByteArrayInputStream targetStream = new ByteArrayInputStream(userStorePersistanceDTO.getUserStoreProperties().getBytes());
        RealmConfiguration realmConfiguration = this.getRealmConfiguration(userStorePersistanceDTO.getUserStoreDTO().getDomainId(), targetStream);
        primaryUSM.addSecondaryUserStoreManager(realmConfiguration, userRealm);
    }
}

