/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration.dao;

import java.util.ArrayList;
import org.wso2.carbon.identity.user.store.configuration.dao.UserStoreDAO;
import org.wso2.carbon.identity.user.store.configuration.dto.PropertyDTO;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStorePersistanceDTO;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurationUtil;

public abstract class AbstractUserStoreDAO
implements UserStoreDAO {
    public static final String DISABLED = "Disabled";

    @Override
    public void addUserStore(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        UserStorePersistanceDTO userStorePersistanceDTO = this.getUserStorePersistanceDTO(userStoreDTO, this.getUserStoreProperties(userStoreDTO, userStoreDTO.getDomainId()));
        this.doAddUserStore(userStorePersistanceDTO);
    }

    @Override
    public void updateUserStore(UserStoreDTO userStoreDTO, boolean isStateChange) throws IdentityUserStoreMgtException {
        if (isStateChange) {
            userStoreDTO = this.getUserStoreProperty(userStoreDTO);
        }
        UserStorePersistanceDTO userStorePersistanceDTO = this.getUserStorePersistanceDTO(userStoreDTO, this.getUserStoreProperties(userStoreDTO, userStoreDTO.getDomainId()));
        userStorePersistanceDTO.setUserStoreDTO(userStoreDTO);
        this.doUpdateUserStore(userStorePersistanceDTO, isStateChange);
    }

    private UserStoreDTO getUserStoreProperty(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        boolean newState = userStoreDTO.getDisabled();
        UserStoreDTO userStoreDTOTemp = this.getUserStore(userStoreDTO.getDomainId());
        if (userStoreDTOTemp != null) {
            PropertyDTO[] propertyDTO;
            userStoreDTO = userStoreDTOTemp;
            userStoreDTO.setDisabled(newState);
            for (PropertyDTO propertyDTOValue : propertyDTO = userStoreDTO.getProperties()) {
                if (!propertyDTOValue.getName().equals(DISABLED)) continue;
                propertyDTOValue.setValue(String.valueOf(newState));
            }
        }
        return userStoreDTO;
    }

    @Override
    public void updateUserStoreDomainName(String previousDomainName, UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        UserStorePersistanceDTO userStorePersistanceDTO = this.getUserStorePersistanceDTO(userStoreDTO, this.getUserStoreProperties(userStoreDTO, previousDomainName));
        this.doUpdateUserStoreDomainName(previousDomainName, userStorePersistanceDTO);
    }

    @Override
    public UserStoreDTO getUserStore(String domain) throws IdentityUserStoreMgtException {
        UserStorePersistanceDTO userStorePersistanceDTO = this.doGetUserStore(domain);
        if (userStorePersistanceDTO != null) {
            return userStorePersistanceDTO.getUserStoreDTO();
        }
        return null;
    }

    @Override
    public UserStoreDTO[] getUserStores() throws IdentityUserStoreMgtException {
        UserStorePersistanceDTO[] userStorePersistanceDTOS = this.doGetAllUserStores();
        ArrayList<UserStoreDTO> userStoreDTOs = new ArrayList<UserStoreDTO>();
        for (UserStorePersistanceDTO userStorePersistanceDTO : userStorePersistanceDTOS) {
            userStoreDTOs.add(userStorePersistanceDTO.getUserStoreDTO());
        }
        return userStoreDTOs.toArray(new UserStoreDTO[userStoreDTOs.size()]);
    }

    protected abstract void doAddUserStore(UserStorePersistanceDTO var1) throws IdentityUserStoreMgtException;

    protected abstract void doUpdateUserStore(UserStorePersistanceDTO var1, boolean var2) throws IdentityUserStoreMgtException;

    protected abstract void doUpdateUserStoreDomainName(String var1, UserStorePersistanceDTO var2) throws IdentityUserStoreMgtException;

    protected abstract UserStorePersistanceDTO doGetUserStore(String var1) throws IdentityUserStoreMgtException;

    protected abstract UserStorePersistanceDTO[] doGetAllUserStores() throws IdentityUserStoreMgtException;

    private String getUserStoreProperties(UserStoreDTO userStoreDTO, String existingDomainName) throws IdentityUserStoreMgtException {
        return SecondaryUserStoreConfigurationUtil.getUserStoreProperties(userStoreDTO, existingDomainName);
    }

    private UserStorePersistanceDTO getUserStorePersistanceDTO(UserStoreDTO userStoreDTO, String userStoreProperties) {
        UserStorePersistanceDTO userStorePersistanceDTO = new UserStorePersistanceDTO();
        userStorePersistanceDTO.setUserStoreDTO(userStoreDTO);
        userStorePersistanceDTO.setUserStoreProperties(userStoreProperties);
        return userStorePersistanceDTO;
    }
}

