/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.store.configuration.UserStoreConfigService;
import org.wso2.carbon.identity.user.store.configuration.dao.AbstractUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigListenersHolder;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreClientException;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurationUtil;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.services.WSDataSourceMetaInfo;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;

public class UserStoreConfigServiceImpl
implements UserStoreConfigService {
    private static final Log LOG = LogFactory.getLog(UserStoreConfigServiceImpl.class);
    private static final String FILE_BASED_REPOSITORY_CLASS = "org.wso2.carbon.identity.user.store.configuration.dao.impl.FileBasedUserStoreDAOFactory";
    private static final String DB_BASED_REPOSITORY_CLASS = "org.wso2.carbon.identity.user.store.configuration.dao.impl.DatabaseBasedUserStoreDAOFactory";

    @Override
    public void addUserStore(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        this.loadTenant();
        try {
            if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.isNotBlank((String)userStoreDTO.getRepositoryClass())) {
                AbstractUserStoreDAOFactory userStoreDAOFactory = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().get(userStoreDTO.getRepositoryClass());
                userStoreDAOFactory.getInstance().addUserStore(userStoreDTO);
            } else {
                if (StringUtils.isNotBlank((String)userStoreDTO.getRepositoryClass()) && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Repository separation of user-stores has been disabled. Adding user-store " + userStoreDTO.getDomainId() + " with file-based configuration."));
                }
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().addUserStore(userStoreDTO);
            }
        }
        catch (UserStoreException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage, e);
        }
    }

    @Override
    public void updateUserStore(UserStoreDTO userStoreDTO, boolean isStateChange) throws IdentityUserStoreMgtException {
        this.loadTenant();
        try {
            if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.isNotEmpty((String)userStoreDTO.getRepositoryClass())) {
                AbstractUserStoreDAOFactory userStoreDAOFactory = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().get(userStoreDTO.getRepositoryClass());
                userStoreDAOFactory.getInstance().updateUserStore(userStoreDTO, false);
            } else if (StringUtils.equals((String)userStoreDTO.getRepositoryClass(), (String)FILE_BASED_REPOSITORY_CLASS)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Repository separation of user-stores has been disabled. Editing user-store " + userStoreDTO.getDomainId() + " with file-based configuration."));
                }
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStore(userStoreDTO, false);
            } else if (StringUtils.isNotEmpty((String)userStoreDTO.getRepositoryClass())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Repository separation of user-stores has been disabled. Unable to edit user-store " + userStoreDTO.getDomainId() + " with repository class " + userStoreDTO.getRepositoryClass()));
                }
            } else {
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStore(userStoreDTO, false);
            }
        }
        catch (UserStoreException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage, e);
        }
    }

    @Override
    public void updateUserStoreByDomainName(String previousDomainName, UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        this.loadTenant();
        try {
            if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.isNotEmpty((String)userStoreDTO.getRepositoryClass())) {
                AbstractUserStoreDAOFactory userStoreDAOFactory = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().get(userStoreDTO.getRepositoryClass());
                userStoreDAOFactory.getInstance().updateUserStoreDomainName(previousDomainName, userStoreDTO);
            } else if (StringUtils.equals((String)userStoreDTO.getRepositoryClass(), (String)FILE_BASED_REPOSITORY_CLASS)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Repository separation of user-stores has been disabled. Updating user-store domain name " + userStoreDTO.getDomainId() + " with file-based configuration."));
                }
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStoreDomainName(previousDomainName, userStoreDTO);
            } else if (StringUtils.isNotEmpty((String)userStoreDTO.getRepositoryClass())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Repository separation of user-stores has been disabled. Unable to update user-store domain name " + userStoreDTO.getDomainId() + " with repository class " + userStoreDTO.getRepositoryClass()));
                }
            } else {
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStoreDomainName(previousDomainName, userStoreDTO);
            }
        }
        catch (UserStoreException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
    }

    @Override
    public void deleteUserStore(String domain) throws IdentityUserStoreMgtException {
        if (StringUtils.isEmpty((String)domain)) {
            throw new IdentityUserStoreClientException("No selected user store to delete.");
        }
        if (!this.validateDomainsForDelete(new String[]{domain})) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to delete user store " + domain + " : No privileges to delete own user store configurations "));
            }
            throw new IdentityUserStoreClientException("No privileges to delete own user store configurations.");
        }
        try {
            Map<String, AbstractUserStoreDAOFactory> userStoreDAOFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
            for (Map.Entry<String, AbstractUserStoreDAOFactory> entry : userStoreDAOFactories.entrySet()) {
                if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.equals((String)entry.getKey(), (String)DB_BASED_REPOSITORY_CLASS)) {
                    entry.getValue().getInstance().deleteUserStore(domain);
                    continue;
                }
                SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().deleteUserStore(domain);
            }
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occurred while deleting the user store.", e);
        }
    }

    @Override
    public void deleteUserStoreSet(String[] domains) throws IdentityUserStoreMgtException {
        if (domains == null || domains.length <= 0) {
            throw new IdentityUserStoreMgtException("No selected user stores to delete");
        }
        if (!this.validateDomainsForDelete(domains)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to delete user store : No privileges to delete own user store configurations ");
            }
            throw new IdentityUserStoreClientException("No privileges to delete own user store configurations.");
        }
        try {
            SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().deleteUserStores(domains);
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occurred while deleting the user store.", e);
        }
    }

    @Override
    public UserStoreDTO getUserStore(String domain) throws IdentityUserStoreMgtException {
        UserStoreDTO[] userStoreDTOS = new UserStoreDTO[]{};
        Map<String, AbstractUserStoreDAOFactory> userStoreDAOFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
        for (Map.Entry<String, AbstractUserStoreDAOFactory> entry : userStoreDAOFactories.entrySet()) {
            if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.equals((String)entry.getKey(), (String)DB_BASED_REPOSITORY_CLASS)) {
                return entry.getValue().getInstance().getUserStore(domain);
            }
            try {
                userStoreDTOS = SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().getUserStores();
            }
            catch (UserStoreException e) {
                throw new IdentityUserStoreMgtException("Error occurred while retrieving the user stores from file based system.", e);
            }
        }
        if (userStoreDTOS != null) {
            for (UserStoreDTO userStoreDTO : userStoreDTOS) {
                if (!userStoreDTO.getDomainId().equals(domain)) continue;
                return userStoreDTO;
            }
        }
        return null;
    }

    @Override
    public UserStoreDTO[] getUserStores() throws IdentityUserStoreMgtException {
        ArrayList<UserStoreDTO> userStoreDTOList = new ArrayList<UserStoreDTO>();
        Map<String, AbstractUserStoreDAOFactory> userStoreDAOFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
        for (Map.Entry<String, AbstractUserStoreDAOFactory> entry : userStoreDAOFactories.entrySet()) {
            if (!SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.equals((String)entry.getKey(), (String)DB_BASED_REPOSITORY_CLASS)) continue;
            UserStoreDTO[] allUserStores = entry.getValue().getInstance().getUserStores();
            userStoreDTOList.addAll(Arrays.asList(allUserStores));
        }
        return userStoreDTOList.toArray(new UserStoreDTO[0]);
    }

    @Override
    public Set<String> getAvailableUserStoreClasses() throws IdentityUserStoreMgtException {
        return this.getAllowedUserstoreClasses(UserStoreManagerRegistry.getUserStoreManagerClasses());
    }

    private Set<String> getAllowedUserstoreClasses(Set<String> userstores) {
        Set<String> allowedUserstores = UserStoreConfigListenersHolder.getInstance().getAllowedUserstores();
        if (allowedUserstores == null) {
            return userstores;
        }
        userstores.retainAll(allowedUserstores);
        return userstores;
    }

    @Override
    public boolean testRDBMSConnection(String domainName, String driverName, String connectionURL, String username, String connectionPassword, String messageID) throws IdentityUserStoreMgtException {
        Map<String, String> secondaryUserStoreProperties;
        if (StringUtils.isNotEmpty((String)messageID) && StringUtils.isNotEmpty((String)domainName) && connectionPassword.equalsIgnoreCase("ENCRYPTED PROPERTY") && (secondaryUserStoreProperties = SecondaryUserStoreConfigurationUtil.getSecondaryUserStorePropertiesFromTenantUserRealm(domainName)) != null) {
            connectionPassword = secondaryUserStoreProperties.get("password");
        }
        WSDataSourceMetaInfo wSDataSourceMetaInfo = new WSDataSourceMetaInfo();
        RDBMSConfiguration rdbmsConfiguration = new RDBMSConfiguration();
        rdbmsConfiguration.setUrl(connectionURL);
        rdbmsConfiguration.setUsername(username);
        rdbmsConfiguration.setPassword(connectionPassword);
        rdbmsConfiguration.setDriverClassName(driverName);
        WSDataSourceMetaInfo.WSDataSourceDefinition wSDataSourceDefinition = new WSDataSourceMetaInfo.WSDataSourceDefinition();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RDBMSConfiguration.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)rdbmsConfiguration, (OutputStream)out);
        }
        catch (JAXBException e) {
            String errorMessage = "Error while checking RDBMS connection health";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new IdentityUserStoreMgtException(errorMessage);
        }
        wSDataSourceDefinition.setDsXMLConfiguration(out.toString());
        wSDataSourceDefinition.setType("RDBMS");
        if (StringUtils.isNotEmpty((String)domainName)) {
            wSDataSourceMetaInfo.setName(domainName);
        }
        wSDataSourceMetaInfo.setDefinition(wSDataSourceDefinition);
        try {
            return DataSourceManager.getInstance().getDataSourceRepository().testDataSourceConnection(wSDataSourceMetaInfo.extractDataSourceMetaInfo());
        }
        catch (DataSourceException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
    }

    @Override
    public void modifyUserStoreState(String domain, Boolean isDisable, String repositoryClass) throws IdentityUserStoreMgtException {
        this.loadTenant();
        if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled() && StringUtils.isNotEmpty((String)repositoryClass)) {
            Map<String, AbstractUserStoreDAOFactory> userStoreDAOFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
            AbstractUserStoreDAOFactory userStoreDAOFactory = userStoreDAOFactories.get(repositoryClass);
            UserStoreDTO userStoreDTO = this.getUserStoreDTO(domain, isDisable, repositoryClass);
            userStoreDAOFactory.getInstance().updateUserStore(userStoreDTO, true);
        } else if (StringUtils.equals((String)repositoryClass, (String)FILE_BASED_REPOSITORY_CLASS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Repository separation of user-stores has been disabled. Modifying state for user-store " + domain + " with file-based configuration."));
            }
            UserStoreDTO userStoreDTO = this.getUserStoreDTO(domain, isDisable, null);
            this.updateStateInFileRepository(userStoreDTO);
        } else if (StringUtils.isNotEmpty((String)repositoryClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Repository separation of user-stores has been disabled. Unable to modify state for user-store " + domain + " with repository class " + repositoryClass));
            }
        } else {
            UserStoreDTO userStoreDTO = this.getUserStoreDTO(domain, isDisable, null);
            this.updateStateInFileRepository(userStoreDTO);
        }
    }

    private boolean validateDomainsForDelete(String[] domains) {
        String userDomain = IdentityUtil.extractDomainFromName((String)PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername());
        for (String domain : domains) {
            if (!domain.equalsIgnoreCase(userDomain)) continue;
            return false;
        }
        return true;
    }

    private void updateStateInFileRepository(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        try {
            SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStore(userStoreDTO, true);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
    }

    private UserStoreDTO getUserStoreDTO(String domain, Boolean isDisable, String repositoryClass) {
        UserStoreDTO userStoreDTO = new UserStoreDTO();
        userStoreDTO.setDomainId(domain);
        userStoreDTO.setDisabled(isDisable);
        userStoreDTO.setRepositoryClass(repositoryClass);
        return userStoreDTO;
    }

    private void loadTenant() throws IdentityUserStoreMgtException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if ("carbon.super".equals(tenantDomain)) {
            return;
        }
        Set loadedTenants = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)UserStoreConfigListenersHolder.getInstance().getConfigurationContextService().getServerConfigContext()).keySet();
        if (!loadedTenants.contains(tenantDomain)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Tenant: " + tenantDomain + " is not loaded. Therefore attempting to load the tenant."));
            }
            try {
                TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)UserStoreConfigListenersHolder.getInstance().getConfigurationContextService().getServerConfigContext());
            }
            catch (Exception e) {
                throw new IdentityUserStoreMgtException(e.getMessage(), e);
            }
        }
    }
}

