/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.user.store.configuration.dao.AbstractUserStoreDAOFactory;
import org.wso2.carbon.identity.user.store.configuration.dto.UserStoreDTO;
import org.wso2.carbon.identity.user.store.configuration.internal.UserStoreConfigListenersHolder;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreClientException;
import org.wso2.carbon.identity.user.store.configuration.utils.IdentityUserStoreMgtException;
import org.wso2.carbon.identity.user.store.configuration.utils.SecondaryUserStoreConfigurationUtil;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.tracker.UserStoreManagerRegistry;

public class UserStoreConfigAdminService
extends AbstractAdmin {
    public static final Log LOG = LogFactory.getLog(UserStoreConfigAdminService.class);
    private static final String FILE_BASED_REPOSITORY_CLASS = "org.wso2.carbon.identity.user.store.configuration.dao.impl.FileBasedUserStoreDAOFactory";

    public UserStoreDTO[] getSecondaryRealmConfigurations() throws IdentityUserStoreMgtException {
        return UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().getUserStores();
    }

    public UserStoreDTO[] getSecondaryRealmConfigurationsOnRepository(String repositoryClassName) throws IdentityUserStoreMgtException {
        if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled()) {
            Map<String, AbstractUserStoreDAOFactory> userStoreDAOFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
            AbstractUserStoreDAOFactory userStoreDAOFactory = userStoreDAOFactories.get(repositoryClassName);
            if (userStoreDAOFactory != null) {
                return userStoreDAOFactory.getInstance().getUserStores();
            }
            return new UserStoreDTO[0];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Repository separation of user-stores has been disabled. Returning empty UserStoreDTO array.");
        }
        return new UserStoreDTO[0];
    }

    public String[] getAvailableUserStoreClasses() throws IdentityUserStoreMgtException {
        Set<String> classNames = UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().getAvailableUserStoreClasses();
        return classNames.toArray(new String[0]);
    }

    public Properties getUserStoreManagerProperties(String className) throws IdentityUserStoreMgtException {
        Properties properties = UserStoreManagerRegistry.getUserStoreProperties((String)className);
        if (properties != null && properties.getOptionalProperties() != null) {
            Property[] optionalProperties = properties.getOptionalProperties();
            boolean foundUniqueIDProperty = false;
            for (Property property : optionalProperties) {
                if (!"UniqueID".equals(property.getName())) continue;
                foundUniqueIDProperty = true;
                break;
            }
            if (!foundUniqueIDProperty) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Inserting property : UniqueID since UniqueID property not defined as an optional property in " + className + " class"));
                }
                ArrayList<Property> optionalPropertyList = new ArrayList<Property>(Arrays.asList(optionalProperties));
                Property uniqueIDProperty = new Property("UniqueID", "", "", null);
                optionalPropertyList.add(uniqueIDProperty);
                properties.setOptionalProperties(optionalPropertyList.toArray(new Property[optionalPropertyList.size()]));
            }
        }
        return properties;
    }

    public void addUserStore(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        try {
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().addUserStore(userStoreDTO);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while adding the userstore.");
        }
    }

    public void editUserStore(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        try {
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().updateUserStore(userStoreDTO, false);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while updating the userstore.");
        }
    }

    public void editUserStoreWithDomainName(String previousDomainName, UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        String domainName = userStoreDTO.getDomainId();
        if (isDebugEnabled) {
            LOG.debug((Object)("Changing user store " + previousDomainName + " to " + domainName));
        }
        try {
            SecondaryUserStoreConfigurationUtil.validateForFederatedDomain(domainName);
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().updateUserStoreByDomainName(previousDomainName, userStoreDTO);
        }
        catch (UserStoreException e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while updating the userstore.");
        }
    }

    public String[] getRepositoryClasses() {
        if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled()) {
            Map<String, AbstractUserStoreDAOFactory> userStoreFactories = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories();
            String[] repositoryArr = userStoreFactories.keySet().toArray(new String[0]);
            return (String[])Arrays.copyOf(repositoryArr, repositoryArr.length, String[].class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Repository separation of user-stores has been disabled. Returning empty repository class array.");
        }
        return new String[0];
    }

    public void deleteUserStore(String domainName) throws IdentityUserStoreMgtException {
        try {
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().deleteUserStore(domainName);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while deleting the userstore.");
        }
    }

    public void deleteUserStoreFromRepository(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        this.deleteUserStoresSetFromRepository(new UserStoreDTO[]{userStoreDTO});
    }

    public void deleteUserStoresSet(String[] domains) throws IdentityUserStoreMgtException {
        try {
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().deleteUserStoreSet(domains);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while deleting the userstore list.");
        }
    }

    public void deleteUserStoresSetFromRepository(UserStoreDTO[] userStoreDTOs) throws IdentityUserStoreMgtException {
        if (SecondaryUserStoreConfigurationUtil.isUserStoreRepositorySeparationEnabled()) {
            for (String repositoryClass : UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().keySet()) {
                ArrayList<String> domains = new ArrayList<String>();
                for (UserStoreDTO userStoreDTO : userStoreDTOs) {
                    if (!repositoryClass.equals(userStoreDTO.getRepositoryClass())) continue;
                    domains.add(userStoreDTO.getDomainId());
                }
                if (!CollectionUtils.isNotEmpty(domains)) continue;
                AbstractUserStoreDAOFactory userStoreDAOFactory = UserStoreConfigListenersHolder.getInstance().getUserStoreDAOFactories().get(repositoryClass);
                try {
                    userStoreDAOFactory.getInstance().deleteUserStores(domains.toArray(new String[0]));
                }
                catch (IdentityUserStoreClientException e) {
                    throw this.buildIdentityUserStoreMgtException(e, "Error while deleting the userstore list.");
                }
            }
        } else {
            ArrayList<String> domainList = new ArrayList<String>();
            for (UserStoreDTO userStoreDTO : userStoreDTOs) {
                if (!StringUtils.equals((String)userStoreDTO.getRepositoryClass(), (String)FILE_BASED_REPOSITORY_CLASS)) continue;
                domainList.add(userStoreDTO.getDomainId());
            }
            String[] domains = domainList.toArray(new String[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Repository separation of user-stores has been disabled. Attempting to remove user-stores with file-based configurations. For user-stores " + String.join((CharSequence)",", domainList)));
            }
            this.deleteUserStoresSet(domains);
        }
    }

    public void changeUserStoreState(String domain, Boolean isDisable) throws IdentityUserStoreMgtException, TransformerConfigurationException {
        this.validateDomain(domain, isDisable);
        try {
            SecondaryUserStoreConfigurationUtil.triggerListenersOnUserStorePreStateChange(domain, isDisable);
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occurred while triggering the user store pre state change listeners.");
        }
        UserStoreDTO userStoreDTO = this.getUserStoreDTO(domain, isDisable, null);
        this.updateStateInFileRepository(userStoreDTO);
    }

    private void updateStateInFileRepository(UserStoreDTO userStoreDTO) throws IdentityUserStoreMgtException {
        try {
            SecondaryUserStoreConfigurationUtil.getFileBasedUserStoreDAOFactory().updateUserStore(userStoreDTO, true);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            throw new IdentityUserStoreMgtException(errorMessage);
        }
    }

    public void modifyUserStoreState(String domain, Boolean isDisable, String repositoryClass) throws IdentityUserStoreMgtException {
        this.validateDomain(domain, isDisable);
        try {
            SecondaryUserStoreConfigurationUtil.triggerListenersOnUserStorePreStateChange(domain, isDisable);
            UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().modifyUserStoreState(domain, isDisable, repositoryClass);
        }
        catch (IdentityUserStoreClientException e) {
            throw this.buildIdentityUserStoreMgtException(e, "Error while modifying the userstore state.");
        }
        catch (UserStoreException e) {
            throw new IdentityUserStoreMgtException("Error occurred while triggering the user store pre state change listeners.");
        }
    }

    private void validateDomain(String domain, Boolean isDisable) throws IdentityUserStoreMgtException {
        String currentAuthorizedUserName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        int index = currentAuthorizedUserName.indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
        String currentUserDomain = null;
        if (index > 0) {
            currentUserDomain = currentAuthorizedUserName.substring(0, index);
        }
        if (currentUserDomain != null && currentUserDomain.equalsIgnoreCase(domain) && isDisable.booleanValue()) {
            LOG.error((Object)"Error while disabling user store from a user who is in the same user store.");
            throw new IdentityUserStoreMgtException("Error while updating user store state.");
        }
    }

    private UserStoreDTO getUserStoreDTO(String domain, Boolean isDisable, String repositoryClass) {
        UserStoreDTO userStoreDTO = new UserStoreDTO();
        userStoreDTO.setDomainId(domain);
        userStoreDTO.setDisabled(isDisable);
        userStoreDTO.setRepositoryClass(repositoryClass);
        return userStoreDTO;
    }

    public boolean testRDBMSConnection(String domainName, String driverName, String connectionURL, String username, String connectionPassword, String messageID) throws IdentityUserStoreMgtException {
        return UserStoreConfigListenersHolder.getInstance().getUserStoreConfigService().testRDBMSConnection(domainName, driverName, connectionURL, username, connectionPassword, messageID);
    }

    private IdentityUserStoreMgtException buildIdentityUserStoreMgtException(IdentityUserStoreClientException e, String defaultMessage) {
        String errorMessage = defaultMessage;
        if (e.getMessage() != null) {
            errorMessage = e.getMessage();
        }
        return new IdentityUserStoreMgtException(errorMessage, e);
    }
}

