/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.webfinger.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.webfinger.WebFingerEndpointException;
import org.wso2.carbon.identity.webfinger.WebFingerProcessor;
import org.wso2.carbon.identity.webfinger.internal.WebFingerServiceComponentHolder;
import org.wso2.carbon.identity.webfinger.servlet.JSONResponseBuilder;

public class WebFingerServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(WebFingerServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.getOIDProviderIssuer(httpServletRequest, httpServletResponse);
    }

    public void getOIDProviderIssuer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        WebFingerProcessor processor = WebFingerServiceComponentHolder.getWebFingerProcessor();
        String response = "";
        try {
            JSONResponseBuilder webFingerResponseBuilder = new JSONResponseBuilder();
            response = webFingerResponseBuilder.getOIDProviderIssuerString(processor.getResponse(httpServletRequest));
        }
        catch (WebFingerEndpointException e) {
            httpServletResponse.setStatus(processor.handleError(e));
            return;
        }
        catch (ServerConfigurationException e) {
            log.error((Object)"Server Configuration error occurred.", (Throwable)e);
            httpServletResponse.setStatus(500);
            return;
        }
        httpServletResponse.setContentType("application/jrd+json");
        PrintWriter out = httpServletResponse.getWriter();
        out.print(response);
    }
}

