/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.webfinger.internal;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.identity.webfinger.DefaultWebFingerProcessor;
import org.wso2.carbon.identity.webfinger.WebFingerProcessor;
import org.wso2.carbon.identity.webfinger.internal.WebFingerServiceComponentHolder;
import org.wso2.carbon.identity.webfinger.servlet.WebFingerServlet;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.webfinger.component", immediate=true)
public class WebFingerServiceComponent {
    private static final Log log = LogFactory.getLog(WebFingerServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            DefaultWebFingerProcessor webFingerProcessor = DefaultWebFingerProcessor.getInstance();
            bundleContext.registerService(WebFingerProcessor.class.getName(), (Object)webFingerProcessor, null);
            WebFingerServiceComponentHolder.setWebFingerProcessor(webFingerProcessor);
            if (log.isDebugEnabled()) {
                log.debug((Object)"OpenID WebFinger bundle is activated.");
            }
            HttpService httpService = WebFingerServiceComponentHolder.getHttpService();
            ContextPathServletAdaptor webFingerServlet = new ContextPathServletAdaptor((Servlet)new WebFingerServlet(), "/.well-known/webfinger");
            try {
                httpService.registerServlet("/.well-known/webfinger", (Servlet)webFingerServlet, null, null);
            }
            catch (Exception e) {
                String errMsg = "Error when registering Web Finger Servlet via the HttpService.";
                log.error((Object)errMsg, (Throwable)e);
                throw new RuntimeException(errMsg, e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating the WebFingerServiceComponent", e);
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        WebFingerServiceComponentHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        WebFingerServiceComponentHolder.setRealmService(null);
    }

    @Reference(name="osgi.http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP Service is set in the OpenID Connect WebFinger bundle");
        }
        WebFingerServiceComponentHolder.setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP Service is unset in the OpenID Connect WebFinger bundle");
        }
        WebFingerServiceComponentHolder.setHttpService(null);
    }
}

