/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.webfinger.builders;

import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.discovery.DiscoveryUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.webfinger.WebFingerEndpointException;
import org.wso2.carbon.identity.webfinger.WebFingerRequest;
import org.wso2.carbon.identity.webfinger.WebFingerResponse;

public class WebFingerOIDCResponseBuilder {
    private static final Log log = LogFactory.getLog(WebFingerOIDCResponseBuilder.class);

    public WebFingerResponse buildWebFingerResponse(WebFingerRequest request) throws WebFingerEndpointException, ServerConfigurationException {
        String oidcIssuerLocation;
        try {
            oidcIssuerLocation = this.getOidcIssuerLocation(request.getTenant());
        }
        catch (URISyntaxException | IdentityOAuth2Exception e) {
            throw new ServerConfigurationException("Error while building discovery endpoint", e);
        }
        WebFingerResponse response = new WebFingerResponse();
        response.setSubject(request.getResource());
        response.addLink("http://openid.net/specs/connect/1.0/issuer", oidcIssuerLocation);
        return response;
    }

    private String getOidcIssuerLocation(String tenantDomain) throws IdentityOAuth2Exception, URISyntaxException {
        String oidcIssuerLocation = DiscoveryUtil.isUseEntityIdAsIssuerInOidcDiscovery() ? OAuth2Util.getIssuerLocation((String)tenantDomain) : OAuth2Util.OAuthURL.getOidcDiscoveryEPUrl((String)tenantDomain);
        return oidcIssuerLocation;
    }
}

