/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.webfinger.builders;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.webfinger.WebFingerEndpointException;
import org.wso2.carbon.identity.webfinger.WebFingerRequest;
import org.wso2.carbon.identity.webfinger.builders.WebFingerRequestBuilder;
import org.wso2.carbon.identity.webfinger.internal.WebFingerServiceComponentHolder;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultWebFingerRequestBuilder
implements WebFingerRequestBuilder {
    private static final Log log = LogFactory.getLog(DefaultWebFingerRequestBuilder.class);

    @Override
    public WebFingerRequest buildRequest(HttpServletRequest request) throws WebFingerEndpointException {
        String tenant;
        String userInfo;
        WebFingerRequest webFingerRequest = new WebFingerRequest();
        ArrayList parameters = Collections.list(request.getParameterNames());
        if (parameters.size() != 2 || !parameters.contains("rel") || !parameters.contains("resource")) {
            throw new WebFingerEndpointException("invalid_request", "Bad Web Finger request.");
        }
        webFingerRequest.setServletRequest(request);
        String resource = request.getParameter("resource");
        webFingerRequest.setRel(request.getParameter("rel"));
        webFingerRequest.setResource(resource);
        if (StringUtils.isBlank((String)resource)) {
            log.warn((Object)("Can't normalize null or empty URI: " + resource));
            throw new WebFingerEndpointException("invalid_resource", "Null or empty URI.");
        }
        URI resourceURI = URI.create(resource);
        if (StringUtils.isBlank((String)resourceURI.getScheme())) {
            throw new WebFingerEndpointException("Scheme of the resource cannot be empty");
        }
        if ("acct".equals(resourceURI.getScheme())) {
            userInfo = resourceURI.getSchemeSpecificPart();
            if (!userInfo.contains("@")) {
                throw new WebFingerEndpointException("invalid_request", "Invalid host value.");
            }
            userInfo = userInfo.substring(0, userInfo.lastIndexOf(64));
        } else {
            userInfo = resourceURI.getUserInfo();
            webFingerRequest.setScheme(resourceURI.getScheme());
            webFingerRequest.setHost(resourceURI.getHost());
            webFingerRequest.setPort(resourceURI.getPort());
            webFingerRequest.setPath(resourceURI.getPath());
            webFingerRequest.setQuery(resourceURI.getQuery());
        }
        if (StringUtils.isNotBlank((String)userInfo)) {
            try {
                userInfo = URLDecoder.decode(userInfo, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WebFingerEndpointException("Cannot decode the userinfo");
            }
            tenant = MultitenantUtils.getTenantDomain((String)userInfo);
            webFingerRequest.setUserInfo(resourceURI.getUserInfo());
        } else {
            tenant = "carbon.super";
        }
        DefaultWebFingerRequestBuilder.validateTenant(tenant);
        webFingerRequest.setTenant(tenant);
        return webFingerRequest;
    }

    public static void validateTenant(String tenantDomain) throws WebFingerEndpointException {
        try {
            int tenantId = WebFingerServiceComponentHolder.getRealmService().getTenantManager().getTenantId(tenantDomain);
            if (tenantId < 0 && tenantId != -1234) {
                throw new WebFingerEndpointException("invalid_resource", "The tenant domain is not valid.");
            }
        }
        catch (UserStoreException e) {
            throw new WebFingerEndpointException("invalid_resource", e.getMessage());
        }
    }
}

