/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.webfinger;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.webfinger.WebFingerEndpointException;
import org.wso2.carbon.identity.webfinger.WebFingerProcessor;
import org.wso2.carbon.identity.webfinger.WebFingerRequest;
import org.wso2.carbon.identity.webfinger.WebFingerResponse;
import org.wso2.carbon.identity.webfinger.builders.DefaultWebFingerRequestBuilder;
import org.wso2.carbon.identity.webfinger.builders.WebFingerOIDCResponseBuilder;

public class DefaultWebFingerProcessor
implements WebFingerProcessor {
    private static final Log log = LogFactory.getLog(DefaultWebFingerProcessor.class);
    private static DefaultWebFingerProcessor defaultWebFingerProcessor = new DefaultWebFingerProcessor();

    private DefaultWebFingerProcessor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing OIDCProcessor for OpenID connect discovery processor.");
        }
    }

    public static DefaultWebFingerProcessor getInstance() {
        return defaultWebFingerProcessor;
    }

    @Override
    public WebFingerResponse getResponse(HttpServletRequest request) throws WebFingerEndpointException, ServerConfigurationException {
        DefaultWebFingerRequestBuilder requestBuilder = new DefaultWebFingerRequestBuilder();
        WebFingerRequest requestObject = requestBuilder.buildRequest(request);
        WebFingerOIDCResponseBuilder responseBuilder = new WebFingerOIDCResponseBuilder();
        return responseBuilder.buildWebFingerResponse(requestObject);
    }

    @Override
    public int handleError(WebFingerEndpointException error) {
        String errorCode = error.getErrorCode();
        if ("invalid_request".equals(errorCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)error);
            }
            return 400;
        }
        if ("invalid_resource".equals(errorCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)error);
            }
            return 404;
        }
        if ("json_exception".equals(errorCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)error);
            }
            return 415;
        }
        if ("webfinger_configurations_not_set".equals(errorCode)) {
            log.error((Object)"Failed to find the WebFinger Configurations.", (Throwable)error);
            return 404;
        }
        log.error((Object)"Internal server error occured. ", (Throwable)error);
        return 500;
    }
}

