/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.flow.ui.client;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.flow.stub.client.EventFlowAdminServiceStub;

public class EventFlowAdminServiceClient {
    private static final Log log = LogFactory.getLog(EventFlowAdminServiceClient.class);
    private static final String BUNDLE = "org.wso2.carbon.event.flow.ui.i18n.Resources";
    private ResourceBundle bundle;
    public EventFlowAdminServiceStub stub;

    public EventFlowAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "EventFlowAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new EventFlowAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getEventFlow() throws AxisFault {
        try {
            return this.stub.getEventFlow();
        }
        catch (RemoteException e) {
            String msg = this.bundle.getString("Cannot load event flow");
            this.handleException(msg, e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

