/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.output.adapter.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;

public class ExtendedHTTPEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(ExtendedHTTPEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private static ExecutorService executorService;
    private String clientMethod;
    private int tenantId;
    private String contentType;
    private static HttpConnectionManager connectionManager;
    private static HttpClient httpClient;
    private HostConfiguration hostConfiguration = null;
    private AccessTokenGenerator accessTokenGenerator;
    private String oauthURL;

    public ExtendedHTTPEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.clientMethod = (String)eventAdapterConfiguration.getStaticProperties().get("http.client.method");
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
            int defaultMaxConnectionsPerHost = this.globalProperties.get("defaultMaxConnectionsPerHost") != null ? Integer.parseInt(this.globalProperties.get("defaultMaxConnectionsPerHost")) : 2;
            int maxTotalConnections = this.globalProperties.get("maxTotalConnections") != null ? Integer.parseInt(this.globalProperties.get("maxTotalConnections")) : 20;
            connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setDefaultMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
            connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
            Map staticProperties = this.eventAdapterConfiguration.getStaticProperties();
            if (staticProperties.get("oauth.consumer.key") != null) {
                this.accessTokenGenerator = new AccessTokenGenerator((String)staticProperties.get("oauth.url"), (String)staticProperties.get("oauth.consumer.key"), (String)staticProperties.get("oauth.consumer.secret"));
                this.oauthURL = (String)staticProperties.get("oauth.url");
            }
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
        this.checkHTTPClientInit(this.eventAdapterConfiguration.getStaticProperties());
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        block8: {
            String url = dynamicProperties.get("http.url");
            String username = dynamicProperties.get("http.username");
            String password = dynamicProperties.get("http.password");
            Map<String, String> headers = this.extractHeaders(dynamicProperties.get("http.headers"));
            String payload = message.toString();
            try {
                if (this.accessTokenGenerator != null) {
                    if (this.oauthURL == null) {
                        try {
                            URL endpointURL = new URL(url);
                            this.oauthURL = endpointURL.getProtocol() + "://" + endpointURL.getHost() + ":" + endpointURL.getPort();
                            this.accessTokenGenerator.setOauthUrl(this.oauthURL);
                        }
                        catch (MalformedURLException e) {
                            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Incorrect end point configurations", (Log)log, (int)this.tenantId);
                        }
                    }
                    String accessToken = this.accessTokenGenerator.getAccessToken();
                    executorService.execute(new HTTPSender(url, payload, accessToken, headers, httpClient));
                    break block8;
                }
                if (username != null && password != null) {
                    executorService.execute(new HTTPSender(url, payload, username, password, headers, httpClient));
                } else {
                    EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Incorrect publishing configurations", (Log)log, (int)this.tenantId);
                }
            }
            catch (RejectedExecutionException e) {
                EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
            }
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHTTPClientInit(Map<String, String> staticProperties) {
        if (httpClient != null) {
            return;
        }
        Class<ExtendedHTTPEventAdapter> clazz = ExtendedHTTPEventAdapter.class;
        synchronized (ExtendedHTTPEventAdapter.class) {
            String messageFormat;
            if (httpClient != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            httpClient = new HttpClient(connectionManager);
            String proxyHost = staticProperties.get("http.proxy.host");
            String proxyPort = staticProperties.get("http.proxy.port");
            if (proxyHost != null && proxyHost.trim().length() > 0) {
                try {
                    HttpHost host = new HttpHost(proxyHost, Integer.parseInt(proxyPort));
                    httpClient.getParams().setParameter("http.route.default-proxy", (Object)host);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid proxy port: " + proxyPort + ", ignoring proxy settings for HTTP output event adaptor."), (Throwable)e);
                }
            }
            this.contentType = "json".equalsIgnoreCase(messageFormat = this.eventAdapterConfiguration.getMessageFormat()) ? "application/json" : ("text".equalsIgnoreCase(messageFormat) ? "text/plain" : "text/xml");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private Map<String, String> extractHeaders(String headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        String[] entries = headers.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String header : entries) {
            String[] keyValue = header.split(":", 2);
            if (keyValue.length == 2) {
                result.put(keyValue[0].trim(), keyValue[1].trim());
                continue;
            }
            log.warn((Object)("Header property '" + header + "' is not defined in the correct format."));
        }
        return result;
    }

    static {
        httpClient = null;
    }

    class HTTPSender
    implements Runnable {
        private String url;
        private String payload;
        private String accessToken;
        private String userName;
        private String password;
        private Map<String, String> headers;
        private HttpClient httpClient;

        public HTTPSender(String url, String payload, String accessToken, Map<String, String> headers, HttpClient httpClient) {
            this.url = url;
            this.payload = payload;
            this.accessToken = accessToken;
            this.headers = headers;
            this.httpClient = httpClient;
        }

        public HTTPSender(String url, String payload, String userName, String password, Map<String, String> headers, HttpClient httpClient) {
            this.url = url;
            this.payload = payload;
            this.userName = userName;
            this.password = password;
            this.headers = headers;
            this.httpClient = httpClient;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPayload() {
            return this.payload;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object method = null;
            try {
                int statusCode;
                method = ExtendedHTTPEventAdapter.this.clientMethod.equalsIgnoreCase("HttpPut") ? new PutMethod(this.getUrl()) : new PostMethod(this.getUrl());
                if (ExtendedHTTPEventAdapter.this.hostConfiguration == null) {
                    URL hostUrl = new URL(this.getUrl());
                    ExtendedHTTPEventAdapter.this.hostConfiguration = new HostConfiguration();
                    ExtendedHTTPEventAdapter.this.hostConfiguration.setHost(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
                }
                method.setRequestEntity((RequestEntity)new StringRequestEntity(this.getPayload(), ExtendedHTTPEventAdapter.this.contentType, "UTF-8"));
                if (this.getAccessToken() != null && !this.getAccessToken().isEmpty()) {
                    method.setRequestHeader("Authorization", "Bearer " + this.getAccessToken());
                } else if (this.getUserName() != null && this.getPassword() != null) {
                    method.setRequestHeader("Authorization", "Basic " + Base64.encode((byte[])(this.getUserName() + ":" + this.getPassword()).getBytes()));
                }
                if (this.getHeaders() != null) {
                    for (Map.Entry entry : this.getHeaders().entrySet()) {
                        method.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if ((statusCode = this.getHttpClient().executeMethod(ExtendedHTTPEventAdapter.this.hostConfiguration, (HttpMethod)method)) == 401 && ExtendedHTTPEventAdapter.this.accessTokenGenerator != null) {
                    ExtendedHTTPEventAdapter.this.accessTokenGenerator.removeInvalidToken(new String[]{"default"});
                }
            }
            catch (IOException e) {
                EventAdapterUtil.logAndDrop((String)ExtendedHTTPEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.getPayload(), (String)("Cannot connect to " + this.getUrl()), (Throwable)e, (Log)log, (int)ExtendedHTTPEventAdapter.this.tenantId);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }
}

