/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class SynapseRegistriesRegistryStore
extends AbstractRegistryStore {
    public SynapseRegistriesRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        throw new UnsupportedOperationException("There is only one synapse registry and hence this method is unsupported, use the getElement('registryInfo') method to get the declared registry element");
    }

    public OMElement getElement() {
        return this.getElement("registryInfo");
    }

    @Override
    public OMElement getElement(String name) {
        OMElement synapseRegistryElem = null;
        String synapseRegistryPath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(synapseRegistryPath)) {
                synapseRegistryElem = this.getResourceAsElement(synapseRegistryPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the synapse registry info from the registry in path : " + synapseRegistryPath, (Exception)((Object)e));
        }
        return synapseRegistryElem;
    }

    public void persistElement(OMElement element, String fileName) {
        this.persistElement("registryInfo", element, fileName);
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.REGISTRY_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Persisting synapse registry to the registry");
            }
            String synapseRegistryPath = this.getConfigurationPath() + "/" + name;
            try {
                this.persistElement(element, synapseRegistryPath, null);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the synapse registry in the path : " + synapseRegistryPath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not a synapse registry");
        }
    }

    public void deleteElement() {
        this.deleteElement(this.getConfigurationPath());
    }

    @Override
    public void deleteElement(String name) {
        try {
            if (this.registry.resourceExists(name)) {
                this.registry.delete(name);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the synapse registry at path : " + name, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "synapse-registry";
    }
}

