/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerManager;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.debug.SynapseDebugInterface;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.deployers.InboundEndpointDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.inbound.endpoint.EndpointListenerLoader;
import org.wso2.carbon.inbound.endpoint.persistence.service.InboundEndpointPersistenceService;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.initializer.CarbonSynapseController;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationManager;
import org.wso2.carbon.mediation.initializer.handler.ProxyLogHandler;
import org.wso2.carbon.mediation.initializer.handler.SynapseExternalPropertyConfigurator;
import org.wso2.carbon.mediation.initializer.multitenancy.TenantServiceBusInitializer;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentServiceImpl;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsServiceImpl;
import org.wso2.carbon.mediation.initializer.utils.ConfigurationHolder;
import org.wso2.carbon.mediation.ntask.internal.NtaskService;
import org.wso2.carbon.mediation.registry.services.SynapseRegistryService;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.task.services.TaskDescriptionRepositoryService;
import org.wso2.carbon.task.services.TaskSchedulerService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="esb.core.initializer", immediate=true)
public class ServiceBusInitializer {
    private static final Log log = LogFactory.getLog(ServiceBusInitializer.class);
    private static RegistryService registryService;
    private static ConfigurationTrackingService configTrackingService;
    private static ServerConfigurationInformation configurationInformation;
    private static ApplicationManagerService applicationManager;
    private static String configPath;
    private ConfigurationContextService configCtxSvc;
    private SynapseRegistryService synRegSvc;
    private TaskDescriptionRepositoryService repositoryService;
    private TaskSchedulerService taskSchedulerService;
    private SecretCallbackHandlerService secretCallbackHandlerService;
    private static EventBroker eventBroker;
    private ServerManager serverManager;

    @Activate
    protected void activate(ComponentContext ctxt) {
        log.info((Object)"Starting ESB...");
        this.setHttpsProtForConsole();
        String javaTempDir = System.getProperty("java.io.tmpdir");
        String APP_UNZIP_DIR = javaTempDir.endsWith(File.separator) ? javaTempDir + "libs" : javaTempDir + File.separator + "libs";
        ServiceBusInitializer.cleanupTempDirectory(APP_UNZIP_DIR);
        try {
            BundleContext bndCtx = ctxt.getBundleContext();
            ConfigurationHolder.getInstance().setBundleContext(bndCtx);
            TenantServiceBusInitializer listener = new TenantServiceBusInitializer();
            bndCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)listener, null);
            ReentrantLock lock = new ReentrantLock();
            this.configCtxSvc.getServerConfigContext().getAxisConfiguration().addParameter("synapse.config.lock", (Object)lock);
            UserRegistry registry = registryService.getConfigSystemRegistry();
            ConfigurationManager configurationManager = new ConfigurationManager(registry, this.configCtxSvc.getServerConfigContext());
            configurationManager.init();
            if (eventBroker != null) {
                this.configCtxSvc.getServerConfigContext().setProperty("mediation.event.broker", (Object)eventBroker);
            }
            ServerContextInformation contextInfo = this.initESB(configurationManager.getTracker().getCurrentConfigurationName());
            ServiceRegistration synCfgRegistration = null;
            ServiceRegistration synEnvRegistration = null;
            if (contextInfo.getSynapseConfiguration() != null) {
                SynapseConfigurationServiceImpl synCfgSvc = new SynapseConfigurationServiceImpl(contextInfo.getSynapseConfiguration(), -1234, this.configCtxSvc.getServerConfigContext());
                synCfgRegistration = bndCtx.registerService(SynapseConfigurationService.class.getName(), (Object)synCfgSvc, null);
                this.initPersistence(synCfgSvc, configurationManager.getTracker().getCurrentConfigurationName());
                bndCtx.registerService(ServerShutdownHandler.class.getName(), (Object)new MPMShutdownHandler(synCfgSvc.getSynapseConfiguration().getAxisConfiguration()), null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseConfigurationService Registered");
                }
                if (configTrackingService != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Publishing the SynapseConfiguration to the ConfigurationTrackingService");
                    }
                    configTrackingService.setSynapseConfiguration(contextInfo.getSynapseConfiguration());
                }
            } else {
                this.handleFatal("Couldn't register the SynapseConfigurationService, SynapseConfiguration not found");
            }
            SynapseEnvironment synapseEnvironment = contextInfo.getSynapseEnvironment();
            if (synapseEnvironment != null) {
                SynapseEnvironmentServiceImpl synEnvSvc = new SynapseEnvironmentServiceImpl(synapseEnvironment, -1234, this.configCtxSvc.getServerConfigContext());
                synEnvRegistration = bndCtx.registerService(SynapseEnvironmentService.class.getName(), (Object)synEnvSvc, null);
                synapseEnvironment.registerSynapseHandler((SynapseHandler)new SynapseExternalPropertyConfigurator());
                synapseEnvironment.registerSynapseHandler((SynapseHandler)new ProxyLogHandler());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SynapseEnvironmentService Registered");
                }
            } else {
                this.handleFatal("Couldn't register the SynapseEnvironmentService, SynapseEnvironment not found");
            }
            SynapseRegistrationsServiceImpl synRegistrationsSvc = new SynapseRegistrationsServiceImpl(synCfgRegistration, synEnvRegistration, -1234, this.configCtxSvc.getServerConfigContext());
            bndCtx.registerService(SynapseRegistrationsService.class.getName(), (Object)synRegistrationsSvc, null);
            this.configCtxSvc.getServerConfigContext().setProperty("CONFIGURATION_MANAGER", (Object)configurationManager);
            EndpointListenerLoader.loadListeners();
            this.registerInboundDeployer(this.configCtxSvc.getServerConfigContext().getAxisConfiguration(), contextInfo.getSynapseEnvironment());
        }
        catch (Exception e) {
            this.handleFatal("Couldn't initialize the ESB...", e);
        }
        catch (Throwable t) {
            log.fatal((Object)"Failed to initialize ESB due to a fatal error", t);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        this.serverManager.stop();
        this.serverManager.shutdown();
    }

    private void initPersistence(SynapseConfigurationService synCfgSvc, String configName) throws RegistryException, AxisFault {
        ServerConfiguration serverConf = ServerConfiguration.getInstance();
        String persistence = serverConf.getFirstProperty("MediationConfig.Persistence");
        if (!"disabled".equals(persistence)) {
            String regPersistence = serverConf.getFirstProperty("MediationConfig.RegistryPersistence");
            UserRegistry registry = "enabled".equals(regPersistence) ? registryService.getConfigSystemRegistry() : null;
            String interval = serverConf.getFirstProperty("MediationConfig.WorkerInterval");
            long intervalInMillis = 5000L;
            if (interval != null && !"".equals(interval)) {
                try {
                    intervalInMillis = Long.parseLong(interval);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Invalid value " + interval + " specified for the mediation persistence worker interval, Using defaults"), (Throwable)e);
                }
            }
            MediationPersistenceManager pm = new MediationPersistenceManager(registry, configurationInformation.getSynapseXMLLocation(), synCfgSvc.getSynapseConfiguration(), intervalInMillis, configName);
            this.configCtxSvc.getServerConfigContext().getAxisConfiguration().addParameter(new Parameter("PERSISTENCE_MANAGER", (Object)pm));
        } else {
            log.info((Object)"Persistence for mediation configuration is disabled");
        }
    }

    private void setHttpsProtForConsole() {
        block11: {
            ServerConfiguration config = ServerConfiguration.getInstance();
            if (CarbonUtils.isRunningInStandaloneMode()) {
                String TRANSPORT_MANAGER = "org.wso2.carbon.tomcat.ext.transport.ServletTransportManager";
                try {
                    Class<?> transportManagerClass = Class.forName("org.wso2.carbon.tomcat.ext.transport.ServletTransportManager");
                    Object transportManager = transportManagerClass.newInstance();
                    Method method = transportManagerClass.getMethod("getPort", String.class);
                    int httpsPort = (Integer)method.invoke(transportManager, "https");
                    int httpPort = (Integer)method.invoke(transportManager, "http");
                    System.setProperty("carbon.https.port", Integer.toString(httpsPort));
                    System.setProperty("carbon.http.port", Integer.toString(httpPort));
                    System.setProperty("httpPort", Integer.toString(httpPort));
                    System.setProperty("httpsPort", Integer.toString(httpsPort));
                    config.setConfigurationProperty("RegistryHttpPort", Integer.toString(httpPort));
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Failed to load the transport manager class using reflection", (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)"failed to set ports http/https", (Throwable)e);
                }
            } else {
                String serverURL;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TransportManager implementation not found. Switching to webapp deployment mode. Reading HTTPS port from the carbon.xml.");
                }
                if ((serverURL = config.getFirstProperty("ServerURL")) != null) {
                    try {
                        URL url = new URL(serverURL);
                        if ("https".equals(url.getProtocol())) {
                            System.setProperty("carbon.https.port", String.valueOf(url.getPort()));
                            break block11;
                        }
                        log.warn((Object)("Invalid protocol " + url.getProtocol() + " in Carbon server URL"));
                    }
                    catch (MalformedURLException ex) {
                        log.error((Object)("Error while parsing the server URL " + serverURL), (Throwable)ex);
                    }
                } else {
                    log.warn((Object)"Server URL is not specified in the carbon.xml. Unable to set the HTTPS port as a system property");
                }
            }
        }
    }

    private ServerContextInformation initESB(String name) throws AxisFault {
        if (this.configCtxSvc != null && this.synRegSvc != null) {
            String synapseConfigsLocation;
            ConfigurationContext configContext = this.configCtxSvc.getServerConfigContext();
            log.info((Object)"Initializing Apache Synapse...");
            configurationInformation = ServerConfigurationInformationFactory.createServerConfigurationInformation((AxisConfiguration)configContext.getAxisConfiguration());
            if (System.getProperty("SynapseServerName") != null) {
                configurationInformation.setServerName(System.getProperty("SynapseServerName"));
            }
            if ((synapseConfigsLocation = configurationInformation.getSynapseXMLLocation()) != null) {
                configurationInformation.setSynapseXMLLocation(synapseConfigsLocation + File.separator + name);
            } else {
                configurationInformation.setSynapseXMLLocation("repository/deployment/server/synapse-configs" + name);
            }
            configurationInformation.setCreateNewInstance(false);
            configurationInformation.setServerControllerProvider(CarbonSynapseController.class.getName());
            if (ServiceBusInitializer.isRunningSamplesMode()) {
                if (System.getProperty("esb.sample") != null) {
                    configurationInformation.setSynapseXMLLocation("repository" + File.separator + "samples" + File.separator + "synapse_sample_" + System.getProperty("esb.sample") + ".xml");
                } else {
                    configurationInformation.setSynapseXMLLocation("samples" + File.separator + "service-bus" + File.separator + "synapse_sample_" + System.getProperty("ei.sample") + ".xml");
                }
            }
            this.serverManager = new ServerManager();
            ServerContextInformation contextInfo = new ServerContextInformation((Object)configContext, configurationInformation);
            if (this.taskSchedulerService != null) {
                TaskScheduler scheduler = this.taskSchedulerService.getTaskScheduler();
                contextInfo.addProperty("task_scheduler", (Object)scheduler);
            }
            if (this.repositoryService != null) {
                TaskDescriptionRepository repository = this.repositoryService.getTaskDescriptionRepository();
                contextInfo.addProperty("task_description_repository", (Object)repository);
            }
            if (this.secretCallbackHandlerService != null) {
                contextInfo.addProperty("SharedSecretCallbackHandler", (Object)this.secretCallbackHandlerService.getSecretCallbackHandler());
            }
            AxisConfiguration axisConf = configContext.getAxisConfiguration();
            axisConf.addParameter(new Parameter("SYNAPSE_CURRENT_CONFIGURATION", (Object)name));
            if (ServiceBusInitializer.isRunningDebugMode()) {
                log.info((Object)"ESB Started in Debug mode for super tenant");
                this.createSynapseDebugEnvironment(contextInfo);
            }
            this.serverManager.init(configurationInformation, contextInfo);
            this.serverManager.start();
            AxisServiceGroup serviceGroup = axisConf.getServiceGroup("__SynapseService");
            serviceGroup.addParameter("hiddenService", (Object)"true");
            return contextInfo;
        }
        this.handleFatal("Couldn't initialize Synapse, ConfigurationContext service or SynapseRegistryService is not available");
        return null;
    }

    private boolean isDefaultRegistryStructureCreated() {
        if (registryService != null) {
            try {
                Resource resource;
                UserRegistry registry = registryService.getConfigSystemRegistry();
                if (registry.resourceExists("/repository/esb/configuration") && (resource = registry.get("/repository/esb/configuration")) != null && "created".equals(resource.getProperty("defaultCollections"))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Default Registry structure of ESB has already been created");
                    }
                    return true;
                }
            }
            catch (RegistryException rege) {
                log.warn((Object)"Cannot determine whether the default registry structure of the ESB is created or not.", (Throwable)rege);
                return true;
            }
        }
        return false;
    }

    public static boolean isRunningSamplesMode() {
        return System.getProperty("esb.sample") != null || System.getProperty("ei.sample") != null;
    }

    public static boolean isRunningDebugMode() {
        String debugMode = System.getProperty("esb.debug");
        return "true".equals(debugMode) || "super".equals(debugMode);
    }

    public void createSynapseDebugEnvironment(ServerContextInformation contextInfo) {
        try {
            String carbonHome = System.getProperty("carbon.home");
            File synapseProperties = Paths.get(CarbonUtils.getCarbonConfigDirPath(), "synapse.properties").toFile();
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(synapseProperties);
            properties.load(inputStream);
            ((InputStream)inputStream).close();
            int event_port = Integer.parseInt(properties.getProperty("synapse.debugger.port.event"));
            int command_port = Integer.parseInt(properties.getProperty("synapse.debugger.port.command"));
            SynapseDebugInterface debugInterface = SynapseDebugInterface.getInstance();
            debugInterface.init(command_port, event_port);
            contextInfo.setServerDebugModeEnabled(true);
            contextInfo.setSynapseDebugInterface(debugInterface);
            SynapseDebugManager debugManager = SynapseDebugManager.getInstance();
            contextInfo.setSynapseDebugManager(debugManager);
            log.info((Object)"Synapse debug Environment created successfully");
        }
        catch (IOException ex) {
            log.error((Object)"Error while creating Synapse debug environment ", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.error((Object)"Error while creating Synapse debug environment ", (Throwable)ex);
        }
    }

    private void createDefaultRegistryStructure(Registry registry) {
        String[] defaultCollections = ServerConfiguration.getInstance().getProperties("DefaultESBRegistry.Item");
        if (defaultCollections.length == 0) {
            defaultCollections = new String[]{"esb-resources/endpoints", "esb-resources/sequences", "esb-resources/policy", "esb-resources/schema", "esb-resources/scripts", "esb-resources/wsdl", "esb-resources/xslt"};
        }
        for (String collectionName : defaultCollections) {
            RegistryEntry collectionEntry = registry.getRegistryEntry(collectionName);
            if (collectionEntry != null && "http://wso2.org/projects/esb/registry/types/folder".equals(collectionEntry.getType())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Collection named " + collectionName + " is there on the ESB registry, collection creation skipped"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating the collection " + collectionName + " on the ESB registry"));
            }
            registry.newResource(collectionName, true);
        }
        try {
            UserRegistry systemRegistry = registryService.getConfigSystemRegistry();
            if (systemRegistry.resourceExists("/repository/esb/configuration")) {
                Resource resource = systemRegistry.get("/repository/esb/configuration");
                resource.addProperty("defaultCollections", "created");
            } else {
                CollectionImpl collection = new CollectionImpl();
                collection.setPath("/repository/esb/configuration");
                collection.setProperty("defaultCollections", "created");
                systemRegistry.put("/repository/esb/configuration", (Resource)collection);
            }
        }
        catch (RegistryException rege) {
            log.warn((Object)"Couldn't persist the default ESB collections structure created action", (Throwable)rege);
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        registryService = regService;
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        registryService = null;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the ESB initialization process");
        }
        this.configCtxSvc = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the ESB environment");
        }
        this.configCtxSvc = null;
    }

    @Reference(name="synapse.registry.service", service=SynapseRegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSynapseRegistryService")
    protected void setSynapseRegistryService(SynapseRegistryService synapseRegistryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SynapseRegistryService bound to the ESB initialization process");
        }
        this.synRegSvc = synapseRegistryService;
    }

    protected void unsetSynapseRegistryService(SynapseRegistryService synapseRegistryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SynapseRegistryService unbound from the ESB environment");
        }
        this.synRegSvc = null;
    }

    @Reference(name="task.description.repository.service", service=TaskDescriptionRepositoryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskDescriptionRepositoryService")
    protected void setTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskDescriptionRepositoryService bound to the ESB initialization process");
        }
        this.repositoryService = repositoryService;
    }

    protected void unsetTaskDescriptionRepositoryService(TaskDescriptionRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskDescriptionRepositoryService unbound from the ESB environment");
        }
        this.repositoryService = null;
    }

    @Reference(name="task.scheduler.service", service=TaskSchedulerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskSchedulerService")
    protected void setTaskSchedulerService(TaskSchedulerService schedulerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskSchedulerService bound to the ESB initialization process");
        }
        this.taskSchedulerService = schedulerService;
    }

    protected void unsetTaskSchedulerService(TaskSchedulerService schedulerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TaskSchedulerService unbound from the ESB environment");
        }
        this.taskSchedulerService = null;
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService bound to the ESB initialization process");
        }
        this.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService unbound from the ESB environment");
        }
        this.secretCallbackHandlerService = null;
    }

    @Reference(name="application.manager", service=ApplicationManagerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAppManager")
    protected void setAppManager(ApplicationManagerService appService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CarbonApplicationService bound to the ESB initialization process");
        }
        applicationManager = appService;
    }

    protected void unsetAppManager(ApplicationManagerService appService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CarbonApplicationService unbound from the ESB environment");
        }
        applicationManager = null;
    }

    @Reference(name="config.tracking.service", service=ConfigurationTrackingService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigTrackingService")
    protected void setConfigTrackingService(ConfigurationTrackingService configTrackingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationTrackingService bound to the ESB initialization process");
        }
        ServiceBusInitializer.configTrackingService = configTrackingService;
    }

    protected void unsetConfigTrackingService(ConfigurationTrackingService configTrackingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationTrackingService unbound from the ESB environment");
        }
        ServiceBusInitializer.configTrackingService = null;
    }

    @Reference(name="eventbroker.service", service=EventBroker.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unSetEventBroker")
    protected void setEventBroker(EventBroker eventBroker) {
        ServiceBusInitializer.eventBroker = eventBroker;
    }

    protected void unSetEventBroker(EventBroker eventBroker) {
        ServiceBusInitializer.eventBroker = null;
    }

    @Reference(name="esbntask.taskservice", service=NtaskService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetTaskService")
    protected void setTaskService(NtaskService taskService) {
    }

    protected void unsetTaskService(NtaskService ntaskService) {
    }

    public static EventBroker getEventBroker() {
        return eventBroker;
    }

    public static ConfigurationTrackingService getConfigurationTrackingService() {
        return configTrackingService;
    }

    public static ApplicationManagerService getAppManager() {
        if (applicationManager == null) {
            String msg = "Before activating Mediation initializer service bundle, an instance of CarbonApplicationService should be in existance";
            log.error((Object)msg);
        }
        return applicationManager;
    }

    public static ServerConfigurationInformation getConfigurationInformation() {
        return configurationInformation;
    }

    protected static RegistryService getRegistryService() {
        return registryService;
    }

    protected static ServerConfigurationInformation getServerConfigurationInformation() {
        return configurationInformation;
    }

    private void handleFatal(String message) {
        log.fatal((Object)message);
    }

    private void handleFatal(String message, Exception e) {
        log.fatal((Object)message, (Throwable)e);
    }

    private static void cleanupTempDirectory(String appUnzipDir) {
        File tempDirector = new File(appUnzipDir);
        if (tempDirector.isDirectory()) {
            File[] entries = tempDirector.listFiles();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                try {
                    FileUtils.deleteDirectory((File)entries[i]);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)("Could not build lib artifact for path : " + entries[i].getAbsolutePath()));
                }
            }
        }
    }

    private void registerInboundDeployer(AxisConfiguration axisConfig, SynapseEnvironment synEnv) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synEnv.getSynapseConfiguration().getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath(synEnv.getServerContextInformation());
        String inboundDirPath = synapseConfigPath + File.separator + "inbound-endpoints";
        for (InboundEndpoint inboundEndpoint : synEnv.getSynapseConfiguration().getInboundEndpoints()) {
            if (inboundEndpoint.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(inboundDirPath + File.separator + inboundEndpoint.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new InboundEndpointDeployer(), inboundDirPath, "xml");
    }

    @Reference(name="inbound.endpoint.persistence.service", service=InboundEndpointPersistenceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetInboundPersistenceService")
    protected void setInboundPersistenceService(InboundEndpointPersistenceService inboundEndpoint) {
    }

    protected void unsetInboundPersistenceService(InboundEndpointPersistenceService inboundEndpoint) {
    }

    public class MPMShutdownHandler
    implements ServerShutdownHandler {
        private AxisConfiguration configuration;

        public MPMShutdownHandler(AxisConfiguration configuration) {
            this.configuration = configuration;
        }

        public void invoke() {
            Parameter p = this.configuration.getParameter("PERSISTENCE_MANAGER");
            if (p != null && p.getValue() instanceof MediationPersistenceManager) {
                ((MediationPersistenceManager)p.getValue()).destroy();
            }
        }
    }
}

