/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.spaces;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.spaces.Space;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spaces {
    public static final String FABRIC8_SPACES = "fabric8-spaces";
    private static final transient Logger LOG = LoggerFactory.getLogger(Spaces.class);
    private final Map<String, Space> environments;

    public Spaces(Map<String, Space> environments) {
        this.environments = environments;
    }

    public static Spaces load(KubernetesClient kubernetesClient, String namespace) {
        namespace = Spaces.getDefaultNamespace(kubernetesClient, namespace);
        LOG.debug("Loading spaces from namespace: " + namespace);
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)kubernetesClient.configMaps().inNamespace(namespace)).withName(FABRIC8_SPACES)).get();
        return Spaces.load(configMap);
    }

    protected static String getDefaultNamespace(KubernetesClient kubernetesClient, String namespace) {
        if (Strings.isNullOrBlank((String)namespace) && Strings.isNullOrBlank((String)(namespace = kubernetesClient.getNamespace()))) {
            namespace = KubernetesHelper.defaultNamespace();
        }
        return namespace;
    }

    private static Spaces load(ConfigMap configMap) {
        Map<String, String> data;
        HashMap<String, Space> environmentMap = new HashMap<String, Space>();
        if (configMap != null && (data = configMap.getData()) != null) {
            Set<Map.Entry<String, String>> entries = data.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String yaml;
                String key = entry.getKey();
                Space environment = Spaces.parseSpace(key, yaml = entry.getValue());
                if (environment == null) continue;
                environmentMap.put(key, environment);
            }
        }
        return new Spaces(environmentMap);
    }

    private static Space parseSpace(String key, String yaml) {
        try {
            return KubernetesHelper.loadYaml(yaml, Space.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to parse space YAML for " + key + ". Reason: " + e + ". YAML: " + yaml, (Throwable)e);
            return null;
        }
    }

    public Space getSpace(String key) {
        return this.environments.get(key);
    }

    public Map<String, Space> getSpaces() {
        return this.environments;
    }

    public SortedSet<Space> getSpaceSet() {
        return new TreeSet<Space>(this.environments.values());
    }
}

