/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builds;

import io.fabric8.kubernetes.api.builds.BuildFinishedEvent;
import io.fabric8.kubernetes.api.builds.BuildListener;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildWatcher.class);
    private final OpenShiftClient client;
    private final BuildListener buildListener;
    private final String namespace;
    private final String fabric8ConsoleLink;
    private boolean loading = true;
    private Set<String> seenBuildIds = Collections.synchronizedSet(new HashSet());

    public BuildWatcher(OpenShiftClient client, BuildListener buildListener, String namespace, String fabric8ConsoleLink) {
        this.client = client;
        this.buildListener = buildListener;
        this.namespace = namespace;
        this.fabric8ConsoleLink = fabric8ConsoleLink;
    }

    public TimerTask schedule(long delay) {
        Timer timer = new Timer();
        return this.schedule(timer, delay);
    }

    public TimerTask schedule(Timer timer, long delay) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                BuildWatcher.this.poll();
            }
        };
        timer.schedule(task, delay, delay);
        return task;
    }

    public void poll() {
        List<Build> items;
        boolean foundBuild = false;
        BuildList buildList = (BuildList)((NonNamespaceOperation)this.client.builds().inNamespace(this.namespace)).list();
        if (buildList != null && (items = buildList.getItems()) != null) {
            for (Build build : items) {
                this.buildPolled(build);
                foundBuild = true;
            }
        }
        if (foundBuild) {
            this.loading = false;
        }
    }

    protected void buildPolled(Build build) {
        String status = build.getStatus().getPhase();
        if (status != null && Builds.isFinished(status)) {
            String uid = Builds.getUid(build);
            if (Strings.isNullOrBlank((String)uid)) {
                LOG.warn("Ignoring bad build which has no UID: " + build);
            } else if (this.seenBuildIds.add(uid)) {
                String name = Builds.getName(build);
                String buildLink = Builds.createConsoleBuildLink(this.fabric8ConsoleLink, name);
                BuildFinishedEvent event = new BuildFinishedEvent(uid, build, this.loading, buildLink);
                this.buildListener.onBuildFinished(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        Object lock = new Object();
        while (true) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

