/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.UserConfigurationCompare;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftNotAvailableException;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import io.fabric8.utils.Files;
import io.fabric8.utils.IOHelpers;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetesClient;
    private boolean throwExceptionOnError = true;
    private boolean allowCreate = true;
    private boolean recreateMode;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean ignoreBoundPersistentVolumeClaims = true;
    private boolean rollingUpgrade;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean failOnMissingParameterValue;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;
    private String namesapce = KubernetesHelper.defaultNamespace();
    private boolean requireSecretsCreatedBeforeReplicationControllers;
    private boolean rollingUpgradePreserveScale = true;

    public Controller() {
        this(new DefaultKubernetesClient());
    }

    public Controller(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public String apply(File file) throws Exception {
        String ext = Files.getFileExtension((File)file);
        if ("yaml".equalsIgnoreCase(ext)) {
            return this.applyYaml(file);
        }
        if ("json".equalsIgnoreCase(ext)) {
            return this.applyJson(file);
        }
        throw new IllegalArgumentException("Unknown file type " + ext);
    }

    public String applyJson(byte[] json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(String yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(File yaml) throws Exception {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    private String convertYamlToJson(String yamlString) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlString);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private String convertYamlToJson(File yamlFile) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlFile);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public String applyJson(InputStream json) throws Exception {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) throws Exception {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    LOG.warn("Found recursive nested object for " + dto + " of class: " + dto.getClass().getName());
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    public void applyEntity(Object dto, String sourceName) throws Exception {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)dto;
            OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
            if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("apps.openshift.io")) {
                this.applyResource(resource, sourceName, openShiftClient.deploymentConfigs());
            } else {
                LOG.warn("Not connected to OpenShift cluster so cannot apply entity " + dto);
            }
        } else if (dto instanceof PolicyBinding) {
            this.applyPolicyBinding((PolicyBinding)dto, sourceName);
        } else if (dto instanceof RoleBinding) {
            this.applyRoleBinding((RoleBinding)dto, sourceName);
        } else if (dto instanceof Role) {
            Role resource = (Role)dto;
            OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
            if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("authorization.openshift.io")) {
                this.applyResource((HasMetadata)resource, sourceName, (MixedOperation)openShiftClient.roles());
            } else {
                LOG.warn("Not connected to OpenShift cluster so cannot apply entity " + dto);
            }
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof ServiceAccount) {
            this.applyServiceAccount((ServiceAccount)dto, sourceName);
        } else if (dto instanceof Secret) {
            this.applySecret((Secret)dto, sourceName);
        } else if (dto instanceof ConfigMap) {
            this.applyResource((ConfigMap)dto, sourceName, this.kubernetesClient.configMaps());
        } else if (dto instanceof DaemonSet) {
            this.applyResource((HasMetadata)((DaemonSet)dto), sourceName, (MixedOperation)this.kubernetesClient.extensions().daemonSets());
        } else if (dto instanceof Deployment) {
            this.applyResource((HasMetadata)((Deployment)dto), sourceName, (MixedOperation)this.kubernetesClient.extensions().deployments());
        } else if (dto instanceof ReplicaSet) {
            this.applyResource((HasMetadata)((ReplicaSet)dto), sourceName, (MixedOperation)this.kubernetesClient.extensions().replicaSets());
        } else if (dto instanceof StatefulSet) {
            this.applyResource((HasMetadata)((StatefulSet)dto), sourceName, (MixedOperation)this.kubernetesClient.apps().statefulSets());
        } else if (dto instanceof Ingress) {
            this.applyResource((Ingress)dto, sourceName, this.kubernetesClient.extensions().ingresses());
        } else if (dto instanceof PersistentVolumeClaim) {
            this.applyPersistentVolumeClaim((PersistentVolumeClaim)dto, sourceName);
        } else if (dto instanceof HasMetadata) {
            HasMetadata entity = (HasMetadata)dto;
            try {
                String namespace = this.getNamespace();
                String resourceNamespace = this.getNamespace(entity);
                if (Strings.isNotBlank((String)namespace) && Strings.isNullOrBlank((String)resourceNamespace)) {
                    KubernetesHelper.getOrCreateMetadata(entity).setNamespace(namespace);
                }
                LOG.info("Applying " + KubernetesHelper.getKind(entity) + " " + KubernetesHelper.getName(entity) + " from " + sourceName);
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource(entity).inNamespace(namespace)).createOrReplace();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + KubernetesHelper.getKind(entity) + " from " + sourceName + ". " + e, e);
            }
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("oauth.openshift.io") && this.supportOAuthClients) {
            String id = KubernetesHelper.getName(entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring OAuthClient: " + id);
                return;
            }
            OAuthClient old = (OAuthClient)((Resource)openShiftClient.oAuthClients().withName(id)).get();
            if (this.isRunning(old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    LOG.info("Not updating the OAuthClient which are shared across namespaces as its already running");
                    return;
                }
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("OAuthClient has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    ((Resource)openShiftClient.oAuthClients().withName(id)).delete();
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        Object answer = ((Resource)openShiftClient.oAuthClients().withName(id)).replace(entity);
                        LOG.info("Updated OAuthClient result: " + answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating an OAuthClient from " + sourceName + " name " + KubernetesHelper.getName(entity));
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("oauth.openshift.io")) {
            Object result = null;
            try {
                result = openShiftClient.oAuthClients().create(entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public Object applyTemplate(Template entity, String sourceName) throws Exception {
        this.installTemplate(entity, sourceName);
        return this.processTemplate(entity, sourceName);
    }

    public void installTemplate(Template entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient == null || !openShiftClient.supportsOpenShiftAPIGroup("template.openshift.io")) {
            return;
        }
        if (!this.isProcessTemplatesLocally()) {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName(entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            Template old = (Template)((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning(old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("Template has not changed so not doing anything");
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateTemplate(entity, namespace, sourceName);
                    } else {
                        LOG.info("Updating a Template from " + sourceName);
                        try {
                            Object answer = ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).withName(id)).replace(entity);
                            LOG.info("Updated Template: " + answer);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update Template from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(entity));
            } else {
                this.doCreateTemplate(entity, namespace, sourceName);
            }
        }
    }

    public OpenShiftClient getOpenShiftClientOrNull() {
        OpenShiftClient openShiftClient = null;
        if (this.kubernetesClient instanceof OpenShiftClient) {
            openShiftClient = (OpenShiftClient)this.kubernetesClient;
        }
        if (openShiftClient == null) {
            try {
                openShiftClient = this.kubernetesClient.adapt(OpenShiftClient.class);
            }
            catch (KubernetesClientException kubernetesClientException) {
            }
            catch (OpenShiftNotAvailableException openShiftNotAvailableException) {
                // empty catch block
            }
        }
        return openShiftClient;
    }

    public OpenShiftClient getOpenShiftClientOrJenkinshift() {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient == null) {
            String jenkinshiftUrl = Systems.getEnvVar((String)"JENKINSHIFT_URL", (String)"http://jenkinshift/");
            LOG.debug("Using jenknshift URL: " + jenkinshiftUrl);
            openShiftClient = KubernetesHelper.createJenkinshiftOpenShiftClient(jenkinshiftUrl);
        }
        return openShiftClient;
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("template.openshift.io")) {
            LOG.info("Creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(entity));
            try {
                Object answer = ((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).create(entity);
                this.logGeneratedEntity("Created Template: ", namespace, entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to Template entity from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyServiceAccount(ServiceAccount serviceAccount, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(serviceAccount);
        Objects.notNull((Object)id, (String)("No name for " + serviceAccount + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring ServiceAccount: " + id);
            return;
        }
        ServiceAccount old = (ServiceAccount)((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(serviceAccount, old)) {
                LOG.info("ServiceAccount has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).delete();
                this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
            } else {
                LOG.info("Updating a ServiceAccount from " + sourceName);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).withName(id)).replace(serviceAccount);
                    this.logGeneratedEntity("Updated ServiceAccount: ", namespace, serviceAccount, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(serviceAccount));
        } else {
            this.doCreateServiceAccount(serviceAccount, namespace, sourceName);
        }
    }

    protected void doCreateServiceAccount(ServiceAccount serviceAccount, String namespace, String sourceName) {
        LOG.info("Creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(serviceAccount));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).create(serviceAccount) : ((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(this.getNamespace())).create(serviceAccount);
            this.logGeneratedEntity("Created ServiceAccount: ", namespace, serviceAccount, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
        }
    }

    public void applyPersistentVolumeClaim(PersistentVolumeClaim entity, String sourceName) throws Exception {
        boolean alwaysRecreate = true;
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(entity);
        Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring PersistentVolumeClaim: " + id);
            return;
        }
        PersistentVolumeClaim old = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(entity, old)) {
                LOG.info("PersistentVolumeClaim has not changed so not doing anything");
            } else if (alwaysRecreate || this.isRecreateMode()) {
                if (!this.isRecreateMode() && this.isIgnoreBoundPersistentVolumeClaims() && this.isBound(old)) {
                    LOG.warn("PersistentVolumeClaim " + id + " in namespace " + namespace + " is already bound and will not be replaced with the new one from " + sourceName);
                } else {
                    LOG.info("Deleting PersistentVolumeClaim from namespace " + namespace + " with name " + id);
                    ((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).withName(id)).delete();
                    LOG.info("Deleted PersistentVolumeClaim from namespace " + namespace + " with name " + id);
                    this.doCreatePersistentVolumeClaim(entity, namespace, sourceName);
                }
            } else {
                LOG.info("Updating a PersistentVolumeClaim from " + sourceName);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).withName(id)).replace(entity);
                    this.logGeneratedEntity("Updated PersistentVolumeClaim: ", namespace, entity, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update PersistentVolumeClaim from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a PersistentVolumeClaim from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(entity));
        } else {
            this.doCreatePersistentVolumeClaim(entity, namespace, sourceName);
        }
    }

    protected void doCreatePersistentVolumeClaim(PersistentVolumeClaim entity, String namespace, String sourceName) {
        LOG.info("Creating a PersistentVolumeClaim from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(entity));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).create(entity) : ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(this.getNamespace())).create(entity);
            this.logGeneratedEntity("Created PersistentVolumeClaim: ", namespace, entity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create PersistentVolumeClaim from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applySecret(Secret secret, String sourceName) throws Exception {
        String namespace = this.getNamespace(secret);
        String id = KubernetesHelper.getName(secret);
        Objects.notNull((Object)id, (String)("No name for " + secret + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Secrets: " + id);
            return;
        }
        Secret old = (Secret)((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(secret, old)) {
                LOG.info("Secret has not changed so not doing anything");
                return;
            }
            if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).delete();
                this.doCreateSecret(secret, namespace, sourceName);
            } else {
                LOG.info("Updating a Secret from " + sourceName);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withName(id)).replace(secret);
                    this.logGeneratedEntity("Updated Secret:", namespace, secret, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update secret from " + sourceName + ". " + e + ". " + secret, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(secret));
        } else {
            this.doCreateSecret(secret, namespace, sourceName);
        }
    }

    protected void doCreateSecret(Secret secret, String namespace, String sourceName) {
        LOG.info("Creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(secret));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create(secret) : ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(this.getNamespace())).create(secret);
            this.logGeneratedEntity("Created Secret: ", namespace, secret, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Secret from " + sourceName + ". " + e + ". " + secret, e);
        }
    }

    protected void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File namespaceDir = new File(this.logJsonDir, namespace);
            namespaceDir.mkdirs();
            String kind = KubernetesHelper.getKind(entity);
            String name = KubernetesHelper.getName(entity);
            if (Strings.isNotBlank((String)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (Strings.isNullOrBlank((String)name)) {
                LOG.warn("No name for the entity " + entity);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(namespaceDir, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(namespaceDir, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = KubernetesHelper.toJson(result);
                    }
                    catch (JsonProcessingException e) {
                        LOG.warn("Cannot convert " + result + " to JSON: " + (Object)((Object)e), (Throwable)e);
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    IOHelpers.writeFully((File)file, (String)text);
                    Object fileLocation = file;
                    if (this.basedir != null && (path = Files.getRelativePath((File)this.basedir, (File)file)) != null) {
                        fileLocation = Strings.stripPrefix((String)path, (String)"/");
                    }
                    LOG.info(message + fileLocation);
                }
                catch (IOException e) {
                    LOG.warn("Failed to write to file " + file + ". " + e, (Throwable)e);
                }
                return;
            }
        }
        LOG.info(message + result);
    }

    public Object processTemplate(Template entity, String sourceName) {
        try {
            return Templates.processTemplatesLocally(entity, this.failOnMissingParameterValue);
        }
        catch (IOException e) {
            this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
            return null;
        }
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource != null) {
            LOG.debug("  " + kubeResource.getClass().getSimpleName() + " " + kubeResource);
        }
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName(template);
            LOG.info("  Template " + id + " " + KubernetesHelper.summaryText(template));
            this.printSummary(template.getObjects());
            return;
        }
        List<HasMetadata> list = KubernetesHelper.toItemList(kubeResource);
        for (HasMetadata object : list) {
            if (object == null) continue;
            if (object == list) {
                LOG.debug("Ignoring recursive list " + list);
                continue;
            }
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            LOG.info("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object));
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("route.openshift.io")) {
            Route route;
            String id = KubernetesHelper.getName(entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace(entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            if ((route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(id)).get()) == null) {
                try {
                    LOG.info("Creating Route " + namespace + ":" + id + " " + KubernetesHelper.summaryText(entity));
                    ((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).create(entity);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName(entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace(entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            BuildConfig old = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning(old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("BuildConfig has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    LOG.info("Deleting BuildConfig: " + id);
                    ((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).delete();
                    this.doCreateBuildConfig(entity, namespace, sourceName);
                } else {
                    LOG.info("Updating BuildConfig from " + sourceName);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion(old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        Object answer = ((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(id)).replace(entity);
                        this.logGeneratedEntity("Updated BuildConfig: ", namespace, entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update BuildConfig from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(entity));
            } else {
                this.doCreateBuildConfig(entity, namespace, sourceName);
            }
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create(entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyRoleBinding(RoleBinding entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            RoleBinding old = (RoleBinding)((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("RoleBinding has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    LOG.info("Deleting RoleBinding: " + id);
                    ((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).delete();
                    this.doCreateRoleBinding(entity, namespace, sourceName);
                } else {
                    LOG.info("Updating RoleBinding from " + sourceName);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        Object answer = ((Resource)((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).withName(id)).replace(entity);
                        this.logGeneratedEntity("Updated RoleBinding: ", namespace, (HasMetadata)entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update RoleBinding from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating RoleBinding from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreateRoleBinding(entity, namespace, sourceName);
            }
        }
    }

    public void doCreateRoleBinding(RoleBinding entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.roleBindings().inNamespace(namespace)).create(entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create RoleBinding from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyPolicyBinding(PolicyBinding entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.notNull((Object)id, (String)("No name for " + entity + " " + sourceName));
            String namespace = KubernetesHelper.getNamespace((HasMetadata)entity);
            if (Strings.isNullOrBlank((String)namespace)) {
                namespace = this.getNamespace();
            }
            this.applyNamespace(namespace);
            PolicyBinding old = (PolicyBinding)((Resource)((NonNamespaceOperation)openShiftClient.policyBindings().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual(entity, old)) {
                    LOG.info("PolicyBinding has not changed so not doing anything");
                } else if (this.isRecreateMode()) {
                    LOG.info("Deleting PolicyBinding: " + id);
                    ((Resource)((NonNamespaceOperation)openShiftClient.policyBindings().inNamespace(namespace)).withName(id)).delete();
                    this.doCreatePolicyBinding(entity, namespace, sourceName);
                } else {
                    LOG.info("Updating PolicyBinding from " + sourceName);
                    try {
                        String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                        metadata.setNamespace(namespace);
                        metadata.setResourceVersion(resourceVersion);
                        Object answer = ((Resource)((NonNamespaceOperation)openShiftClient.policyBindings().inNamespace(namespace)).withName(id)).replace(entity);
                        this.logGeneratedEntity("Updated PolicyBinding: ", namespace, (HasMetadata)entity, answer);
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update PolicyBinding from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating PolicyBinding from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity));
            } else {
                this.doCreatePolicyBinding(entity, namespace, sourceName);
            }
        }
    }

    public void doCreatePolicyBinding(PolicyBinding entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrJenkinshift();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.policyBindings().inNamespace(namespace)).create(entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create PolicyBinding from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClientOrNull();
        if (openShiftClient != null && openShiftClient.supportsOpenShiftAPIGroup("image.openshift.io")) {
            String kind = KubernetesHelper.getKind(entity);
            String name = KubernetesHelper.getName(entity);
            String namespace = this.getNamespace();
            try {
                Resource resource = (Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(namespace)).withName(name);
                ImageStream old = (ImageStream)resource.get();
                if (old == null) {
                    LOG.info("Creating " + kind + " " + name + " from " + sourceName);
                    resource.create(entity);
                } else {
                    LOG.info("Updating " + kind + " " + name + " from " + sourceName);
                    this.copyAllImageStreamTags(entity, old);
                    resource.replace(old);
                }
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)openShiftClient.resource(entity).inNamespace(namespace)).apply();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e, e);
            }
        }
    }

    protected void copyAllImageStreamTags(ImageStream from, ImageStream to) {
        List<TagReference> fromTags;
        ImageStreamSpec fromSpec;
        List<TagReference> toTags;
        ImageStreamSpec toSpec = to.getSpec();
        if (toSpec == null) {
            toSpec = new ImageStreamSpec();
            to.setSpec(toSpec);
        }
        if ((toTags = toSpec.getTags()) == null) {
            toTags = new ArrayList<TagReference>();
            toSpec.setTags(toTags);
        }
        if ((fromSpec = from.getSpec()) != null && (fromTags = fromSpec.getTags()) != null) {
            for (TagReference tag : fromTags) {
                this.removeTagByName(toTags, tag.getName());
            }
            for (TagReference tag : fromTags) {
                toTags.add(tag);
            }
        }
    }

    private int removeTagByName(List<TagReference> tags, String tagName) {
        ArrayList<TagReference> removeTags = new ArrayList<TagReference>();
        for (TagReference tag : tags) {
            if (!Objects.equal((Object)tagName, (Object)tag.getName())) continue;
            removeTags.add(tag);
        }
        tags.removeAll(removeTags);
        return removeTags.size();
    }

    public void applyList(KubernetesList list, String sourceName) throws Exception {
        List<HasMetadata> entities = list.getItems();
        if (entities != null) {
            for (HasMetadata entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(service);
        Objects.notNull((Object)id, (String)("No name for " + service + " " + sourceName));
        if (this.isIgnoreServiceMode()) {
            LOG.debug("Ignoring Service: " + namespace + ":" + id);
            return;
        }
        Service old = (Service)((Resource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(service, old)) {
                LOG.info("Service has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting Service: " + id);
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).delete();
                this.doCreateService(service, namespace, sourceName);
            } else {
                LOG.info("Updating a Service from " + sourceName);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(id)).replace(service);
                    this.logGeneratedEntity("Updated Service: ", namespace, service, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Service from " + sourceName + ". " + e + ". " + service, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(service));
        } else {
            this.doCreateService(service, namespace, sourceName);
        }
    }

    public <T extends HasMetadata, L, D> void applyResource(T resource, String sourceName, MixedOperation<T, L, D, ? extends Resource<T, D>> resources) throws Exception {
        String namespace = this.getNamespace();
        String resourceNamespace = this.getNamespace(resource);
        if (Strings.isNotBlank((String)namespace) && Strings.isNullOrBlank((String)resourceNamespace)) {
            KubernetesHelper.getOrCreateMetadata(resource).setNamespace(namespace);
        }
        String id = KubernetesHelper.getName(resource);
        String kind = KubernetesHelper.getKind(resource);
        Objects.notNull((Object)id, (String)("No name for " + resource + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Ignoring " + kind + ": " + namespace + ":" + id);
            return;
        }
        HasMetadata old = (HasMetadata)((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(resource, old)) {
                LOG.info(kind + " has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting " + kind + ": " + id);
                ((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).delete();
                this.doCreateResource(resource, namespace, sourceName, resources);
            } else {
                LOG.info("Updating " + kind + " from " + sourceName);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)resources.inNamespace(namespace)).withName(id)).replace(resource);
                    this.logGeneratedEntity("Updated " + kind + ": ", namespace, resource, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource));
        } else {
            this.doCreateResource(resource, namespace, sourceName, resources);
        }
    }

    protected <T extends HasMetadata, L, D> void doCreateResource(T resource, String namespace, String sourceName, MixedOperation<T, L, D, ? extends Resource<T, D>> resources) throws Exception {
        String kind = KubernetesHelper.getKind(resource);
        LOG.info("Creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)resources.inNamespace(namespace)).create(resource) : ((NonNamespaceOperation)resources.inNamespace(this.getNamespace())).create(resource);
            this.logGeneratedEntity("Created " + kind + ": ", namespace, resource, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        LOG.info("Creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(service));
        try {
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create(service) : ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.getNamespace())).create(service);
            this.logGeneratedEntity("Created Service: ", namespace, service, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public boolean checkNamespace(String namespaceName) {
        if (Strings.isNullOrBlank((String)namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClientOrNull();
        if (openshiftClient != null && openshiftClient.supportsOpenShiftAPIGroup("project.openshift.io")) {
            return ((ProjectList)openshiftClient.projects().list()).getItems().stream().map(project -> project.getMetadata().getName()).anyMatch(Predicate.isEqual(namespaceName));
        }
        return ((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).get() != null;
    }

    public boolean deleteNamespace(String namespaceName) {
        if (!this.checkNamespace(namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClientOrNull();
        if (openshiftClient != null && openshiftClient.supportsOpenShiftAPIGroup("project.openshift.io")) {
            return (Boolean)((Resource)openshiftClient.projects().withName(namespaceName)).delete();
        }
        return (Boolean)((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).delete();
    }

    public void applyNamespace(String namespaceName) {
        this.applyNamespace(namespaceName, null);
    }

    public void applyNamespace(String namespaceName, Map<String, String> labels) {
        if (Strings.isNullOrBlank((String)namespaceName)) {
            return;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClientOrNull();
        if (openshiftClient != null && openshiftClient.supportsOpenShiftAPIGroup("project.openshift.io")) {
            ProjectRequest entity = new ProjectRequest();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
            metadata.setName(namespaceName);
            String namespace = this.kubernetesClient.getNamespace();
            if (Strings.isNotBlank((String)namespace)) {
                Map<String, String> entityLabels = KubernetesHelper.getOrCreateLabels(entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", namespace);
                }
            }
            this.applyProjectRequest(entity);
        } else {
            Namespace entity = new Namespace();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
            metadata.setName(namespaceName);
            String namespace = this.kubernetesClient.getNamespace();
            if (Strings.isNotBlank((String)namespace)) {
                Map<String, String> entityLabels = KubernetesHelper.getOrCreateLabels(entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", namespace);
                }
            }
            this.applyNamespace(entity);
        }
    }

    public boolean applyNamespace(Namespace entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata(entity).getName();
        LOG.info("Using namespace: " + namespace);
        String name = KubernetesHelper.getName(entity);
        Objects.notNull((Object)name, (String)("No name for " + entity));
        Namespace old = (Namespace)((Resource)this.kubernetesClient.namespaces().withName(name)).get();
        if (!this.isRunning(old)) {
            try {
                Object answer = this.kubernetesClient.namespaces().create(entity);
                this.logGeneratedEntity("Created namespace: ", namespace, entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create namespace: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public boolean applyProjectRequest(ProjectRequest entity) {
        String namespace = KubernetesHelper.getOrCreateMetadata(entity).getName();
        LOG.info("Using project: " + namespace);
        String name = KubernetesHelper.getName(entity);
        Objects.notNull((Object)name, (String)("No name for " + entity));
        OpenShiftClient openshiftClient = this.getOpenShiftClientOrNull();
        if (openshiftClient == null || !openshiftClient.supportsOpenShiftAPIGroup("project.openshift.io")) {
            LOG.warn("Cannot check for Project " + namespace + " as not running against OpenShift!");
            return false;
        }
        boolean exists = this.checkNamespace(name);
        if (!exists) {
            try {
                Object answer = openshiftClient.projectrequests().create(entity);
                this.logGeneratedEntity("Created ProjectRequest: ", namespace, entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create ProjectRequest: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) throws Exception {
        block15: {
            String namespace = this.getNamespace();
            String id = KubernetesHelper.getName(replicationController);
            Objects.notNull((Object)id, (String)("No name for " + replicationController + " " + sourceName));
            if (this.isServicesOnlyMode()) {
                LOG.debug("Only processing Services right now so ignoring ReplicationController: " + namespace + ":" + id);
                return;
            }
            ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).get();
            if (this.isRunning(old)) {
                if (UserConfigurationCompare.configEqual(replicationController, old)) {
                    LOG.info("ReplicationController has not changed so not doing anything");
                } else {
                    ReplicationControllerSpec newSpec = replicationController.getSpec();
                    ReplicationControllerSpec oldSpec = old.getSpec();
                    if (this.rollingUpgrade) {
                        Integer replicas;
                        LOG.info("Rolling upgrade of the ReplicationController: " + namespace + "/" + id);
                        if (this.rollingUpgradePreserveScale && newSpec != null && oldSpec != null && (replicas = oldSpec.getReplicas()) != null) {
                            newSpec.setReplicas(replicas);
                        }
                        LOG.info("rollingUpgradePreserveScale " + this.rollingUpgradePreserveScale + " new replicas is " + (newSpec != null ? newSpec.getReplicas() : "<null>"));
                        ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).rolling()).replace(replicationController);
                    } else if (this.isRecreateMode()) {
                        LOG.info("Deleting ReplicationController: " + id);
                        ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).delete();
                        this.doCreateReplicationController(replicationController, namespace, sourceName);
                    } else {
                        LOG.info("Updating ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
                        try {
                            Object answer = ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).withName(id)).replace(replicationController);
                            this.logGeneratedEntity("Updated replicationController: ", namespace, replicationController, answer);
                            if (this.deletePodsOnReplicationControllerUpdate) {
                                ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withLabels(newSpec.getSelector())).delete();
                                LOG.info("Deleting any pods for the replication controller to ensure they use the new configuration");
                                break block15;
                            }
                            LOG.info("Warning not deleted any pods so they could well be running with the old configuration!");
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                LOG.warn("Creation disabled so not creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
            } else {
                this.doCreateReplicationController(replicationController, namespace, sourceName);
            }
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        LOG.info("Creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(replicationController));
        try {
            PodTemplateSpec template;
            ReplicationControllerSpec spec = replicationController.getSpec();
            if (spec != null && (template = spec.getTemplate()) != null) {
                PodSpec podSpec = template.getSpec();
                this.validatePodSpec(podSpec, namespace);
            }
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).create(replicationController) : ((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(this.getNamespace())).create(replicationController);
            this.logGeneratedEntity("Created ReplicationController: ", namespace, replicationController, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    protected void validatePodSpec(PodSpec podSpec, String namespace) {
        List<Volume> volumes;
        if (this.requireSecretsCreatedBeforeReplicationControllers && (volumes = podSpec.getVolumes()) != null) {
            for (Volume volume : volumes) {
                String secretName;
                SecretVolumeSource secret = volume.getSecret();
                if (secret == null || !Strings.isNotBlank((String)(secretName = secret.getSecretName()))) continue;
                KubernetesHelper.validateSecretExists(this.kubernetesClient, namespace, secretName);
            }
        }
    }

    public void applyPod(Pod pod, String sourceName) throws Exception {
        String namespace = this.getNamespace();
        String id = KubernetesHelper.getName(pod);
        Objects.notNull((Object)id, (String)("No name for " + pod + " " + sourceName));
        if (this.isServicesOnlyMode()) {
            LOG.debug("Only processing Services right now so ignoring Pod: " + namespace + ":" + id);
            return;
        }
        Pod old = (Pod)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(pod, old)) {
                LOG.info("Pod has not changed so not doing anything");
            } else if (this.isRecreateMode()) {
                LOG.info("Deleting Pod: " + id);
                ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).delete();
                this.doCreatePod(pod, namespace, sourceName);
            } else {
                LOG.info("Updating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
                try {
                    Object answer = ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(id)).replace(pod);
                    LOG.info("Updated Pod result: " + answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update Pod from " + sourceName + ". " + e + ". " + pod, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            LOG.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
        } else {
            this.doCreatePod(pod, namespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        LOG.info("Creating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(pod));
        try {
            PodSpec podSpec = pod.getSpec();
            if (podSpec != null) {
                this.validatePodSpec(podSpec, namespace);
            }
            Object answer = Strings.isNotBlank((String)namespace) ? ((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).create(pod) : ((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.getNamespace())).create(pod);
            LOG.info("Created Pod result: " + answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    public String getNamespace() {
        return this.namesapce;
    }

    protected String getNamespace(HasMetadata entity) {
        String answer = KubernetesHelper.getNamespace(entity);
        if (Strings.isNullOrBlank((String)answer)) {
            answer = this.getNamespace();
        }
        this.applyNamespace(answer);
        return answer;
    }

    public void setNamespace(String namespace) {
        this.namesapce = namespace;
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public boolean isDeletePodsOnReplicationControllerUpdate() {
        return this.deletePodsOnReplicationControllerUpdate;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public File getLogJsonDir() {
        return this.logJsonDir;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected boolean isBound(PersistentVolumeClaim claim) {
        return claim != null && claim.getStatus() != null && "Bound".equals(claim.getStatus().getPhase());
    }

    protected void onApplyError(String message, Exception e) {
        LOG.error(message, (Throwable)e);
        if (this.throwExceptionOnError) {
            throw new RuntimeException(message, e);
        }
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isIgnoreBoundPersistentVolumeClaims() {
        return this.ignoreBoundPersistentVolumeClaims;
    }

    public void setIgnoreBoundPersistentVolumeClaims(boolean ignoreBoundPersistentVolumeClaims) {
        this.ignoreBoundPersistentVolumeClaims = ignoreBoundPersistentVolumeClaims;
    }

    public boolean isFailOnMissingParameterValue() {
        return this.failOnMissingParameterValue;
    }

    public void setFailOnMissingParameterValue(boolean failOnMissingParameterValue) {
        this.failOnMissingParameterValue = failOnMissingParameterValue;
    }

    public boolean isSupportOAuthClients() {
        return this.supportOAuthClients;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }

    public boolean isRequireSecretsCreatedBeforeReplicationControllers() {
        return this.requireSecretsCreatedBeforeReplicationControllers;
    }

    public void setRequireSecretsCreatedBeforeReplicationControllers(boolean requireSecretsCreatedBeforeReplicationControllers) {
        this.requireSecretsCreatedBeforeReplicationControllers = requireSecretsCreatedBeforeReplicationControllers;
    }

    public boolean isRollingUpgrade() {
        return this.rollingUpgrade;
    }

    public void setRollingUpgrade(boolean rollingUpgrade) {
        this.rollingUpgrade = rollingUpgrade;
    }

    public boolean isRollingUpgradePreserveScale() {
        return this.rollingUpgradePreserveScale;
    }

    public void setRollingUpgradePreserveScale(boolean rollingUpgradePreserveScale) {
        this.rollingUpgradePreserveScale = rollingUpgradePreserveScale;
    }
}

