/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.core.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.internal.config.AdapterConfigs;
import org.wso2.carbon.event.output.adapter.core.internal.ds.OutputEventAdapterServiceValueHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class EventAdapterConfigHelper {
    private static final Log log = LogFactory.getLog(EventAdapterConfigHelper.class);
    private static SecretResolver secretResolver;
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static void secureResolveDocument(Document doc) throws OutputEventAdapterException {
        Element element = doc.getDocumentElement();
        if (element != null) {
            try {
                EventAdapterConfigHelper.secureLoadElement(element);
            }
            catch (CryptoException e) {
                throw new OutputEventAdapterException("Error in secure load of global output event adapter properties: " + e.getMessage(), e);
            }
        }
    }

    public static void secureResolveOmElement(OMElement doc) throws OutputEventAdapterException {
        if (doc != null) {
            try {
                secretResolver = SecretResolverFactory.create((OMElement)doc, (boolean)true);
                EventAdapterConfigHelper.secureLoadOMElement(doc);
            }
            catch (CryptoException e) {
                throw new OutputEventAdapterException("Error in secure load of global output event adapter properties: " + e.getMessage(), e);
            }
        }
    }

    private static void secureLoadOMElement(OMElement element) throws CryptoException {
        String alias = MiscellaneousUtil.getProtectedToken((String)element.getText());
        if (alias != null && !alias.isEmpty()) {
            element.setText(EventAdapterConfigHelper.loadFromSecureVault(alias));
        } else {
            OMAttribute secureAttr = element.getAttribute(new QName("http://org.wso2.securevault/configuration", "secretAlias"));
            if (secureAttr != null) {
                element.setText(EventAdapterConfigHelper.loadFromSecureVault(secureAttr.getAttributeValue()));
                element.removeAttribute(secureAttr);
            }
        }
        Iterator childNodes = element.getChildElements();
        while (childNodes.hasNext()) {
            OMElement tmpNode = (OMElement)childNodes.next();
            EventAdapterConfigHelper.secureLoadOMElement(tmpNode);
        }
    }

    public static Document convertToDocument(File file) throws OutputEventAdapterException {
        DocumentBuilderFactory fac = EventAdapterConfigHelper.getSecuredDocumentBuilder();
        fac.setNamespaceAware(true);
        try {
            return fac.newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            throw new OutputEventAdapterException("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    public static OMElement convertToOmElement(File file) throws OutputEventAdapterException {
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(file));
            return builder.getDocumentElement();
        }
        catch (Exception e) {
            throw new OutputEventAdapterException("Error in creating an XML document from file: " + e.getMessage(), e);
        }
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    private static void secureLoadElement(Element element) throws CryptoException {
        Attr secureAttr = element.getAttributeNodeNS("http://org.wso2.securevault/configuration", "secretAlias");
        if (secureAttr != null) {
            element.setTextContent(EventAdapterConfigHelper.loadFromSecureVault(secureAttr.getValue()));
            element.removeAttributeNode(secureAttr);
        }
        NodeList childNodes = element.getChildNodes();
        int count = childNodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node tmpNode = childNodes.item(i);
            if (!(tmpNode instanceof Element)) continue;
            EventAdapterConfigHelper.secureLoadElement((Element)tmpNode);
        }
    }

    private static synchronized String loadFromSecureVault(String alias) {
        if (secretResolver == null) {
            secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
            secretResolver.init(OutputEventAdapterServiceValueHolder.getSecretCallbackHandlerService().getSecretCallbackHandler());
        }
        return secretResolver.resolve(alias);
    }

    public static AdapterConfigs loadGlobalConfigs() {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "output-event-adapters.xml";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AdapterConfigs.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            File configFile = new File(path);
            if (!configFile.exists()) {
                log.warn((Object)("output-event-adapters.xml can not found in " + path + ", hence Output Event Adapters will be running with default global configs."));
            }
            OMElement globalConfigDoc = EventAdapterConfigHelper.convertToOmElement(configFile);
            EventAdapterConfigHelper.secureResolveOmElement(globalConfigDoc);
            return (AdapterConfigs)unmarshaller.unmarshal(globalConfigDoc.getXMLStreamReader());
        }
        catch (JAXBException e) {
            log.error((Object)("Error in loading output-event-adapters.xml from " + path + ", hence Output Event Adapters will be running with default global configs."));
        }
        catch (OutputEventAdapterException e) {
            log.error((Object)"Error in converting output-event-adapters.xml to parsed document, hence Output Event Adapters will be running with default global configs.");
        }
        return new AdapterConfigs();
    }
}

