/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.core.internal.ds;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.internal.CarbonOutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.internal.ds.OutputEventAdapterServiceValueHolder;
import org.wso2.carbon.event.output.adapter.core.internal.util.EventAdapterConfigHelper;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="event.output.adapter.service", immediate=true)
public class OutputEventAdapterServiceDS {
    private static final Log log = LogFactory.getLog(OutputEventAdapterServiceDS.class);
    private static final List<OutputEventAdapterFactory> outputEventAdapterFactories = new ArrayList<OutputEventAdapterFactory>();

    @Activate
    protected void activate(ComponentContext context) {
        OutputEventAdapterServiceValueHolder.setGlobalAdapterConfigs(EventAdapterConfigHelper.loadGlobalConfigs());
        CarbonOutputEventAdapterService outputEventAdapterService = new CarbonOutputEventAdapterService();
        OutputEventAdapterServiceValueHolder.setCarbonOutputEventAdapterService(outputEventAdapterService);
        this.registerOutputEventAdapterFactories();
        context.getBundleContext().registerService(OutputEventAdapterService.class.getName(), (Object)outputEventAdapterService, null);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the output event adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the output event adapter service ", (Throwable)e);
        }
    }

    private void registerOutputEventAdapterFactories() {
        CarbonOutputEventAdapterService carbonOutputEventAdapterService = OutputEventAdapterServiceValueHolder.getCarbonOutputEventAdapterService();
        for (OutputEventAdapterFactory outputEventAdapterFactory : outputEventAdapterFactories) {
            carbonOutputEventAdapterService.registerEventAdapterFactory(outputEventAdapterFactory);
        }
    }

    @Reference(name="output.event.adapter.tracker.service", service=OutputEventAdapterFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unSetEventAdapterType")
    protected void setEventAdapterType(OutputEventAdapterFactory outputEventAdapterFactory) {
        try {
            if (OutputEventAdapterServiceValueHolder.getCarbonOutputEventAdapterService() != null) {
                OutputEventAdapterServiceValueHolder.getCarbonOutputEventAdapterService().registerEventAdapterFactory(outputEventAdapterFactory);
            } else {
                outputEventAdapterFactories.add(outputEventAdapterFactory);
            }
        }
        catch (Throwable t) {
            String outputEventAdapterFactoryClassName = "Unknown";
            if (outputEventAdapterFactory != null) {
                outputEventAdapterFactoryClassName = outputEventAdapterFactory.getClass().getName();
            }
            log.error((Object)("Unexpected error at initializing output event adapter factory " + outputEventAdapterFactoryClassName + ": " + t.getMessage()), t);
        }
    }

    protected void unSetEventAdapterType(OutputEventAdapterFactory outputEventAdapterFactory) {
        OutputEventAdapterServiceValueHolder.getCarbonOutputEventAdapterService().unRegisterEventAdapterFactory(outputEventAdapterFactory);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        OutputEventAdapterServiceValueHolder.setConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        OutputEventAdapterServiceValueHolder.setConfigurationContextService(null);
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        OutputEventAdapterServiceValueHolder.setSecretCallbackHandlerService(secretCallbackHandlerService);
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        OutputEventAdapterServiceValueHolder.setSecretCallbackHandlerService(null);
    }
}

