/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.core.internal;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.internal.DecayTimer;

public class OutputAdapterRuntime {
    private static final Log log = LogFactory.getLog(OutputAdapterRuntime.class);
    private final OutputEventAdapter outputEventAdapter;
    private final String name;
    private volatile boolean connected = false;
    private final DecayTimer timer = new DecayTimer();
    private volatile long nextConnectionTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputAdapterRuntime(OutputEventAdapter outputEventAdapter, String name) throws OutputEventAdapterException {
        this.outputEventAdapter = outputEventAdapter;
        this.name = name;
        OutputAdapterRuntime outputAdapterRuntime = this;
        synchronized (outputAdapterRuntime) {
            outputEventAdapter.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Object message, Map<String, String> dynamicProperties) {
        block21: {
            try {
                try {
                    if (this.connected) {
                        this.outputEventAdapter.publish(message, dynamicProperties);
                        break block21;
                    }
                    if (this.nextConnectionTime <= System.currentTimeMillis()) {
                        OutputAdapterRuntime outputAdapterRuntime = this;
                        synchronized (outputAdapterRuntime) {
                            if (!this.connected) {
                                if (this.nextConnectionTime <= System.currentTimeMillis()) {
                                    this.outputEventAdapter.connect();
                                    this.outputEventAdapter.publish(message, dynamicProperties);
                                    this.connected = true;
                                    this.timer.reset();
                                } else {
                                    this.logAndDrop(message);
                                }
                            } else {
                                this.outputEventAdapter.publish(message, dynamicProperties);
                            }
                            break block21;
                        }
                    }
                    this.logAndDrop(message);
                }
                catch (ConnectionUnavailableException e) {
                    this.connected = false;
                    if (this.nextConnectionTime <= System.currentTimeMillis()) {
                        OutputAdapterRuntime outputAdapterRuntime = this;
                        synchronized (outputAdapterRuntime) {
                            if (this.nextConnectionTime <= System.currentTimeMillis()) {
                                this.outputEventAdapter.disconnect();
                                this.timer.incrementPosition();
                                this.nextConnectionTime = System.currentTimeMillis() + this.timer.returnTimeToWait();
                                if (this.timer.returnTimeToWait() == 0L) {
                                    log.error((Object)("Connection unavailable for Output Adopter '" + this.name + "' reconnecting."), (Throwable)e);
                                    this.publish(message, dynamicProperties);
                                } else {
                                    log.error((Object)("Connection unavailable for Output Adopter '" + this.name + "' reconnection will be retried in " + this.timer.returnTimeToWait() + " milliseconds."), (Throwable)e);
                                }
                            } else {
                                this.logAndDrop(message);
                            }
                            break block21;
                        }
                    }
                    this.logAndDrop(message);
                }
            }
            catch (Throwable e) {
                EventAdapterUtil.logAndDrop(this.name, message, null, e, log, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            }
        }
    }

    private void logAndDrop(Object message) {
        log.error((Object)("Event dropped, Output Adapter '" + this.name + "' suspended, Adapter will be active after " + (this.nextConnectionTime - System.currentTimeMillis()) + " milliseconds."));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output Adapter '" + this.name + "' suspended, dropping event: /n" + message + "/n"));
        }
    }

    public void destroy() {
        try {
            this.outputEventAdapter.disconnect();
        }
        finally {
            this.outputEventAdapter.destroy();
        }
    }

    public boolean isPolled() {
        return this.outputEventAdapter.isPolled();
    }
}

