/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterSchema;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterService;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.core.internal.OutputAdapterRuntime;
import org.wso2.carbon.event.output.adapter.core.internal.ds.OutputEventAdapterServiceValueHolder;

public class CarbonOutputEventAdapterService
implements OutputEventAdapterService {
    private static Log log = LogFactory.getLog(CarbonOutputEventAdapterService.class);
    private final Map<String, OutputEventAdapterFactory> eventAdapterFactoryMap = new ConcurrentHashMap<String, OutputEventAdapterFactory>();
    private final ConcurrentHashMap<Integer, ConcurrentHashMap<String, OutputAdapterRuntime>> tenantSpecificEventAdapters = new ConcurrentHashMap();

    public void registerEventAdapterFactory(OutputEventAdapterFactory outputEventAdapterFactory) {
        OutputEventAdapterSchema outputEventAdapterSchema = outputEventAdapterFactory.getOutputEventAdapterSchema();
        this.eventAdapterFactoryMap.put(outputEventAdapterSchema.getType(), outputEventAdapterFactory);
    }

    public void unRegisterEventAdapterFactory(OutputEventAdapterFactory outputEventAdapterFactory) {
        OutputEventAdapterSchema outputEventAdapterSchema = outputEventAdapterFactory.getOutputEventAdapterSchema();
        this.eventAdapterFactoryMap.remove(outputEventAdapterSchema.getType());
    }

    @Override
    public List<String> getOutputEventAdapterTypes() {
        return new ArrayList<String>(this.eventAdapterFactoryMap.keySet());
    }

    @Override
    public OutputEventAdapterSchema getOutputEventAdapterSchema(String eventAdapterType) {
        OutputEventAdapterFactory outputEventAdapterFactory = this.eventAdapterFactoryMap.get(eventAdapterType);
        if (outputEventAdapterFactory != null) {
            return outputEventAdapterFactory.getOutputEventAdapterSchema();
        }
        return null;
    }

    @Override
    public void create(OutputEventAdapterConfiguration outputEventAdapterConfiguration) throws OutputEventAdapterException {
        OutputEventAdapterFactory adapterFactory;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, OutputAdapterRuntime> eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        if (eventAdapters == null) {
            this.tenantSpecificEventAdapters.putIfAbsent(tenantId, new ConcurrentHashMap());
            eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        }
        if ((adapterFactory = this.eventAdapterFactoryMap.get(outputEventAdapterConfiguration.getType())) == null) {
            throw new OutputEventAdapterException("Output Event Adapter not created as no adapter factory is registered with type " + outputEventAdapterConfiguration.getType());
        }
        if (outputEventAdapterConfiguration.getName() == null) {
            throw new OutputEventAdapterException("Output Event Adapter name cannot by null, for the adapter type " + outputEventAdapterConfiguration.getType());
        }
        if (eventAdapters.get(outputEventAdapterConfiguration.getName()) != null) {
            throw new OutputEventAdapterException("Output Event Adapter not created as another adapter with same name '" + outputEventAdapterConfiguration.getName() + "' already exist for tenant " + tenantId);
        }
        List<Property> staticPropertyList = adapterFactory.getStaticPropertyList();
        if (staticPropertyList != null) {
            Map<String, String> staticPropertyMap = outputEventAdapterConfiguration.getStaticProperties();
            for (Property property : staticPropertyList) {
                if (!property.isRequired()) continue;
                if (staticPropertyMap == null) {
                    throw new OutputEventAdapterException("Output Event Adapter not created as the 'staticProperties' are null, which means, the required property " + property.getPropertyName() + " is not  being set, for the adapter type " + outputEventAdapterConfiguration.getType());
                }
                if (staticPropertyMap.get(property.getPropertyName()) != null) continue;
                throw new OutputEventAdapterException("Output Event Adapter not created as the required property: " + property.getPropertyName() + " is not set, for the adapter type " + outputEventAdapterConfiguration.getType());
            }
        }
        Map<String, String> globalProperties = OutputEventAdapterServiceValueHolder.getGlobalAdapterConfigs().getAdapterConfig(outputEventAdapterConfiguration.getType()).getGlobalPropertiesAsMap();
        if (outputEventAdapterConfiguration.getStaticProperties() != null) {
            this.overrideGlobalPropertiesWithTenantProperties(globalProperties, outputEventAdapterConfiguration.getStaticProperties());
        }
        eventAdapters.put(outputEventAdapterConfiguration.getName(), new OutputAdapterRuntime(adapterFactory.createEventAdapter(outputEventAdapterConfiguration, globalProperties), outputEventAdapterConfiguration.getName()));
    }

    @Override
    public void publish(String name, Map<String, String> dynamicProperties, Object message) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, OutputAdapterRuntime> eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        if (eventAdapters == null) {
            throw new OutputEventAdapterRuntimeException("Event not published as no Output Event Adapter found with for tenant id " + tenantId);
        }
        OutputAdapterRuntime outputAdapterRuntime = eventAdapters.get(name);
        if (outputAdapterRuntime == null) {
            throw new OutputEventAdapterRuntimeException("Event not published as no Output Event Adapter found with name '" + name + "' for tenant id " + tenantId);
        }
        outputAdapterRuntime.publish(message, dynamicProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testConnection(OutputEventAdapterConfiguration outputEventAdapterConfiguration) throws OutputEventAdapterException, TestConnectionNotSupportedException {
        OutputEventAdapter outputEventAdapter = null;
        try {
            OutputEventAdapterFactory outputEventAdapterFactory = this.eventAdapterFactoryMap.get(outputEventAdapterConfiguration.getType());
            OutputEventAdapterFactory adapterFactory = this.eventAdapterFactoryMap.get(outputEventAdapterConfiguration.getType());
            if (adapterFactory == null) {
                throw new OutputEventAdapterException("Output Event Adapter not created as no adapter factory is registered with type " + outputEventAdapterConfiguration.getType());
            }
            if (outputEventAdapterConfiguration.getName() == null) {
                throw new OutputEventAdapterException("Output Event Adapter name cannot by null, for the adapter type " + outputEventAdapterConfiguration.getType());
            }
            Map<String, String> globalProperties = OutputEventAdapterServiceValueHolder.getGlobalAdapterConfigs().getAdapterConfig(outputEventAdapterConfiguration.getType()).getGlobalPropertiesAsMap();
            outputEventAdapter = outputEventAdapterFactory.createEventAdapter(outputEventAdapterConfiguration, globalProperties);
            outputEventAdapter.init();
            outputEventAdapter.testConnect();
            outputEventAdapter.disconnect();
            outputEventAdapter.destroy();
        }
        finally {
            if (outputEventAdapter != null) {
                outputEventAdapter.destroy();
            }
        }
    }

    @Override
    public void destroy(String name) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, OutputAdapterRuntime> eventAdapters = this.tenantSpecificEventAdapters.get(tenantId);
        if (eventAdapters == null) {
            return;
        }
        OutputAdapterRuntime outputAdapterRuntime = eventAdapters.remove(name);
        if (outputAdapterRuntime != null) {
            outputAdapterRuntime.destroy();
        }
    }

    @Override
    public boolean isPolled(String outputAdapterName) throws OutputEventAdapterException {
        OutputAdapterRuntime outputAdapterRuntime;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, OutputAdapterRuntime> inputRuntimeMap = this.tenantSpecificEventAdapters.get(tenantId);
        if (inputRuntimeMap != null && (outputAdapterRuntime = inputRuntimeMap.get(outputAdapterName)) != null) {
            return outputAdapterRuntime.isPolled();
        }
        throw new OutputEventAdapterException("Adopter with name'" + outputAdapterName + "' not found");
    }

    private void overrideGlobalPropertiesWithTenantProperties(Map<String, String> globalProps, Map<String, String> tenantProps) {
        for (String key : tenantProps.keySet()) {
            if (!globalProps.containsKey(key) || tenantProps.get(key) == null) continue;
            globalProps.put(key, tenantProps.get(key));
        }
    }
}

